/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage;

import com.terracottatech.offheapstore.storage.BinaryStorageEngine;
import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.storage.listener.AbstractListenableStorageEngine;
import com.terracottatech.offheapstore.storage.portability.Portability;
import com.terracottatech.offheapstore.storage.portability.WriteBackPortability;
import com.terracottatech.offheapstore.storage.portability.WriteContext;
import java.nio.ByteBuffer;

public abstract class PortabilityBasedStorageEngine<K, V>
extends AbstractListenableStorageEngine<K, V>
implements StorageEngine<K, V>,
BinaryStorageEngine {
    protected final Portability<? super K> keyPortability;
    protected final Portability<? super V> valuePortability;
    private CachedEncode<K, V> lastMapping;

    public PortabilityBasedStorageEngine(Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        this.keyPortability = keyPortability;
        this.valuePortability = valuePortability;
    }

    @Override
    public final Long writeMapping(K key, V value, int hash, int metadata) {
        Long result;
        if (this.lastMapping != null && this.lastMapping.getKey() == key && this.lastMapping.getValue() == value) {
            result = this.writeMappingBuffers(this.lastMapping.getEncodedKey(), this.lastMapping.getEncodedValue(), hash);
        } else {
            ByteBuffer keyBuffer = this.keyPortability.encode(key);
            ByteBuffer valueBuffer = this.valuePortability.encode(value);
            result = this.writeMappingBuffers(keyBuffer.duplicate(), valueBuffer.duplicate(), hash);
            this.lastMapping = new CachedEncode<K, V>(key, value, keyBuffer, valueBuffer, result);
        }
        if (result != null) {
            this.fireWritten(key, value, this.lastMapping.getEncodedKey(), this.lastMapping.getEncodedValue(), hash, metadata, result);
        }
        return result;
    }

    @Override
    public void attachedMapping(long encoding, int hash, int metadata) {
    }

    @Override
    public final void freeMapping(long encoding, int hash, boolean removal) {
        if (this.hasListeners()) {
            ByteBuffer binaryKey = this.readBinaryKey(encoding);
            this.free(encoding);
            this.fireFreed(encoding, hash, binaryKey, removal);
        } else {
            this.free(encoding);
        }
    }

    @Override
    public final void clear() {
        this.clearInternal();
        this.fireCleared();
    }

    @Override
    public V readValue(long encoding) {
        if (this.valuePortability instanceof WriteBackPortability) {
            return (V)((WriteBackPortability)this.valuePortability).decode(this.readValueBuffer(encoding), this.getValueWriteContext(encoding));
        }
        return this.valuePortability.decode(this.readValueBuffer(encoding));
    }

    @Override
    public boolean equalsValue(Object value, long encoding) {
        return this.valuePortability.equals(value, this.readValueBuffer(encoding));
    }

    @Override
    public K readKey(long encoding, int hashCode) {
        if (this.keyPortability instanceof WriteBackPortability) {
            return (K)((WriteBackPortability)this.keyPortability).decode(this.readKeyBuffer(encoding), this.getKeyWriteContext(encoding));
        }
        return this.keyPortability.decode(this.readKeyBuffer(encoding));
    }

    @Override
    public boolean equalsKey(Object key, long encoding) {
        return this.keyPortability.equals(key, this.readKeyBuffer(encoding));
    }

    @Override
    public ByteBuffer readBinaryKey(long encoding) {
        Long cachedEncoding;
        CachedEncode<K, V> cache = this.lastMapping;
        if (cache != null && (cachedEncoding = cache.getEncoding()) != null && cachedEncoding == encoding) {
            return cache.getEncodedKey();
        }
        ByteBuffer attached = this.readKeyBuffer(encoding);
        ByteBuffer detached = ByteBuffer.allocate(attached.remaining());
        detached.put(attached).flip();
        return detached;
    }

    @Override
    public ByteBuffer readBinaryValue(long encoding) {
        Long cachedEncoding;
        CachedEncode<K, V> cache = this.lastMapping;
        if (cache != null && (cachedEncoding = cache.getEncoding()) != null && cachedEncoding == encoding) {
            return cache.getEncodedValue();
        }
        ByteBuffer attached = this.readValueBuffer(encoding);
        ByteBuffer detached = ByteBuffer.allocate(attached.remaining());
        detached.put(attached).flip();
        return detached;
    }

    @Override
    public boolean equalsBinaryKey(ByteBuffer binaryKey, long encoding) {
        return binaryKey.equals(this.readBinaryKey(encoding)) || this.equalsKey(this.keyPortability.decode(binaryKey.duplicate()), encoding);
    }

    @Override
    public Long writeBinaryMapping(ByteBuffer[] binaryKey, ByteBuffer[] binaryValue, int pojoHash, int metadata) {
        return this.writeMappingBuffersGathering(binaryKey, binaryValue, pojoHash);
    }

    @Override
    public Long writeBinaryMapping(ByteBuffer binaryKey, ByteBuffer binaryValue, int pojoHash, int metadata) {
        return this.writeMappingBuffers(binaryKey, binaryValue, pojoHash);
    }

    protected Long writeMappingBuffersGathering(ByteBuffer[] keyBuffers, ByteBuffer[] valueBuffers, int hash) {
        return this.writeMappingBuffers(PortabilityBasedStorageEngine.aggregate(keyBuffers), PortabilityBasedStorageEngine.aggregate(valueBuffers), hash);
    }

    protected abstract void free(long var1);

    protected abstract void clearInternal();

    protected abstract ByteBuffer readKeyBuffer(long var1);

    protected abstract WriteContext getKeyWriteContext(long var1);

    protected abstract ByteBuffer readValueBuffer(long var1);

    protected abstract WriteContext getValueWriteContext(long var1);

    protected abstract Long writeMappingBuffers(ByteBuffer var1, ByteBuffer var2, int var3);

    @Override
    public void invalidateCache() {
        this.lastMapping = null;
    }

    protected static int dataLength(ByteBuffer[] buffers) {
        int total = 0;
        for (ByteBuffer buffer : buffers) {
            total += buffer.remaining();
        }
        return total;
    }

    private static final ByteBuffer aggregate(ByteBuffer[] buffers) {
        if (buffers.length == 1) {
            return buffers[0];
        }
        ByteBuffer aggregate = ByteBuffer.allocate(PortabilityBasedStorageEngine.dataLength(buffers));
        for (ByteBuffer element : buffers) {
            aggregate.put(element);
        }
        return (ByteBuffer)aggregate.flip();
    }

    static class CachedEncode<K, V> {
        private final K key;
        private final V value;
        private final ByteBuffer keyBuffer;
        private final ByteBuffer valueBuffer;
        private final Long encoding;

        public CachedEncode(K key, V value, ByteBuffer keyBuffer, ByteBuffer valueBuffer, Long encoding) {
            this.key = key;
            this.value = value;
            this.keyBuffer = keyBuffer;
            this.valueBuffer = valueBuffer;
            this.encoding = encoding;
        }

        final K getKey() {
            return this.key;
        }

        final V getValue() {
            return this.value;
        }

        final ByteBuffer getEncodedKey() {
            return this.keyBuffer.duplicate();
        }

        final ByteBuffer getEncodedValue() {
            return this.valueBuffer.duplicate();
        }

        final Long getEncoding() {
            return this.encoding;
        }
    }
}

