/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.manager.selector;

import javax.transaction.TransactionManager;
import net.sf.ehcache.transaction.manager.selector.Selector;
import net.sf.ehcache.util.ClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassSelector
extends Selector {
    private static final Logger LOG = LoggerFactory.getLogger(ClassSelector.class);
    private final String classname;

    public ClassSelector(String vendor, String classname) {
        super(vendor);
        this.classname = classname;
    }

    protected TransactionManager doLookup() {
        TransactionManager transactionManager = null;
        try {
            Class txManagerClass = ClassLoaderUtil.loadClass(this.classname);
            transactionManager = (TransactionManager)txManagerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            LOG.debug("FactorySelector failed lookup", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.debug("FactorySelector failed lookup", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.debug("FactorySelector failed lookup", (Throwable)e);
        }
        return transactionManager;
    }
}

