/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.statistics.sampled;

import net.sf.ehcache.statistics.CacheUsageListener;
import net.sf.ehcache.statistics.sampled.CacheStatisticsSampler;
import net.sf.ehcache.statistics.sampled.NullSampledCacheStatistics;
import net.sf.ehcache.statistics.sampled.SampledCacheStatistics;
import net.sf.ehcache.statistics.sampled.SampledCacheStatisticsImpl;
import net.sf.ehcache.util.FailSafeTimer;
import net.sf.ehcache.util.counter.sampled.SampledCounter;
import net.sf.ehcache.util.counter.sampled.SampledCounterConfig;
import net.sf.ehcache.util.counter.sampled.SampledRateCounter;
import net.sf.ehcache.util.counter.sampled.SampledRateCounterConfig;

public class SampledCacheStatisticsWrapper
implements CacheUsageListener,
CacheStatisticsSampler {
    private static final NullSampledCacheStatistics NULL_SAMPLED_CACHE_STATISTICS = new NullSampledCacheStatistics();
    private volatile SampledCacheStatistics delegate = new NullSampledCacheStatistics();
    private volatile CacheStatisticsSampler samplerDelegate;

    public void enableSampledStatistics(FailSafeTimer timer) {
        this.enableSampledStatistics(new SampledCacheStatisticsImpl(timer));
    }

    public void enableSampledStatistics(FailSafeTimer timer, SampledCounterConfig config, SampledRateCounterConfig rateGetConfig, SampledRateCounterConfig rateSearchConfig) {
        this.enableSampledStatistics(new SampledCacheStatisticsImpl(timer, config, rateGetConfig, rateSearchConfig));
    }

    private void enableSampledStatistics(SampledCacheStatisticsImpl sampledCacheStats) {
        this.delegate.dispose();
        this.samplerDelegate = sampledCacheStats;
        this.delegate = sampledCacheStats;
    }

    public void disableSampledStatistics() {
        this.delegate.dispose();
        this.delegate = NULL_SAMPLED_CACHE_STATISTICS;
        this.samplerDelegate = null;
    }

    public boolean isSampledStatisticsEnabled() {
        return this.delegate instanceof SampledCacheStatisticsImpl;
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public long getAverageGetTimeMostRecentSample() {
        return this.delegate.getAverageGetTimeMostRecentSample();
    }

    public long getAverageGetTimeNanosMostRecentSample() {
        return this.delegate.getAverageGetTimeNanosMostRecentSample();
    }

    public long getCacheElementEvictedMostRecentSample() {
        return this.delegate.getCacheElementEvictedMostRecentSample();
    }

    public long getCacheElementExpiredMostRecentSample() {
        return this.delegate.getCacheElementExpiredMostRecentSample();
    }

    public long getCacheElementPutMostRecentSample() {
        return this.delegate.getCacheElementPutMostRecentSample();
    }

    public long getCacheElementRemovedMostRecentSample() {
        return this.delegate.getCacheElementRemovedMostRecentSample();
    }

    public long getCacheElementUpdatedMostRecentSample() {
        return this.delegate.getCacheElementUpdatedMostRecentSample();
    }

    public long getCacheHitInMemoryMostRecentSample() {
        return this.delegate.getCacheHitInMemoryMostRecentSample();
    }

    public long getCacheHitOffHeapMostRecentSample() {
        return this.delegate.getCacheHitOffHeapMostRecentSample();
    }

    public long getCacheHitMostRecentSample() {
        return this.delegate.getCacheHitMostRecentSample();
    }

    public long getCacheHitOnDiskMostRecentSample() {
        return this.delegate.getCacheHitOnDiskMostRecentSample();
    }

    public long getCacheMissExpiredMostRecentSample() {
        return this.delegate.getCacheMissExpiredMostRecentSample();
    }

    public long getCacheMissMostRecentSample() {
        return this.delegate.getCacheMissMostRecentSample();
    }

    public long getCacheMissInMemoryMostRecentSample() {
        return this.delegate.getCacheMissInMemoryMostRecentSample();
    }

    public long getCacheMissOffHeapMostRecentSample() {
        return this.delegate.getCacheMissOffHeapMostRecentSample();
    }

    public long getCacheMissOnDiskMostRecentSample() {
        return this.delegate.getCacheMissOnDiskMostRecentSample();
    }

    public long getCacheMissNotFoundMostRecentSample() {
        return this.delegate.getCacheMissNotFoundMostRecentSample();
    }

    public int getStatisticsAccuracy() {
        return this.delegate.getStatisticsAccuracy();
    }

    public void clearStatistics() {
        this.delegate.clearStatistics();
    }

    public String getStatisticsAccuracyDescription() {
        return this.delegate.getStatisticsAccuracyDescription();
    }

    private CacheUsageListener getDelegateAsListener() {
        return (CacheUsageListener)((Object)this.delegate);
    }

    public void notifyCacheElementEvicted() {
        this.getDelegateAsListener().notifyCacheElementEvicted();
    }

    public void notifyCacheElementExpired() {
        this.getDelegateAsListener().notifyCacheElementExpired();
    }

    public void notifyCacheElementPut() {
        this.getDelegateAsListener().notifyCacheElementPut();
    }

    public void notifyCacheElementRemoved() {
        this.getDelegateAsListener().notifyCacheElementRemoved();
    }

    public void notifyCacheElementUpdated() {
        this.getDelegateAsListener().notifyCacheElementUpdated();
    }

    public void notifyCacheHitInMemory() {
        this.getDelegateAsListener().notifyCacheHitInMemory();
    }

    public void notifyCacheHitOffHeap() {
        this.getDelegateAsListener().notifyCacheHitOffHeap();
    }

    public void notifyCacheHitOnDisk() {
        this.getDelegateAsListener().notifyCacheHitOnDisk();
    }

    public void notifyCacheMissedWithExpired() {
        this.getDelegateAsListener().notifyCacheMissedWithExpired();
    }

    public void notifyCacheMissedWithNotFound() {
        this.getDelegateAsListener().notifyCacheMissedWithNotFound();
    }

    public void notifyCacheMissInMemory() {
        this.getDelegateAsListener().notifyCacheMissInMemory();
    }

    public void notifyCacheMissOffHeap() {
        this.getDelegateAsListener().notifyCacheMissOffHeap();
    }

    public void notifyCacheMissOnDisk() {
        this.getDelegateAsListener().notifyCacheMissOnDisk();
    }

    public void notifyRemoveAll() {
        this.getDelegateAsListener().notifyRemoveAll();
    }

    public void notifyStatisticsAccuracyChanged(int statisticsAccuracy) {
        this.getDelegateAsListener().notifyStatisticsAccuracyChanged(statisticsAccuracy);
    }

    public void notifyStatisticsCleared() {
        this.getDelegateAsListener().notifyStatisticsCleared();
    }

    public void notifyStatisticsEnabledChanged(boolean enableStatistics) {
        this.getDelegateAsListener().notifyStatisticsEnabledChanged(enableStatistics);
    }

    public void notifyTimeTakenForGet(long millis) {
    }

    public void notifyGetTimeNanos(long nanos) {
        this.getDelegateAsListener().notifyGetTimeNanos(nanos);
    }

    public long getAverageSearchTime() {
        return this.delegate.getAverageSearchTime();
    }

    public long getSearchesPerSecond() {
        return this.delegate.getSearchesPerSecond();
    }

    public void notifyCacheSearch(long executeTime) {
        this.getDelegateAsListener().notifyCacheSearch(executeTime);
    }

    public void notifyXaCommit() {
        this.getDelegateAsListener().notifyXaCommit();
    }

    public void notifyXaRollback() {
        this.getDelegateAsListener().notifyXaRollback();
    }

    public long getCacheXaCommitsMostRecentSample() {
        return this.delegate.getCacheXaCommitsMostRecentSample();
    }

    public long getCacheXaRollbacksMostRecentSample() {
        return this.delegate.getCacheXaRollbacksMostRecentSample();
    }

    public SampledCounter getCacheHitSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheHitSample();
    }

    public SampledCounter getCacheHitInMemorySample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheHitInMemorySample();
    }

    public SampledCounter getCacheHitOffHeapSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheHitOffHeapSample();
    }

    public SampledCounter getCacheHitOnDiskSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheHitOnDiskSample();
    }

    public SampledCounter getCacheMissSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheMissSample();
    }

    public SampledCounter getCacheMissInMemorySample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheHitInMemorySample();
    }

    public SampledCounter getCacheMissOffHeapSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheMissOffHeapSample();
    }

    public SampledCounter getCacheMissOnDiskSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheMissOnDiskSample();
    }

    public SampledCounter getCacheMissExpiredSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheMissExpiredSample();
    }

    public SampledCounter getCacheMissNotFoundSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheMissNotFoundSample();
    }

    public SampledCounter getCacheElementEvictedSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheElementEvictedSample();
    }

    public SampledCounter getCacheElementRemovedSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheElementRemovedSample();
    }

    public SampledCounter getCacheElementExpiredSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheElementExpiredSample();
    }

    public SampledCounter getCacheElementPutSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheElementPutSample();
    }

    public SampledCounter getCacheElementUpdatedSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheElementUpdatedSample();
    }

    public SampledRateCounter getAverageGetTimeSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getAverageGetTimeSample();
    }

    public SampledRateCounter getAverageGetTimeNanosSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getAverageGetTimeNanosSample();
    }

    public SampledRateCounter getAverageSearchTimeSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getAverageSearchTimeSample();
    }

    public SampledCounter getSearchesPerSecondSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getSearchesPerSecondSample();
    }

    public SampledCounter getCacheXaCommitsSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheXaCommitsSample();
    }

    public SampledCounter getCacheXaRollbacksSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheXaRollbacksSample();
    }

    public int getCacheHitRatioMostRecentSample() {
        return this.delegate.getCacheHitRatioMostRecentSample();
    }

    public SampledCounter getCacheHitRatioSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheHitRatioSample();
    }
}

