/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.writer.writebehind.operations;

import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.Element;
import net.sf.ehcache.writer.CacheWriter;
import net.sf.ehcache.writer.writebehind.operations.BatchOperation;
import net.sf.ehcache.writer.writebehind.operations.DeleteAllOperation;
import net.sf.ehcache.writer.writebehind.operations.SingleOperation;
import net.sf.ehcache.writer.writebehind.operations.SingleOperationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteOperation
implements SingleOperation {
    private final CacheEntry entry;
    private final long creationTime;

    public DeleteOperation(CacheEntry entry) {
        this(entry, System.currentTimeMillis());
    }

    public DeleteOperation(CacheEntry entry, long creationTime) {
        this.entry = this.duplicateCacheEntryElement(entry);
        this.creationTime = creationTime;
    }

    private CacheEntry duplicateCacheEntryElement(CacheEntry entry) {
        if (null == entry.getElement()) {
            return entry;
        }
        Element element = entry.getElement();
        return new CacheEntry(entry.getKey(), new Element(element.getObjectKey(), element.getObjectValue(), element.getVersion(), element.getCreationTime(), element.getLastAccessTime(), element.getHitCount(), false, element.getTimeToLive(), element.getTimeToIdle(), element.getLastUpdateTime()));
    }

    @Override
    public void performSingleOperation(CacheWriter cacheWriter) {
        cacheWriter.delete(this.entry);
    }

    @Override
    public BatchOperation createBatchOperation(List<SingleOperation> operations) {
        ArrayList<CacheEntry> entries = new ArrayList<CacheEntry>();
        for (SingleOperation operation : operations) {
            entries.add(((DeleteOperation)operation).entry);
        }
        return new DeleteAllOperation(entries);
    }

    @Override
    public Object getKey() {
        return this.entry.getKey();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    public CacheEntry getEntry() {
        return this.entry;
    }

    @Override
    public SingleOperationType getType() {
        return SingleOperationType.DELETE;
    }

    @Override
    public void throwAway(CacheWriter cacheWriter, RuntimeException e) {
        Element element = this.entry.getElement();
        if (element == null) {
            element = new Element(this.entry.getKey(), null);
        }
        cacheWriter.throwAway(element, SingleOperationType.DELETE, e);
    }
}

