/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.ObjectExistsException;
import net.sf.ehcache.Status;
import net.sf.ehcache.TerracottaClusteredInstanceHelper;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.cluster.ClusterScheme;
import net.sf.ehcache.cluster.ClusterSchemeNotAvailableException;
import net.sf.ehcache.cluster.NoopCacheCluster;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.ConfigurationHelper;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import net.sf.ehcache.config.generator.ConfigurationUtil;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerRegistry;
import net.sf.ehcache.management.provider.MBeanRegistrationProvider;
import net.sf.ehcache.management.provider.MBeanRegistrationProviderException;
import net.sf.ehcache.management.provider.MBeanRegistrationProviderFactory;
import net.sf.ehcache.management.provider.MBeanRegistrationProviderFactoryImpl;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.compound.impl.MemoryOnlyStore;
import net.sf.ehcache.terracotta.ClusteredInstanceFactory;
import net.sf.ehcache.transaction.manager.TransactionManagerLookup;
import net.sf.ehcache.transaction.xa.EhcacheXAStore;
import net.sf.ehcache.transaction.xa.EhcacheXAStoreImpl;
import net.sf.ehcache.util.FailSafeTimer;
import net.sf.ehcache.util.PropertyUtil;
import net.sf.ehcache.util.UpdateChecker;
import net.sf.ehcache.writer.writebehind.WriteBehind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManager {
    public static final String DEFAULT_NAME = "__DEFAULT__";
    public static final List<CacheManager> ALL_CACHE_MANAGERS = new CopyOnWriteArrayList<CacheManager>();
    public static final String ENABLE_SHUTDOWN_HOOK_PROPERTY = "net.sf.ehcache.enableShutdownHook";
    private static final Logger LOG = LoggerFactory.getLogger(CacheManager.class);
    private static final long EVERY_WEEK = 604800000L;
    private static final long DELAY_UPDATE_CHECK = 1000L;
    private static volatile CacheManager singleton;
    private static MBeanRegistrationProviderFactory mBeanRegistrationProviderFactory;
    protected String name;
    protected Status status;
    protected Map<String, CacheManagerPeerProvider> cacheManagerPeerProviders = new ConcurrentHashMap<String, CacheManagerPeerProvider>();
    protected Map<String, CacheManagerPeerListener> cacheManagerPeerListeners = new ConcurrentHashMap<String, CacheManagerPeerListener>();
    protected CacheManagerEventListenerRegistry cacheManagerEventListenerRegistry = new CacheManagerEventListenerRegistry();
    protected Thread shutdownHook;
    private final ConcurrentMap<String, Ehcache> ehcaches = new ConcurrentHashMap<String, Ehcache>();
    private Ehcache defaultCache;
    private String diskStorePath;
    private MBeanRegistrationProvider mbeanRegistrationProvider;
    private FailSafeTimer cacheManagerTimer;
    private volatile ClusteredInstanceFactory terracottaClusteredInstanceFactory;
    private TerracottaClientConfiguration terracottaClientConfiguration;
    private AtomicBoolean terracottaClusteredInstanceFactoryCreated = new AtomicBoolean(false);
    private Configuration configuration;
    private volatile boolean allowsDynamicCacheConfig = true;
    private volatile TransactionManagerLookup transactionManagerLookup;

    public CacheManager(Configuration configuration) throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(configuration, null, null, null);
    }

    public CacheManager(String configurationFileName) throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(null, configurationFileName, null, null);
    }

    public CacheManager(URL configurationURL) throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(null, null, configurationURL, null);
    }

    public CacheManager(InputStream configurationInputStream) throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(null, null, null, configurationInputStream);
    }

    public CacheManager() throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(null, null, null, null);
    }

    protected void init(Configuration configuration, String configurationFileName, URL configurationURL, InputStream configurationInputStream) {
        Configuration localConfiguration = configuration;
        this.configuration = configuration == null ? (localConfiguration = this.parseConfiguration(configurationFileName, configurationURL, configurationInputStream)) : configuration;
        if (localConfiguration.getName() != null) {
            this.name = localConfiguration.getName();
        }
        this.allowsDynamicCacheConfig = localConfiguration.getDynamicConfig();
        this.terracottaClientConfiguration = localConfiguration.getTerracottaConfiguration();
        Map<String, CacheConfiguration> cacheConfigs = localConfiguration.getCacheConfigurations();
        if (localConfiguration.getDefaultCacheConfiguration() != null && localConfiguration.getDefaultCacheConfiguration().isTerracottaClustered()) {
            this.terracottaClusteredInstanceFactory = TerracottaClusteredInstanceHelper.newClusteredInstanceFactory(cacheConfigs, localConfiguration.getTerracottaConfiguration());
        } else {
            for (CacheConfiguration config : cacheConfigs.values()) {
                if (!config.isTerracottaClustered()) continue;
                this.terracottaClusteredInstanceFactory = TerracottaClusteredInstanceHelper.newClusteredInstanceFactory(cacheConfigs, localConfiguration.getTerracottaConfiguration());
                break;
            }
        }
        if (this.terracottaClusteredInstanceFactory != null && this.name == null) {
            this.name = DEFAULT_NAME;
        }
        ConfigurationHelper configurationHelper = new ConfigurationHelper(this, localConfiguration);
        this.configure(configurationHelper);
        this.status = Status.STATUS_ALIVE;
        for (CacheManagerPeerProvider cacheManagerPeerProvider : this.cacheManagerPeerProviders.values()) {
            cacheManagerPeerProvider.init();
        }
        this.cacheManagerEventListenerRegistry.init();
        this.addShutdownHookIfRequired();
        this.cacheManagerTimer = new FailSafeTimer(this.getName());
        this.checkForUpdateIfNeeded(localConfiguration.getUpdateCheck());
        this.terracottaClusteredInstanceFactoryCreated.set(this.terracottaClusteredInstanceFactory != null);
        this.addConfiguredCaches(configurationHelper);
        this.initializeMBeanRegistrationProvider(localConfiguration);
    }

    public String getClusterUUID() {
        if (this.terracottaClusteredInstanceFactory != null) {
            return CacheManager.getClientUUID(this.terracottaClusteredInstanceFactory);
        }
        return "";
    }

    private static String getClientUUID(ClusteredInstanceFactory clusteredInstanceFactory) {
        try {
            Class<?> c = clusteredInstanceFactory.getClass();
            Method m = c.getMethod("getUUID", new Class[0]);
            if (m == null) {
                return null;
            }
            return (String)m.invoke((Object)clusteredInstanceFactory, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void initializeMBeanRegistrationProvider(Configuration localConfiguration) {
        this.mbeanRegistrationProvider = mBeanRegistrationProviderFactory.createMBeanRegistrationProvider(localConfiguration);
        try {
            this.mbeanRegistrationProvider.initialize(this, this.terracottaClusteredInstanceFactory);
        }
        catch (MBeanRegistrationProviderException e) {
            LOG.warn("Failed to initialize the MBeanRegistrationProvider - " + this.mbeanRegistrationProvider.getClass().getName(), (Throwable)e);
        }
    }

    public Store createTerracottaStore(Ehcache cache) {
        return this.getClusteredInstanceFactory(cache).createStore(cache);
    }

    public WriteBehind createTerracottaWriteBehind(Ehcache cache) {
        return this.getClusteredInstanceFactory(cache).createWriteBehind(cache);
    }

    public CacheEventListener createTerracottaEventReplicator(Ehcache cache) {
        return this.getClusteredInstanceFactory(cache).createEventReplicator(cache);
    }

    EhcacheXAStore createEhcacheXAStore(Ehcache cache, Store store, boolean bypassValidation) {
        EhcacheXAStore ehcacheXAStore = cache.getCacheConfiguration().isTerracottaClustered() ? this.getClusteredInstanceFactory(cache).createXAStore(cache, store, bypassValidation) : new EhcacheXAStoreImpl(store, MemoryOnlyStore.create((Cache)cache, null), bypassValidation);
        return ehcacheXAStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusteredInstanceFactory getClusteredInstanceFactory(Ehcache cache) {
        if (null == this.terracottaClusteredInstanceFactory) {
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                if (!this.terracottaClusteredInstanceFactoryCreated.getAndSet(true)) {
                    HashMap<String, CacheConfiguration> map = new HashMap<String, CacheConfiguration>(1);
                    map.put(cache.getName(), cache.getCacheConfiguration());
                    this.terracottaClusteredInstanceFactory = TerracottaClusteredInstanceHelper.newClusteredInstanceFactory(map, this.terracottaClientConfiguration);
                    try {
                        this.mbeanRegistrationProvider.reinitialize(this.terracottaClusteredInstanceFactory);
                    }
                    catch (MBeanRegistrationProviderException e) {
                        LOG.warn("Failed to initialize the MBeanRegistrationProvider - " + this.mbeanRegistrationProvider.getClass().getName(), (Throwable)e);
                    }
                }
            }
        }
        return this.terracottaClusteredInstanceFactory;
    }

    private void checkForUpdateIfNeeded(boolean updateCheckNeeded) {
        try {
            if (updateCheckNeeded) {
                UpdateChecker updateChecker = new UpdateChecker();
                this.cacheManagerTimer.scheduleAtFixedRate((TimerTask)updateChecker, 1000L, 604800000L);
            }
        }
        catch (Throwable t) {
            LOG.debug("Failed to set up update checker", t);
        }
    }

    private synchronized Configuration parseConfiguration(String configurationFileName, URL configurationURL, InputStream configurationInputStream) throws CacheException {
        Configuration parsedConfig;
        this.reinitialisationCheck();
        if (configurationFileName != null) {
            LOG.debug("Configuring CacheManager from {}", (Object)configurationFileName);
            parsedConfig = ConfigurationFactory.parseConfiguration(new File(configurationFileName));
        } else if (configurationURL != null) {
            parsedConfig = ConfigurationFactory.parseConfiguration(configurationURL);
        } else if (configurationInputStream != null) {
            parsedConfig = ConfigurationFactory.parseConfiguration(configurationInputStream);
        } else {
            LOG.debug("Configuring ehcache from classpath.");
            parsedConfig = ConfigurationFactory.parseConfiguration();
        }
        return parsedConfig;
    }

    private void configure(ConfigurationHelper configurationHelper) {
        this.diskStorePath = configurationHelper.getDiskStorePath();
        int cachesRequiringDiskStores = configurationHelper.numberOfCachesThatOverflowToDisk() + configurationHelper.numberOfCachesThatAreDiskPersistent();
        if (this.diskStorePath == null && cachesRequiringDiskStores > 0) {
            this.diskStorePath = DiskStoreConfiguration.getDefaultPath();
            LOG.warn("One or more caches require a DiskStore but there is no diskStore element configured. Using the default disk store path of " + DiskStoreConfiguration.getDefaultPath() + ". Please explicitly configure the diskStore element in ehcache.xml.");
        }
        FactoryConfiguration lookupConfiguration = this.configuration.getTransactionManagerLookupConfiguration();
        try {
            Properties properties = PropertyUtil.parseProperties(lookupConfiguration.getProperties(), lookupConfiguration.getPropertySeparator());
            Class<?> transactionManagerLookupClass = Class.forName(lookupConfiguration.getFullyQualifiedClassPath());
            this.transactionManagerLookup = (TransactionManagerLookup)transactionManagerLookupClass.newInstance();
            this.transactionManagerLookup.setProperties(properties);
        }
        catch (Exception e) {
            LOG.error("could not instantiate transaction manager lookup class: {}", (Object)lookupConfiguration.getFullyQualifiedClassPath(), (Object)e);
        }
        this.detectAndFixDiskStorePathConflict(configurationHelper);
        this.cacheManagerEventListenerRegistry.registerListener(configurationHelper.createCacheManagerEventListener());
        this.cacheManagerPeerListeners = configurationHelper.createCachePeerListeners();
        for (CacheManagerPeerListener cacheManagerPeerListener : this.cacheManagerPeerListeners.values()) {
            this.cacheManagerEventListenerRegistry.registerListener(cacheManagerPeerListener);
        }
        this.detectAndFixCacheManagerPeerListenerConflict(configurationHelper);
        ALL_CACHE_MANAGERS.add(this);
        this.cacheManagerPeerProviders = configurationHelper.createCachePeerProviders();
        this.defaultCache = configurationHelper.createDefaultCache();
    }

    private void detectAndFixDiskStorePathConflict(ConfigurationHelper configurationHelper) {
        if (this.diskStorePath == null) {
            LOG.debug("No disk store path defined. Skipping disk store path conflict test.");
            return;
        }
        for (CacheManager cacheManager : ALL_CACHE_MANAGERS) {
            if (!this.diskStorePath.equals(cacheManager.diskStorePath)) continue;
            String newDiskStorePath = this.diskStorePath + File.separator + DiskStore.generateUniqueDirectory();
            LOG.warn("Creating a new instance of CacheManager using the diskStorePath \"" + this.diskStorePath + "\" which is already used" + " by an existing CacheManager.\nThe source of the configuration was " + configurationHelper.getConfigurationBean().getConfigurationSource() + ".\n" + "The diskStore path for this CacheManager will be set to " + newDiskStorePath + ".\nTo avoid this" + " warning consider using the CacheManager factory methods to create a singleton CacheManager " + "or specifying a separate ehcache configuration (ehcache.xml) for each CacheManager instance.");
            this.diskStorePath = newDiskStorePath;
            break;
        }
    }

    private void detectAndFixCacheManagerPeerListenerConflict(ConfigurationHelper configurationHelper) {
        if (this.cacheManagerPeerListeners == null) {
            return;
        }
        for (CacheManagerPeerListener cacheManagerPeerListener : this.cacheManagerPeerListeners.values()) {
            String uniqueResourceIdentifier = cacheManagerPeerListener.getUniqueResourceIdentifier();
            block1: for (CacheManager cacheManager : ALL_CACHE_MANAGERS) {
                for (CacheManagerPeerListener otherCacheManagerPeerListener : cacheManager.cacheManagerPeerListeners.values()) {
                    String otherUniqueResourceIdentifier;
                    if (otherCacheManagerPeerListener == null || !uniqueResourceIdentifier.equals(otherUniqueResourceIdentifier = otherCacheManagerPeerListener.getUniqueResourceIdentifier())) continue;
                    LOG.warn("Creating a new instance of CacheManager with a CacheManagerPeerListener which has a conflict on a resource that must be unique.\nThe resource is " + uniqueResourceIdentifier + ".\n" + "Attempting automatic resolution. The source of the configuration was " + configurationHelper.getConfigurationBean().getConfigurationSource() + ".\n" + "To avoid this warning consider using the CacheManager factory methods to create a " + "singleton CacheManager " + "or specifying a separate ehcache configuration (ehcache.xml) for each CacheManager instance.");
                    cacheManagerPeerListener.attemptResolutionOfUniqueResourceConflict();
                    continue block1;
                }
            }
        }
    }

    private void addConfiguredCaches(ConfigurationHelper configurationHelper) {
        Set unitialisedCaches = configurationHelper.createCaches();
        for (Ehcache unitialisedCache : unitialisedCaches) {
            this.addCacheNoCheck(unitialisedCache, true);
            List<Ehcache> cacheDecorators = configurationHelper.createCacheDecorators(unitialisedCache);
            for (Ehcache decoratedCache : cacheDecorators) {
                this.addOrReplaceDecoratedCache(unitialisedCache, decoratedCache);
            }
        }
    }

    private void addOrReplaceDecoratedCache(Ehcache underlyingCache, Ehcache decoratedCache) {
        if (decoratedCache.getName().equals(underlyingCache.getName())) {
            this.replaceCacheWithDecoratedCache(underlyingCache, decoratedCache);
        } else {
            this.addDecoratedCache(decoratedCache);
        }
    }

    private void reinitialisationCheck() throws IllegalStateException {
        if (this.defaultCache != null || this.diskStorePath != null || this.ehcaches.size() != 0 || this.status.equals(Status.STATUS_SHUTDOWN)) {
            throw new IllegalStateException("Attempt to reinitialise the CacheManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create() throws CacheException {
        if (singleton != null) {
            return singleton;
        }
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                LOG.debug("Creating new CacheManager with default config");
                singleton = new CacheManager();
            } else {
                LOG.debug("Attempting to create an existing singleton. Existing singleton returned.");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public static CacheManager getInstance() throws CacheException {
        return CacheManager.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(String configurationFileName) throws CacheException {
        if (singleton != null) {
            return singleton;
        }
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                LOG.debug("Creating new CacheManager with config file: {}", (Object)configurationFileName);
                singleton = new CacheManager(configurationFileName);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(URL configurationFileURL) throws CacheException {
        if (singleton != null) {
            return singleton;
        }
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                LOG.debug("Creating new CacheManager with config URL: {}", (Object)configurationFileURL);
                singleton = new CacheManager(configurationFileURL);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(InputStream inputStream) throws CacheException {
        if (singleton != null) {
            return singleton;
        }
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                LOG.debug("Creating new CacheManager with InputStream");
                singleton = new CacheManager(inputStream);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(Configuration config) throws CacheException {
        if (singleton != null) {
            return singleton;
        }
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                LOG.debug("Creating new CacheManager with InputStream");
                singleton = new CacheManager(config);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public Cache getCache(String name) throws IllegalStateException, ClassCastException {
        this.checkStatus();
        return this.ehcaches.get(name) instanceof Cache ? (Cache)this.ehcaches.get(name) : null;
    }

    public Ehcache getEhcache(String name) throws IllegalStateException {
        this.checkStatus();
        return (Ehcache)this.ehcaches.get(name);
    }

    private void addShutdownHookIfRequired() {
        String shutdownHookProperty = System.getProperty(ENABLE_SHUTDOWN_HOOK_PROPERTY);
        boolean enabled = PropertyUtil.parseBoolean(shutdownHookProperty);
        if (!enabled) {
            return;
        }
        LOG.info("The CacheManager shutdown hook is enabled because {} is set to true.", (Object)ENABLE_SHUTDOWN_HOOK_PROPERTY);
        Thread localShutdownHook = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (CacheManager.this.status.equals(Status.STATUS_ALIVE)) {
                        CacheManager.this.shutdownHook = null;
                        LOG.info("VM shutting down with the CacheManager still active. Calling shutdown.");
                        CacheManager.this.shutdown();
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(localShutdownHook);
        this.shutdownHook = localShutdownHook;
    }

    private void removeShutdownHook() {
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException e) {
                LOG.debug("IllegalStateException due to attempt to remove a shutdownhook while the VM is actually shutting down.", (Throwable)e);
            }
            this.shutdownHook = null;
        }
    }

    public void addCache(String cacheName) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (cacheName == null || cacheName.length() == 0) {
            return;
        }
        if (this.ehcaches.get(cacheName) != null) {
            throw new ObjectExistsException("Cache " + cacheName + " already exists");
        }
        Ehcache clonedDefaultCache = this.cloneDefaultCache(cacheName);
        this.addCache(clonedDefaultCache);
        for (Ehcache ehcache : this.createDefaultCacheDecorators(clonedDefaultCache)) {
            this.addOrReplaceDecoratedCache(clonedDefaultCache, ehcache);
        }
    }

    public void addCache(Cache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (cache == null) {
            return;
        }
        this.addCache((Ehcache)cache);
    }

    public void addCache(Ehcache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (cache == null) {
            return;
        }
        this.addCacheNoCheck(cache, true);
    }

    public void addDecoratedCache(Ehcache decoratedCache) throws ObjectExistsException {
        this.internalAddDecoratedCache(decoratedCache, true);
    }

    public void addDecoratedCacheIfAbsent(Ehcache decoratedCache) throws ObjectExistsException {
        this.internalAddDecoratedCache(decoratedCache, false);
    }

    private void internalAddDecoratedCache(Ehcache decoratedCache, boolean strict) {
        Ehcache old = this.ehcaches.putIfAbsent(decoratedCache.getName(), decoratedCache);
        if (strict && old != null) {
            throw new ObjectExistsException("Cache " + decoratedCache.getName() + " already exists in the CacheManager");
        }
    }

    private Ehcache addCacheNoCheck(Ehcache cache, boolean strict) throws IllegalStateException, ObjectExistsException, CacheException {
        CacheConfiguration cacheConfig;
        if (cache.getStatus() != Status.STATUS_UNINITIALISED) {
            throw new CacheException("Trying to add an already initialized cache. If you are adding a decorated cache, use CacheManager.addDecoratedCache(Ehcache decoratedCache) instead.");
        }
        Ehcache ehcache = (Ehcache)this.ehcaches.get(cache.getName());
        if (ehcache != null) {
            if (strict) {
                throw new ObjectExistsException("Cache " + cache.getName() + " already exists");
            }
            return ehcache;
        }
        cache.setCacheManager(this);
        cache.setDiskStorePath(this.diskStorePath);
        cache.setTransactionManagerLookup(this.transactionManagerLookup);
        Map<String, CacheConfiguration> configMap = this.configuration.getCacheConfigurations();
        if (!configMap.containsKey(cache.getName()) && (cacheConfig = cache.getCacheConfiguration()) != null) {
            this.configuration.addCache(cacheConfig);
        }
        cache.initialise();
        if (!this.allowsDynamicCacheConfig) {
            cache.disableDynamicFeatures();
        }
        try {
            cache.bootstrap();
        }
        catch (CacheException e) {
            LOG.warn("Cache " + cache.getName() + "requested bootstrap but a CacheException occured. " + e.getMessage(), (Throwable)e);
        }
        ehcache = this.ehcaches.putIfAbsent(cache.getName(), cache);
        if (ehcache != null) {
            if (strict) {
                throw new ObjectExistsException("Cache " + cache.getName() + " already exists");
            }
            return ehcache;
        }
        if (this.status.equals(Status.STATUS_ALIVE)) {
            this.cacheManagerEventListenerRegistry.notifyCacheAdded(cache.getName());
        }
        return cache;
    }

    public boolean cacheExists(String cacheName) throws IllegalStateException {
        this.checkStatus();
        return this.ehcaches.get(cacheName) != null;
    }

    public void removalAll() {
        String[] cacheNames;
        for (String cacheName : cacheNames = this.getCacheNames()) {
            this.removeCache(cacheName);
        }
    }

    public void removeCache(String cacheName) throws IllegalStateException {
        this.checkStatus();
        if (cacheName == null || cacheName.length() == 0) {
            return;
        }
        Ehcache cache = (Ehcache)this.ehcaches.remove(cacheName);
        if (cache != null && cache.getStatus().equals(Status.STATUS_ALIVE)) {
            cache.dispose();
            this.configuration.getCacheConfigurations().remove(cacheName);
            this.cacheManagerEventListenerRegistry.notifyCacheRemoved(cache.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (this.status.equals(Status.STATUS_SHUTDOWN)) {
                LOG.debug("CacheManager already shutdown");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            for (CacheManagerPeerProvider cacheManagerPeerProvider : this.cacheManagerPeerProviders.values()) {
                if (cacheManagerPeerProvider == null) continue;
                cacheManagerPeerProvider.dispose();
            }
            if (this.cacheManagerTimer != null) {
                this.cacheManagerTimer.cancel();
                this.cacheManagerTimer.purge();
            }
            this.cacheManagerEventListenerRegistry.dispose();
            Class<CacheManager> clazz2 = CacheManager.class;
            synchronized (CacheManager.class) {
                ALL_CACHE_MANAGERS.remove(this);
                for (Ehcache cache : this.ehcaches.values()) {
                    if (cache == null) continue;
                    cache.dispose();
                }
                this.defaultCache.dispose();
                this.status = Status.STATUS_SHUTDOWN;
                if (this == singleton) {
                    singleton = null;
                }
                if (this.terracottaClusteredInstanceFactory != null) {
                    this.terracottaClusteredInstanceFactory.shutdown();
                }
                this.removeShutdownHook();
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    public String[] getCacheNames() throws IllegalStateException {
        this.checkStatus();
        String[] list = new String[this.ehcaches.size()];
        return this.ehcaches.keySet().toArray(list);
    }

    protected void checkStatus() {
        if (!this.status.equals(Status.STATUS_ALIVE)) {
            if (this.status.equals(Status.STATUS_UNINITIALISED)) {
                throw new IllegalStateException("The CacheManager has not yet been initialised. It cannot be used yet.");
            }
            if (this.status.equals(Status.STATUS_SHUTDOWN)) {
                throw new IllegalStateException("The CacheManager has been shut down. It can no longer be used.");
            }
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void clearAll() throws CacheException {
        String[] cacheNames = this.getCacheNames();
        LOG.debug("Clearing all caches");
        for (String cacheName : cacheNames) {
            Ehcache cache = this.getEhcache(cacheName);
            cache.removeAll();
        }
    }

    public void clearAllStartingWith(String prefix) throws CacheException {
        if (prefix == null || prefix.length() == 0) {
            return;
        }
        for (Map.Entry o : this.ehcaches.entrySet()) {
            Map.Entry entry = o;
            String cacheName = (String)entry.getKey();
            if (!cacheName.startsWith(prefix)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Clearing cache named '" + cacheName + "' (matches '" + prefix + "' prefix");
            }
            ((Ehcache)entry.getValue()).removeAll();
        }
    }

    public CacheManagerPeerProvider getCacheManagerPeerProvider(String scheme) {
        return this.cacheManagerPeerProviders.get(scheme);
    }

    public Map<String, CacheManagerPeerProvider> getCacheManagerPeerProviders() {
        return Collections.unmodifiableMap(this.cacheManagerPeerProviders);
    }

    public CacheManagerPeerListener getCachePeerListener(String scheme) {
        return this.cacheManagerPeerListeners.get(scheme);
    }

    public CacheManagerEventListener getCacheManagerEventListener() {
        return this.cacheManagerEventListenerRegistry;
    }

    public void setCacheManagerEventListener(CacheManagerEventListener cacheManagerEventListener) {
        this.getCacheManagerEventListenerRegistry().registerListener(cacheManagerEventListener);
    }

    public CacheManagerEventListenerRegistry getCacheManagerEventListenerRegistry() {
        return this.cacheManagerEventListenerRegistry;
    }

    public void replaceCacheWithDecoratedCache(Ehcache ehcache, Ehcache decoratedCache) throws CacheException {
        if (!ehcache.equals(decoratedCache)) {
            throw new CacheException("Cannot replace " + decoratedCache.getName() + " It does not equal the incumbent cache.");
        }
        String cacheName = ehcache.getName();
        if (!this.ehcaches.replace(cacheName, ehcache, decoratedCache)) {
            if (this.cacheExists(cacheName)) {
                throw new CacheException("Cache '" + ehcache.getName() + "' managed with this CacheManager doesn't match!");
            }
            throw new CacheException("Cache '" + cacheName + "' isn't associated with this manager (anymore?)");
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    public boolean isNamed() {
        return this.name != null;
    }

    public void setName(String name) {
        this.name = name;
        try {
            this.mbeanRegistrationProvider.reinitialize(this.terracottaClusteredInstanceFactory);
        }
        catch (MBeanRegistrationProviderException e) {
            throw new CacheException("Problem in reinitializing MBeanRegistrationProvider - " + this.mbeanRegistrationProvider.getClass().getName(), e);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getDiskStorePath() {
        return this.diskStorePath;
    }

    public FailSafeTimer getTimer() {
        return this.cacheManagerTimer;
    }

    public CacheCluster getCluster(ClusterScheme scheme) throws ClusterSchemeNotAvailableException {
        switch (scheme) {
            case TERRACOTTA: {
                if (null == this.terracottaClusteredInstanceFactory) {
                    throw new ClusterSchemeNotAvailableException(ClusterScheme.TERRACOTTA, "Terracotta cluster scheme is not available");
                }
                return this.terracottaClusteredInstanceFactory.getTopology();
            }
        }
        return NoopCacheCluster.INSTANCE;
    }

    public String getOriginalConfigurationText() {
        if (this.configuration.getConfigurationSource() == null) {
            return "Originally configured programmatically. No original configuration source text.";
        }
        Configuration originalConfiguration = this.configuration.getConfigurationSource().createConfiguration();
        return ConfigurationUtil.generateCacheManagerConfigurationText(originalConfiguration);
    }

    public String getActiveConfigurationText() {
        return ConfigurationUtil.generateCacheManagerConfigurationText(this.configuration);
    }

    public String getOriginalConfigurationText(String cacheName) throws CacheException {
        if (this.configuration.getConfigurationSource() == null) {
            return "Originally configured programmatically. No original configuration source text.";
        }
        Configuration originalConfiguration = this.configuration.getConfigurationSource().createConfiguration();
        CacheConfiguration cacheConfiguration = originalConfiguration.getCacheConfigurations().get(cacheName);
        if (cacheConfiguration == null) {
            throw new CacheException("Cache with name '" + cacheName + "' does not exist in the original configuration");
        }
        return ConfigurationUtil.generateCacheConfigurationText(cacheConfiguration);
    }

    public String getActiveConfigurationText(String cacheName) throws CacheException {
        CacheConfiguration config = this.configuration.getCacheConfigurations().get(cacheName);
        if (config == null) {
            throw new CacheException("Cache with name '" + cacheName + "' does not exist");
        }
        return ConfigurationUtil.generateCacheConfigurationText(config);
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    public int hashCode() {
        if (this.name != null) {
            return this.name.hashCode();
        }
        return super.hashCode();
    }

    public Ehcache addCacheIfAbsent(Ehcache cache) {
        this.checkStatus();
        return cache == null ? null : this.addCacheNoCheck(cache, false);
    }

    public Ehcache addCacheIfAbsent(String cacheName) {
        this.checkStatus();
        if (cacheName == null || cacheName.length() == 0) {
            return null;
        }
        Ehcache ehcache = (Ehcache)this.ehcaches.get(cacheName);
        if (ehcache == null) {
            Ehcache clonedDefaultCache = this.cloneDefaultCache(cacheName);
            this.addCacheIfAbsent(clonedDefaultCache);
            for (Ehcache createdCache : this.createDefaultCacheDecorators(clonedDefaultCache)) {
                this.addOrReplaceDecoratedCache(clonedDefaultCache, createdCache);
            }
        }
        return (Ehcache)this.ehcaches.get(cacheName);
    }

    private Ehcache cloneDefaultCache(String cacheName) {
        Ehcache cache;
        try {
            cache = (Ehcache)this.defaultCache.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException("Failure cloning default cache. Initial cause was " + e.getMessage(), e);
        }
        if (cache != null) {
            cache.setName(cacheName);
        }
        return cache;
    }

    private List<Ehcache> createDefaultCacheDecorators(Ehcache underlyingCache) {
        return ConfigurationHelper.createDefaultCacheDecorators(underlyingCache, this.configuration.getDefaultCacheConfiguration());
    }

    static {
        mBeanRegistrationProviderFactory = new MBeanRegistrationProviderFactoryImpl();
    }
}

