/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.writer.writebehind;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.writer.CacheWriter;
import net.sf.ehcache.writer.CacheWriterManager;
import net.sf.ehcache.writer.writebehind.CoalesceKeysFilter;
import net.sf.ehcache.writer.writebehind.WriteBehind;
import net.sf.ehcache.writer.writebehind.WriteBehindQueue;

public class WriteBehindManager
implements CacheWriterManager {
    private volatile WriteBehind writeBehind;

    public void init(Cache cache) throws CacheException {
        this.writeBehind = cache.isTerracottaClustered() ? cache.getCacheManager().createTerracottaWriteBehind(cache) : new WriteBehindQueue(cache.getCacheConfiguration());
        CacheWriter cacheWriter = cache.getRegisteredCacheWriter();
        if (null == cacheWriter) {
            throw new CacheException("No cache writer was registered for cache " + cache.getName());
        }
        if (cache.getCacheConfiguration().getCacheWriterConfiguration().getWriteCoalescing()) {
            this.writeBehind.setOperationsFilter(new CoalesceKeysFilter());
        }
        this.writeBehind.start(cacheWriter);
    }

    public void put(Element element) throws CacheException {
        this.writeBehind.write(element);
    }

    public void remove(CacheEntry entry) throws CacheException {
        this.writeBehind.delete(entry);
    }

    public void dispose() {
        this.writeBehind.stop();
    }

    public long getQueueSize() {
        return this.writeBehind.getQueueSize();
    }
}

