/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.Serializable;
import net.sf.ehcache.Ehcache;

public class Statistics
implements Serializable {
    public static final int STATISTICS_ACCURACY_NONE = 0;
    public static final int STATISTICS_ACCURACY_BEST_EFFORT = 1;
    public static final int STATISTICS_ACCURACY_GUARANTEED = 2;
    private static final long serialVersionUID = 3606940454221918725L;
    private transient Ehcache cache;
    private final String cacheName;
    private final int statisticsAccuracy;
    private final long cacheHits;
    private final long onDiskHits;
    private final long inMemoryHits;
    private final long misses;
    private final long size;
    private final long memoryStoreSize;
    private final long diskStoreSize;
    private float averageGetTime;
    private long evictionCount;
    private long writerQueueLength;

    public Statistics(Ehcache cache, int statisticsAccuracy, long cacheHits, long onDiskHits, long inMemoryHits, long misses, long size, float averageGetTime, long evictionCount, long memoryStoreSize, long diskStoreSize, long writerQueueLength) {
        this.writerQueueLength = writerQueueLength;
        this.cacheName = cache.getName();
        this.statisticsAccuracy = statisticsAccuracy;
        this.cacheHits = cacheHits;
        this.onDiskHits = onDiskHits;
        this.inMemoryHits = inMemoryHits;
        this.misses = misses;
        this.cache = cache;
        this.size = size;
        this.averageGetTime = averageGetTime;
        this.evictionCount = evictionCount;
        this.memoryStoreSize = memoryStoreSize;
        this.diskStoreSize = diskStoreSize;
    }

    public void clearStatistics() {
        if (this.cache == null) {
            throw new IllegalStateException("This statistics object no longer references a Cache.");
        }
        this.cache.clearStatistics();
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getInMemoryHits() {
        return this.inMemoryHits;
    }

    public long getOnDiskHits() {
        return this.onDiskHits;
    }

    public long getCacheMisses() {
        return this.misses;
    }

    public long getObjectCount() {
        return this.size;
    }

    public long getMemoryStoreObjectCount() {
        return this.memoryStoreSize;
    }

    public long getDiskStoreObjectCount() {
        return this.diskStoreSize;
    }

    public int getStatisticsAccuracy() {
        return this.statisticsAccuracy;
    }

    public String getStatisticsAccuracyDescription() {
        if (this.statisticsAccuracy == 0) {
            return "None";
        }
        if (this.statisticsAccuracy == 1) {
            return "Best Effort";
        }
        return "Guaranteed";
    }

    public String getAssociatedCacheName() {
        if (this.cache != null) {
            return this.cache.getName();
        }
        return this.cacheName;
    }

    public Ehcache getAssociatedCache() {
        if (this.cache != null) {
            return this.cache;
        }
        return null;
    }

    public final String toString() {
        StringBuilder dump = new StringBuilder();
        dump.append("[ ").append(" name = ").append(this.getAssociatedCacheName()).append(" cacheHits = ").append(this.cacheHits).append(" onDiskHits = ").append(this.onDiskHits).append(" inMemoryHits = ").append(this.inMemoryHits).append(" misses = ").append(this.misses).append(" size = ").append(this.size).append(" averageGetTime = ").append(this.averageGetTime).append(" evictionCount = ").append(this.evictionCount).append(" ]");
        return dump.toString();
    }

    public float getAverageGetTime() {
        return this.averageGetTime;
    }

    public long getEvictionCount() {
        return this.evictionCount;
    }

    public static boolean isValidStatisticsAccuracy(int statisticsAccuracy) {
        return statisticsAccuracy == 0 || statisticsAccuracy == 1 || statisticsAccuracy == 2;
    }

    public long getWriterQueueSize() {
        return this.writerQueueLength;
    }
}

