/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.concurrent;

import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.ConcurrencyUtil;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.LocksAcquisitionException;
import net.sf.ehcache.concurrent.ReadWriteLockSync;
import net.sf.ehcache.concurrent.Sync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StripedReadWriteLockSync
implements CacheLockProvider {
    public static final int DEFAULT_NUMBER_OF_MUTEXES = 2048;
    private final ReadWriteLockSync[] mutexes;
    private final int numberOfStripes;

    public StripedReadWriteLockSync() {
        this(2048);
    }

    public StripedReadWriteLockSync(int numberOfStripes) {
        if (numberOfStripes % 2 != 0) {
            throw new CacheException("Cannot create a CacheLockProvider with an odd number of stripes");
        }
        if (numberOfStripes == 0) {
            throw new CacheException("A zero size CacheLockProvider does not have useful semantics.");
        }
        this.numberOfStripes = numberOfStripes;
        this.mutexes = new ReadWriteLockSync[numberOfStripes];
        for (int i = 0; i < numberOfStripes; ++i) {
            this.mutexes[i] = new ReadWriteLockSync();
        }
    }

    @Override
    public ReadWriteLockSync getSyncForKey(Object key) {
        int lockNumber = ConcurrencyUtil.selectLock(key, this.numberOfStripes);
        return this.mutexes[lockNumber];
    }

    @Override
    public Sync[] getAndWriteLockAllSyncForKeys(Object ... keys) {
        SortedMap<ReadWriteLockSync, AtomicInteger> locks = this.getLockMap(keys);
        Sync[] syncs = new Sync[locks.size()];
        int i = 0;
        for (Map.Entry<ReadWriteLockSync, AtomicInteger> entry : locks.entrySet()) {
            while (entry.getValue().getAndDecrement() > 0) {
                entry.getKey().lock(LockType.WRITE);
            }
            syncs[i++] = entry.getKey();
        }
        return syncs;
    }

    @Override
    public Sync[] getAndWriteLockAllSyncForKeys(long timeout, Object ... keys) throws LocksAcquisitionException {
        SortedMap<ReadWriteLockSync, AtomicInteger> locks = this.getLockMap(keys);
        ArrayList<ReadWriteLockSync> heldLocks = new ArrayList<ReadWriteLockSync>();
        Sync[] syncs = new Sync[locks.size()];
        int i = 0;
        for (Map.Entry<ReadWriteLockSync, AtomicInteger> entry : locks.entrySet()) {
            while (entry.getValue().getAndDecrement() > 0) {
                boolean lockHeld;
                try {
                    ReadWriteLockSync writeLockSync = entry.getKey();
                    lockHeld = writeLockSync.tryLock(LockType.WRITE, timeout);
                    if (lockHeld) {
                        heldLocks.add(writeLockSync);
                    }
                }
                catch (InterruptedException e) {
                    lockHeld = false;
                }
                if (lockHeld) continue;
                for (int j = heldLocks.size() - 1; j >= 0; --j) {
                    ReadWriteLockSync readWriteLockSync = (ReadWriteLockSync)heldLocks.get(j);
                    readWriteLockSync.unlock(LockType.WRITE);
                }
                throw new LocksAcquisitionException("could not acquire all locks in " + timeout + " ms");
            }
            syncs[i++] = entry.getKey();
        }
        return syncs;
    }

    @Override
    public void unlockWriteLockForAllKeys(Object ... keys) {
        SortedMap<ReadWriteLockSync, AtomicInteger> locks = this.getLockMap(keys);
        for (Map.Entry<ReadWriteLockSync, AtomicInteger> entry : locks.entrySet()) {
            while (entry.getValue().getAndDecrement() > 0) {
                entry.getKey().unlock(LockType.WRITE);
            }
        }
    }

    private SortedMap<ReadWriteLockSync, AtomicInteger> getLockMap(Object ... keys) {
        TreeMap<ReadWriteLockSync, AtomicInteger> locks = new TreeMap<ReadWriteLockSync, AtomicInteger>();
        for (Object key : keys) {
            ReadWriteLockSync syncForKey = this.getSyncForKey(key);
            if (locks.containsKey(syncForKey)) {
                ((AtomicInteger)locks.get(syncForKey)).incrementAndGet();
                continue;
            }
            locks.put(syncForKey, new AtomicInteger(1));
        }
        return locks;
    }
}

