/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.xa;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.transaction.TransactionContext;
import net.sf.ehcache.transaction.xa.EhcacheXAStore;
import net.sf.ehcache.transaction.xa.VersionAwareCommand;
import net.sf.ehcache.transaction.xa.XATransactionContext;

public class EhcacheXAStoreImpl
implements EhcacheXAStore {
    private final ConcurrentMap<Transaction, Xid> localXidTable = new ConcurrentHashMap<Transaction, Xid>();
    private final ConcurrentMap<Xid, XATransactionContext> transactionContextXids = new ConcurrentHashMap<Xid, XATransactionContext>();
    private final ConcurrentMap<Xid, Xid> prepareXids = new ConcurrentHashMap<Xid, Xid>();
    private final VersionTable versionTable = new VersionTable();
    private Store underlyingStore;
    private Store oldVersionStore;

    public EhcacheXAStoreImpl(Store underlyingStore, Store oldVersionStore) {
        this.underlyingStore = underlyingStore;
        this.oldVersionStore = oldVersionStore;
    }

    public Store getOldVersionStore() {
        return this.oldVersionStore;
    }

    public boolean isPrepared(Xid xid) {
        return this.prepareXids.containsKey(xid);
    }

    public void removeData(Xid xid) {
        this.prepareXids.remove(xid);
        this.transactionContextXids.remove(xid);
    }

    public void checkin(Object key, Xid xid, boolean readOnly) {
        this.versionTable.checkin(key, xid, readOnly);
    }

    public long checkout(Object key, Xid xid) {
        return this.versionTable.checkout(key, xid);
    }

    public Xid storeXid2Transaction(Xid xid, Transaction transaction) {
        return this.localXidTable.putIfAbsent(transaction, xid);
    }

    public TransactionContext createTransactionContext(Transaction txn) {
        Xid xid = (Xid)this.localXidTable.get(txn);
        XATransactionContext context = new XATransactionContext(xid, this);
        context.initializeTransients(txn);
        XATransactionContext previous = this.transactionContextXids.putIfAbsent(xid, context);
        if (previous != null) {
            context = previous;
        }
        return context;
    }

    public Xid[] getPreparedXids() {
        Set xidSet = this.prepareXids.keySet();
        return xidSet.toArray(new Xid[xidSet.size()]);
    }

    public TransactionContext getTransactionContext(Xid xid) {
        return (TransactionContext)this.transactionContextXids.get(xid);
    }

    public TransactionContext getTransactionContext(Transaction txn) {
        Xid xid = (Xid)this.localXidTable.get(txn);
        return (TransactionContext)this.transactionContextXids.get(xid);
    }

    public boolean isValid(VersionAwareCommand command) {
        return this.versionTable.valid(command.getKey(), command.getVersion());
    }

    public void prepared(Xid xid) {
        this.prepareXids.put(xid, xid);
    }

    public Store getUnderlyingStore() {
        return this.underlyingStore;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Version {
        private final AtomicLong version = new AtomicLong(0L);
        private final ConcurrentMap<Xid, Long> txnVersions = new ConcurrentHashMap<Xid, Long>();

        public long getCurrentVersion() {
            return this.version.get();
        }

        public boolean hasTransaction(Xid xid) {
            return this.txnVersions.containsKey(xid);
        }

        public long getVersion(Xid xid) {
            try {
                return (Long)this.txnVersions.get(xid);
            }
            catch (NullPointerException e) {
                throw new AssertionError((Object)("Cannot get version for not existing transaction: " + xid));
            }
        }

        public long checkout(Xid xid) {
            long v = this.version.get();
            this.txnVersions.put(xid, v);
            return v;
        }

        public boolean checkinRead(Xid xid) {
            this.txnVersions.remove(xid);
            return this.txnVersions.isEmpty();
        }

        public boolean checkinWrite(Xid xid) {
            long v = (Long)this.txnVersions.remove(xid);
            this.version.incrementAndGet();
            return this.txnVersions.isEmpty();
        }

        ConcurrentMap<Xid, Long> getTxnVersions() {
            return this.txnVersions;
        }
    }

    public static class VersionTable {
        protected final ConcurrentMap<Object, Version> versionStore = new ConcurrentHashMap<Object, Version>();

        public synchronized boolean valid(Object key, long currentVersionNumber) {
            Version version = (Version)this.versionStore.get(key);
            if (version != null) {
                long currentVersion = version.getCurrentVersion();
                return currentVersion == currentVersionNumber;
            }
            return true;
        }

        public synchronized long checkout(Object key, Xid xid) {
            long versionNumber = -1L;
            Version version = (Version)this.versionStore.get(key);
            if (version == null) {
                version = new Version();
                this.versionStore.put(key, version);
            }
            versionNumber = version.checkout(xid);
            return versionNumber;
        }

        public synchronized void checkin(Object key, Xid xid, boolean readOnly) {
            if (key != null) {
                Version version = (Version)this.versionStore.get(key);
                boolean removeEntry = readOnly ? version.checkinRead(xid) : version.checkinWrite(xid);
                if (removeEntry) {
                    this.versionStore.remove(key);
                }
            }
        }
    }
}

