/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config.generator;

import java.util.List;
import java.util.Map;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.config.TerracottaConfigConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationGenerator {
    private static final String EOL = System.getProperty("line.separator");
    private static final String INDENT = "    ";
    private StringBuilder builder;
    private int numIndents;
    private String spacer = "";

    private void visitCacheManagerConfig(Configuration configuration) {
        TerracottaConfigConfiguration terracottaConfig;
        List<FactoryConfiguration> peerListenersConfig;
        List<FactoryConfiguration> peerProviderConfig;
        FactoryConfiguration cacheManagerEventListenerConfig;
        this.builder.append(this.spacer).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.builder.append(EOL);
        this.builder.append(this.spacer).append("<ehcache ");
        if (this.notBlank(configuration.getName())) {
            this.builder.append(this.spacer).append("name =\"").append(configuration.getName()).append("\" ");
        }
        this.builder.append(this.spacer).append("updateCheck=\"").append(configuration.getUpdateCheck()).append("\" ");
        this.builder.append(this.spacer).append("monitoring=\"").append(configuration.getMonitoring().name().toLowerCase()).append("\"");
        this.builder.append(this.spacer).append(">");
        this.builder.append(EOL);
        this.indent(1);
        DiskStoreConfiguration diskConfig = configuration.getDiskStoreConfiguration();
        if (diskConfig != null) {
            this.builder.append(this.spacer).append("<diskStore path=\"").append(diskConfig.getOriginalPath()).append("\">");
            this.builder.append(EOL);
        }
        if ((cacheManagerEventListenerConfig = configuration.getCacheManagerEventListenerFactoryConfiguration()) != null) {
            this.builder.append(this.spacer).append("<cacheManagerEventListenerFactory class=\"" + cacheManagerEventListenerConfig.getFullyQualifiedClassPath()).append("\" properties=\"" + cacheManagerEventListenerConfig.getProperties()).append("\"/>");
            this.builder.append(EOL);
        }
        if ((peerProviderConfig = configuration.getCacheManagerPeerProviderFactoryConfiguration()) != null && peerProviderConfig.size() > 0) {
            for (FactoryConfiguration config : peerProviderConfig) {
                this.builder.append(this.spacer).append("<cacheManagerPeerProviderFactory class=\"").append(config.getFullyQualifiedClassPath()).append("\" properties=\"").append(config.getProperties()).append("\"");
                this.builder.append(EOL);
            }
        }
        if ((peerListenersConfig = configuration.getCacheManagerPeerListenerFactoryConfigurations()) != null && peerListenersConfig.size() > 0) {
            for (FactoryConfiguration config : peerListenersConfig) {
                this.builder.append(this.spacer).append("<cacheManagerPeerListenerFactory class=\"").append(config.getFullyQualifiedClassPath()).append("\" properties=\"").append(config.getProperties()).append("\"");
                this.builder.append(EOL);
            }
        }
        if ((terracottaConfig = configuration.getTerracottaConfiguration()) != null) {
            if (terracottaConfig.isUrlConfig()) {
                this.builder.append(this.spacer).append("<terracottaConfig url=\"").append(terracottaConfig.getUrl()).append("\">");
                this.builder.append(EOL);
            } else {
                this.builder.append(this.spacer).append("<terracottaConfig>");
                this.builder.append(EOL);
                this.builder.append(terracottaConfig.getOriginalEmbeddedConfig());
                this.builder.append(this.spacer).append("<terracottaConfig>");
                this.builder.append(EOL);
            }
        }
    }

    private boolean notBlank(String str) {
        return str != null && !"".equals(str.trim());
    }

    private void visitDefaultCache(CacheConfiguration defaultCacheConfiguration) {
        this.visitCache("defaultCache", defaultCacheConfiguration);
    }

    private void visitCache(String tagName, CacheConfiguration cacheConfiguration) {
        TerracottaConfiguration terracottaConfiguration;
        List extensionConfigs;
        List loaderConfigs;
        CacheConfiguration.CacheExceptionHandlerFactoryConfiguration exceptionConfig;
        CacheConfiguration.BootstrapCacheLoaderFactoryConfiguration bootstrapCacheLoaderFactoryConfiguration;
        this.builder.append(this.spacer).append("<").append(tagName);
        if (this.notBlank(cacheConfiguration.getName())) {
            this.builder.append(" name=\"").append(cacheConfiguration.getName()).append("\"").append(EOL);
        } else {
            this.builder.append(EOL);
        }
        this.indent(1);
        this.builder.append(this.spacer).append("maxElementsInMemory=\"").append(cacheConfiguration.getMaxElementsInMemory()).append("\"").append(EOL);
        this.builder.append(this.spacer).append("maxElementsOnDisk=\"").append(cacheConfiguration.getMaxElementsOnDisk()).append("\"").append(EOL);
        this.builder.append(this.spacer).append("eternal=\"").append(cacheConfiguration.isEternal()).append("\"").append(EOL);
        this.builder.append(this.spacer).append("overflowToDisk=\"").append(cacheConfiguration.isOverflowToDisk()).append("\"").append(EOL);
        this.builder.append(this.spacer).append("timeToIdleSeconds=\"").append(cacheConfiguration.getTimeToIdleSeconds()).append("\"").append(EOL);
        this.builder.append(this.spacer).append("timeToLiveSeconds=\"").append(cacheConfiguration.getTimeToLiveSeconds()).append("\"").append(EOL);
        this.builder.append(this.spacer).append("diskPersistent=\"").append(cacheConfiguration.isDiskPersistent()).append("\"").append(EOL);
        this.builder.append(this.spacer).append("diskExpiryThreadIntervalSeconds=\"").append(cacheConfiguration.getDiskExpiryThreadIntervalSeconds()).append("\"" + EOL);
        this.builder.append(this.spacer).append("diskSpoolBufferSizeMB=\"").append(cacheConfiguration.getDiskSpoolBufferSizeMB()).append("\"").append(EOL);
        MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = cacheConfiguration.getMemoryStoreEvictionPolicy();
        if (memoryStoreEvictionPolicy != null) {
            this.builder.append(this.spacer).append("memoryStoreEvictionPolicy=\"").append(memoryStoreEvictionPolicy.toString()).append("\"").append(EOL);
        }
        this.builder.append(this.spacer).append("clearOnFlush=\"").append(cacheConfiguration.isClearOnFlush()).append("\">").append(EOL);
        this.indent(1);
        List listenerConfigs = cacheConfiguration.getCacheEventListenerConfigurations();
        if (listenerConfigs != null && listenerConfigs.size() > 0) {
            for (CacheConfiguration.CacheEventListenerFactoryConfiguration config : listenerConfigs) {
                this.builder.append(this.spacer).append("<cacheEventListenerFactory class=\"").append(config.getFullyQualifiedClassPath()).append("\" properties=\"" + config.getProperties()).append("\"");
                this.builder.append(EOL);
            }
        }
        if ((bootstrapCacheLoaderFactoryConfiguration = cacheConfiguration.getBootstrapCacheLoaderFactoryConfiguration()) != null) {
            this.builder.append(this.spacer).append("<bootstrapCacheLoaderFactory class=\"" + bootstrapCacheLoaderFactoryConfiguration.getFullyQualifiedClassPath()).append("\" properties=\"" + bootstrapCacheLoaderFactoryConfiguration.getProperties()).append("\"");
            this.builder.append(EOL);
        }
        if ((exceptionConfig = cacheConfiguration.getCacheExceptionHandlerFactoryConfiguration()) != null) {
            this.builder.append(this.spacer).append("<cacheExceptionHandlerFactory class=\"").append(exceptionConfig.getFullyQualifiedClassPath()).append("\" properties=\"").append(exceptionConfig.getProperties()).append("\"");
            this.builder.append(EOL);
        }
        if ((loaderConfigs = cacheConfiguration.getCacheLoaderConfigurations()) != null && loaderConfigs.size() > 0) {
            for (CacheConfiguration.CacheLoaderFactoryConfiguration config : loaderConfigs) {
                this.builder.append(this.spacer).append("<cacheLoaderFactory class=\"").append(exceptionConfig.getFullyQualifiedClassPath()).append("\" properties=\"" + exceptionConfig.getProperties()).append("\"");
                this.builder.append(EOL);
            }
        }
        if ((extensionConfigs = cacheConfiguration.getCacheExtensionConfigurations()) != null && extensionConfigs.size() > 0) {
            for (CacheConfiguration.CacheExtensionFactoryConfiguration config : extensionConfigs) {
                this.builder.append(this.spacer).append("<cacheExtensionFactory class=\"").append(exceptionConfig.getFullyQualifiedClassPath()).append("\" properties=\"").append(exceptionConfig.getProperties()).append("\"");
                this.builder.append(EOL);
            }
        }
        if ((terracottaConfiguration = cacheConfiguration.getTerracottaConfiguration()) != null) {
            this.builder.append(this.spacer).append("<terracotta");
            this.indent(1);
            this.builder.append(" clustered=\"").append(terracottaConfiguration.isClustered()).append("\"");
            if (!TerracottaConfiguration.DEFAULT_VALUE_MODE.equals((Object)terracottaConfiguration.getValueMode())) {
                this.builder.append(EOL).append(this.spacer).append(" valueMode=\"").append(terracottaConfiguration.getValueMode().name().toLowerCase()).append("\"");
            }
            if (!terracottaConfiguration.getCoherentReads()) {
                this.builder.append(EOL).append(this.spacer).append(" coherentReads=\"").append(terracottaConfiguration.getCoherentReads()).append("\"");
            }
            if (terracottaConfiguration.getLocalKeyCache()) {
                this.builder.append(EOL).append(this.spacer).append(" localKeyCache=\"").append(terracottaConfiguration.getLocalKeyCache()).append("\"");
            }
            if (300000 != terracottaConfiguration.getLocalKeyCacheSize()) {
                this.builder.append(EOL).append(this.spacer).append(" localKeyCacheSize=\"").append(terracottaConfiguration.getLocalKeyCacheSize()).append("\"");
            }
            if (!terracottaConfiguration.getOrphanEviction()) {
                this.builder.append(EOL).append(this.spacer).append(" orphanEviction=\"").append(terracottaConfiguration.getOrphanEviction()).append("\"");
            }
            if (4 != terracottaConfiguration.getOrphanEvictionPeriod()) {
                this.builder.append(EOL).append(this.spacer).append(" orphanEvictionPeriod=\"").append(terracottaConfiguration.getOrphanEvictionPeriod()).append("\"");
            }
            if (!terracottaConfiguration.isCoherent()) {
                this.builder.append(EOL).append(this.spacer).append(" coherent=\"").append(terracottaConfiguration.isCoherent()).append("\"");
            }
            if (terracottaConfiguration.isSynchronousWrite()) {
                this.builder.append(EOL).append(this.spacer).append(" synchronousWrite=\"").append(terracottaConfiguration.isSynchronousWrite()).append("\"");
            }
            this.builder.append(">").append(EOL);
            this.indent(-1);
            this.builder.append(this.spacer).append("</terracotta>");
            this.builder.append(EOL);
        }
        this.indent(-1);
        this.indent(-1);
        this.builder.append(this.spacer).append("</").append(tagName).append(">");
        this.builder.append(EOL);
    }

    private void indent(int delta) {
        this.numIndents += delta;
        this.spacer = "";
        for (int i = 0; i < this.numIndents; ++i) {
            this.spacer = this.spacer + INDENT;
        }
    }

    private void visitCaches(Map<String, CacheConfiguration> cacheConfigs) {
        for (CacheConfiguration config : cacheConfigs.values()) {
            this.visitCache("cache", config);
        }
    }

    public String generate(Configuration configuration, CacheConfiguration defaultCacheConfiguration, Map<String, CacheConfiguration> cacheConfigs) {
        this.builder = new StringBuilder();
        this.visitCacheManagerConfig(configuration);
        this.visitDefaultCache(defaultCacheConfiguration);
        this.visitCaches(cacheConfigs);
        this.indent(-1);
        this.builder.append(this.spacer).append("</ehcache>");
        return this.builder.toString();
    }

    public String generate(CacheConfiguration cacheConfiguration) {
        this.builder = new StringBuilder();
        this.visitCache("cache", cacheConfiguration);
        return this.builder.toString();
    }
}

