/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ProductInfo {
    private static final String VERSION_RESOURCE = "/ehcache-version.properties";
    private static final String UNKNOWN = "UNKNOWN";
    private Properties props = new Properties();

    public ProductInfo() {
        this(VERSION_RESOURCE);
    }

    public ProductInfo(String resource) {
        this.parseProductInfo(resource);
    }

    private void parseProductInfo(String resource) {
        InputStream in = ProductInfo.class.getResourceAsStream(resource);
        if (in == null) {
            throw new RuntimeException("Can't find resource: " + resource);
        }
        try {
            this.props.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.props.getProperty("product-name", UNKNOWN);
    }

    public String getVersion() {
        return this.props.getProperty("version", UNKNOWN);
    }

    public String getBuiltBy() {
        return this.props.getProperty("built-by", UNKNOWN);
    }

    public String getBuildJdk() {
        return this.props.getProperty("build-jdk", UNKNOWN);
    }

    public String getBuildTime() {
        return this.props.getProperty("build-time", UNKNOWN);
    }

    public String getBuildRevision() {
        return this.props.getProperty("build-revision", UNKNOWN);
    }

    public String getPatchLevel() {
        return this.props.getProperty("patch-level", UNKNOWN);
    }

    public String toString() {
        String versionString = String.format("%s version %s was built on %s, at revision %s, with jdk %s by %s", this.getName(), this.getVersion(), this.getBuildTime(), this.getBuildRevision(), this.getBuildJdk(), this.getBuiltBy());
        if (!UNKNOWN.equals(this.getPatchLevel())) {
            versionString = versionString + ". Patch level " + this.getPatchLevel();
        }
        return versionString;
    }
}

