/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheConfiguration
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger((String)CacheConfiguration.class.getName());
    protected String name;
    protected int maxElementsInMemory;
    protected int maxElementsOnDisk;
    protected MemoryStoreEvictionPolicy memoryStoreEvictionPolicy;
    protected boolean clearOnFlush = true;
    protected boolean eternal;
    protected long timeToIdleSeconds;
    protected long timeToLiveSeconds;
    protected boolean overflowToDisk;
    protected boolean diskPersistent;
    protected int diskSpoolBufferSizeMB;
    protected long diskExpiryThreadIntervalSeconds;
    protected final List<CacheEventListenerFactoryConfiguration> cacheEventListenerConfigurations = new ArrayList<CacheEventListenerFactoryConfiguration>();
    protected final List<CacheExtensionFactoryConfiguration> cacheExtensionConfigurations = new ArrayList<CacheExtensionFactoryConfiguration>();
    protected BootstrapCacheLoaderFactoryConfiguration bootstrapCacheLoaderFactoryConfiguration;
    protected CacheExceptionHandlerFactoryConfiguration cacheExceptionHandlerFactoryConfiguration;
    protected TerracottaConfiguration terracottaConfiguration;
    protected List cacheLoaderConfigurations = new ArrayList();

    public CacheConfiguration clone() throws CloneNotSupportedException {
        return (CacheConfiguration)super.clone();
    }

    public final void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Cache name cannot be null.");
        }
        this.name = name;
    }

    public final void setMaxElementsInMemory(int maxElementsInMemory) {
        this.maxElementsInMemory = maxElementsInMemory;
    }

    public final void setMemoryStoreEvictionPolicy(String memoryStoreEvictionPolicy) {
        this.memoryStoreEvictionPolicy = MemoryStoreEvictionPolicy.fromString(memoryStoreEvictionPolicy);
    }

    public final void setMemoryStoreEvictionPolicyFromObject(MemoryStoreEvictionPolicy memoryStoreEvictionPolicy) {
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
    }

    public final void setClearOnFlush(boolean clearOnFlush) {
        this.clearOnFlush = clearOnFlush;
    }

    public final void setEternal(boolean eternal) {
        this.eternal = eternal;
    }

    public final void setTimeToIdleSeconds(long timeToIdleSeconds) {
        this.timeToIdleSeconds = timeToIdleSeconds;
    }

    public final void setTimeToLiveSeconds(long timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
    }

    public final void setOverflowToDisk(boolean overflowToDisk) {
        this.overflowToDisk = overflowToDisk;
        this.validateConfiguration();
    }

    public final void setDiskPersistent(boolean diskPersistent) {
        this.diskPersistent = diskPersistent;
        this.validateConfiguration();
    }

    public int getDiskSpoolBufferSizeMB() {
        return this.diskSpoolBufferSizeMB;
    }

    public void setDiskSpoolBufferSizeMB(int diskSpoolBufferSizeMB) {
        this.diskSpoolBufferSizeMB = diskSpoolBufferSizeMB;
    }

    public void setMaxElementsOnDisk(int maxElementsOnDisk) {
        this.maxElementsOnDisk = maxElementsOnDisk;
    }

    public final void setDiskExpiryThreadIntervalSeconds(long diskExpiryThreadIntervalSeconds) {
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
    }

    public final void addCacheEventListenerFactory(CacheEventListenerFactoryConfiguration factory) {
        this.cacheEventListenerConfigurations.add(factory);
        this.validateConfiguration();
    }

    public final void addCacheExtensionFactory(CacheExtensionFactoryConfiguration factory) {
        this.cacheExtensionConfigurations.add(factory);
    }

    public final void addBootstrapCacheLoaderFactory(BootstrapCacheLoaderFactoryConfiguration bootstrapCacheLoaderFactoryConfiguration) {
        this.bootstrapCacheLoaderFactoryConfiguration = bootstrapCacheLoaderFactoryConfiguration;
    }

    public final void addCacheExceptionHandlerFactory(CacheExceptionHandlerFactoryConfiguration cacheExceptionHandlerFactoryConfiguration) {
        this.cacheExceptionHandlerFactoryConfiguration = cacheExceptionHandlerFactoryConfiguration;
    }

    public final void addCacheLoaderFactory(CacheLoaderFactoryConfiguration factory) {
        this.cacheLoaderConfigurations.add(factory);
    }

    public final void addTerracotta(TerracottaConfiguration terracottaConfiguration) {
        this.terracottaConfiguration = terracottaConfiguration;
        this.validateConfiguration();
    }

    private void validateConfiguration() {
        if (this.terracottaConfiguration != null && this.terracottaConfiguration.isClustered()) {
            if (this.overflowToDisk) {
                throw new InvalidConfigurationException("overflowToDisk isn't supported for a clustered Terracotta cache");
            }
            if (this.diskPersistent) {
                throw new InvalidConfigurationException("diskPersistent isn't supported for a clustered Terracotta cache");
            }
            if (this.cacheEventListenerConfigurations != null) {
                for (CacheEventListenerFactoryConfiguration listenerConfig : this.cacheEventListenerConfigurations) {
                    if (null == listenerConfig.getFullyQualifiedClassPath()) continue;
                    if (listenerConfig.getFullyQualifiedClassPath().startsWith("net.sf.ehcache.distribution.")) {
                        throw new InvalidConfigurationException("cache replication isn't supported for a clustered Terracotta cache");
                    }
                    if (!listenerConfig.getFullyQualifiedClassPath().startsWith("net.sf.ehcache.") || !LOG.isWarnEnabled()) continue;
                    LOG.warn("A non-standard CacheEventListenerFactory is used with a clustered Terracotta cache, if the purpose of this listener is replication it is not supported in a clustered context");
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public int getMaxElementsOnDisk() {
        return this.maxElementsOnDisk;
    }

    public MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public boolean isClearOnFlush() {
        return this.clearOnFlush;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    public long getDiskExpiryThreadIntervalSeconds() {
        return this.diskExpiryThreadIntervalSeconds;
    }

    public List getCacheEventListenerConfigurations() {
        return this.cacheEventListenerConfigurations;
    }

    public List getCacheExtensionConfigurations() {
        return this.cacheExtensionConfigurations;
    }

    public List getCacheLoaderConfigurations() {
        return this.cacheLoaderConfigurations;
    }

    public BootstrapCacheLoaderFactoryConfiguration getBootstrapCacheLoaderFactoryConfiguration() {
        return this.bootstrapCacheLoaderFactoryConfiguration;
    }

    public CacheExceptionHandlerFactoryConfiguration getCacheExceptionHandlerFactoryConfiguration() {
        return this.cacheExceptionHandlerFactoryConfiguration;
    }

    public TerracottaConfiguration getTerracottaConfiguration() {
        return this.terracottaConfiguration;
    }

    public boolean isTerracottaClustered() {
        return this.terracottaConfiguration != null && this.terracottaConfiguration.isClustered();
    }

    public static final class CacheLoaderFactoryConfiguration
    extends FactoryConfiguration {
    }

    public static final class CacheExceptionHandlerFactoryConfiguration
    extends FactoryConfiguration {
    }

    public static final class BootstrapCacheLoaderFactoryConfiguration
    extends FactoryConfiguration {
    }

    public static final class CacheExtensionFactoryConfiguration
    extends FactoryConfiguration {
    }

    public static final class CacheEventListenerFactoryConfiguration
    extends FactoryConfiguration {
    }
}

