/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.sampled;

import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.management.sampled.SampledCacheManagerMBean;
import net.sf.ehcache.statistics.sampled.SampledCacheStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampledCacheManager
implements SampledCacheManagerMBean {
    private final CacheManager cacheManager;
    private String mbeanRegisteredName;
    private volatile boolean mbeanRegisteredNameSet;

    public SampledCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    void setMBeanRegisteredName(String name) {
        if (this.mbeanRegisteredNameSet) {
            throw new IllegalStateException("Name used for registering this mbean is already set");
        }
        this.mbeanRegisteredNameSet = true;
        this.mbeanRegisteredName = name;
    }

    @Override
    public void clearAll() {
        this.cacheManager.clearAll();
    }

    @Override
    public String[] getCacheNames() throws IllegalStateException {
        return this.cacheManager.getCacheNames();
    }

    @Override
    public String getStatus() {
        return this.cacheManager.getStatus().toString();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Map<String, long[]> getCacheMetrics() {
        String[] caches;
        HashMap<String, long[]> result = new HashMap<String, long[]>();
        for (String cacheName : caches = this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result.put(cacheName, new long[]{stats.getCacheHitMostRecentSample(), stats.getCacheMissMostRecentSample(), stats.getCacheElementPutMostRecentSample()});
        }
        return result;
    }

    @Override
    public long getCacheHitRate() {
        String[] caches;
        long result = 0L;
        for (String cacheName : caches = this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheHitMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheMissRate() {
        String[] caches;
        long result = 0L;
        for (String cacheName : caches = this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheMissMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCachePutRate() {
        String[] caches;
        long result = 0L;
        for (String cacheName : caches = this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementPutMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheUpdateRate() {
        String[] caches;
        long result = 0L;
        for (String cacheName : caches = this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementUpdatedMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheEvictionRate() {
        String[] caches;
        long result = 0L;
        for (String cacheName : caches = this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementEvictedMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheExpirationRate() {
        String[] caches;
        long result = 0L;
        for (String cacheName : caches = this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementExpiredMostRecentSample();
        }
        return result;
    }

    @Override
    public String getName() {
        return this.cacheManager.getName();
    }

    @Override
    public String getMBeanRegisteredName() {
        return this.mbeanRegisteredName;
    }
}

