/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.util.ArrayList;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.TerracottaConfigConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.store.StoreFactory;
import net.sf.ehcache.util.ClassLoaderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TerracottaStoreHelper {
    private static final String DIRECT_STORE_FACTORY = "org.terracotta.modules.ehcache.store.TerracottaStoreFactory";
    private static final String STANDALONE_STORE_FACTORY = "net.sf.ehcache.terracotta.StandaloneTerracottaStoreFactory";

    TerracottaStoreHelper() {
    }

    static StoreFactory newStoreFactory(Map<String, CacheConfiguration> cacheConfigs, TerracottaConfigConfiguration terracottaConfig) {
        Class factoryClass;
        block7: {
            try {
                factoryClass = ClassLoaderUtil.loadClass(STANDALONE_STORE_FACTORY);
                ArrayList<String> identityCaches = new ArrayList<String>();
                for (CacheConfiguration config : cacheConfigs.values()) {
                    TerracottaConfiguration tcConfig = config.getTerracottaConfiguration();
                    if (tcConfig == null || tcConfig.getValueMode() != TerracottaConfiguration.ValueMode.IDENTITY) continue;
                    identityCaches.add(config.getName());
                }
                if (!identityCaches.isEmpty()) {
                    throw new CacheException("One or more caches are configured for identity value mode which is not permitted with standalone deployment " + ((Object)identityCaches).toString());
                }
                if (terracottaConfig == null) {
                    throw new CacheException("Terracotta caches are defined but no <terracottaConfig> element was used to specify the Terracotta configuration.");
                }
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    factoryClass = ClassLoaderUtil.loadClass(DIRECT_STORE_FACTORY);
                }
                catch (ClassNotFoundException e) {
                    throw new CacheException("Terracotta cache classes are not available, you are missing jar(s) most likely", e);
                }
                if (terracottaConfig == null) break block7;
                throw new CacheException("The ehcache configuration specified Terracotta configuration information, but when using the full install of Terracotta, you must specify the Terracotta configuration only with an external tc-config.xml file, not embedded or referenced from the ehcache configuration file.");
            }
        }
        return (StoreFactory)ClassLoaderUtil.createNewInstance(factoryClass.getName(), new Class[]{TerracottaConfigConfiguration.class}, new Object[]{terracottaConfig});
    }
}

