/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.terracotta.license.LicenseConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapabilitiesFactory {
    private static final Map<String, String[]> map = new HashMap<String, String[]>();

    public static List<String> getCapabilitiesFor(String product, String edition) {
        String[] capabilities = map.get(product + "|" + edition);
        return capabilities == null ? Collections.EMPTY_LIST : Arrays.asList(capabilities);
    }

    public static List<String> getAvailableEditionsForProduct(String product) {
        ArrayList<String> retVal = new ArrayList<String>();
        for (String edition : LicenseConstants.EDITIONS) {
            if (CapabilitiesFactory.getCapabilitiesFor(product, edition).size() == 0) continue;
            retVal.add(edition);
        }
        return retVal;
    }

    static {
        map.put("Enterprise Suite|DX", LicenseConstants.CAPABILITIES_SUITE_DX);
        map.put("Enterprise Suite|EX", LicenseConstants.CAPABILITIES_SUITE_EX);
        map.put("Enterprise Suite|FX", LicenseConstants.CAPABILITIES_SUITE_FX);
        map.put("Ehcache|DX", LicenseConstants.CAPABILITIES_EHCACHE_DX);
        map.put("Ehcache|EX", LicenseConstants.CAPABILITIES_EHCACHE_EX);
        map.put("Ehcache|FX", LicenseConstants.CAPABILITIES_EHCACHE_FX);
        map.put("Quartz|DX", LicenseConstants.CAPABILITIES_QUARTZ_DX);
        map.put("Quartz|EX", LicenseConstants.CAPABILITIES_QUARTZ_EX);
        map.put("Quartz|FX", LicenseConstants.CAPABILITIES_QUARTZ_FX);
        map.put("Sessions|DX", LicenseConstants.CAPABILITIES_SESSIONS_DX);
        map.put("Sessions|EX", LicenseConstants.CAPABILITIES_SESSIONS_EX);
        map.put("Sessions|FX", LicenseConstants.CAPABILITIES_SESSIONS_FX);
        map.put("BigMemory Go|DX", LicenseConstants.CAPABILITIES_BIGMEMORYGO_DX);
        map.put("BigMemory Max|EX", LicenseConstants.CAPABILITIES_BIGMEMORYMAX_EX);
        map.put("BigMemory Max|FX", LicenseConstants.CAPABILITIES_BIGMEMORYMAX_FX);
    }
}

