/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.util.WeakIdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.FeaturesManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.config.PersistenceConfiguration;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.pool.PoolableStore;
import net.sf.ehcache.store.ElementIdAssigningStore;
import net.sf.ehcache.store.MemoryOnlyStore;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.heap.RestartableHeapOnlyStore;
import net.sf.ehcache.store.offheap.OffHeapStoreFactory;
import net.sf.ehcache.store.offheap.configuration.HeuristicPoolConfiguration;
import net.sf.ehcache.store.offheap.disk.OffHeapDiskStoreFactory;
import net.sf.ehcache.store.offheap.pool.OffHeapPool;
import net.sf.ehcache.store.offheap.pool.impl.OffHeapPoolEvictorImpl;
import net.sf.ehcache.store.offheap.pool.impl.OffHeapPoolImpl;
import net.sf.ehcache.store.offheap.search.LuceneIndexedSearchManager;
import net.sf.ehcache.store.offheap.tiering.DiskBackedOffHeapStore;
import net.sf.ehcache.store.offheap.tiering.OnHeapFrontedOffHeapStore;
import net.sf.ehcache.store.restartability.EhcacheRestartability;
import net.sf.ehcache.store.restartability.RestartableSoftLockManager;
import net.sf.ehcache.transaction.SoftLockFactory;
import net.sf.ehcache.transaction.SoftLockManager;
import net.sf.ehcache.transaction.SoftLockManagerImpl;
import net.sf.ehcache.transaction.TransactionIDFactory;
import net.sf.ehcache.transaction.TransactionIDFactoryImpl;
import net.sf.ehcache.util.AtomicLongSequence;
import net.sf.ehcache.util.EnterpriseUpdateChecker;
import net.sf.ehcache.util.LongSequence;
import net.sf.ehcache.util.UpdateChecker;
import net.sf.ehcache.writer.writebehind.RestartableWriteBehindQueueManager;
import net.sf.ehcache.writer.writebehind.WriteBehind;
import org.terracotta.ehcachedx.util.Vm;
import org.terracotta.license.LicenseException;
import org.terracotta.license.ehcache.LicenseManager;

public class EnterpriseFeaturesManager
implements FeaturesManager {
    private static final WeakIdentityHashMap<CacheManager, OffHeapPool> OFFHEAP_POOLS = new WeakIdentityHashMap();
    private final EhcacheRestartability restartability;
    private final CacheManager cacheManager;
    private final PageSource pageSource;
    private volatile LuceneIndexedSearchManager luceneIndexedSearchManager;

    public EnterpriseFeaturesManager(CacheManager manager) {
        this.cacheManager = manager;
        this.restartability = new EhcacheRestartability(manager);
        if (Boolean.getBoolean("net.sf.ehcache.search.useOffheapIndex")) {
            if (!manager.getConfiguration().isMaxBytesLocalOffHeapSet()) {
                throw new InvalidConfigurationException("To use offheap search index you must configure a cacheManager level maxBytesLocalOffHeap");
            }
            this.pageSource = this.getOrCreateCacheManagerOffHeapPool(manager).getPageSource();
        } else {
            this.pageSource = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OffHeapPool getOrCreateCacheManagerOffHeapPool(CacheManager manager) {
        WeakIdentityHashMap<CacheManager, OffHeapPool> weakIdentityHashMap = OFFHEAP_POOLS;
        synchronized (weakIdentityHashMap) {
            OffHeapPool pool = OFFHEAP_POOLS.get(manager);
            if (pool == null) {
                HeuristicPoolConfiguration poolConfig = this.getPoolConfig(manager);
                long size = poolConfig.getMaximumSize();
                LicenseManager.verifyOffHeapUsage(manager, null, size);
                pool = new OffHeapPoolImpl(poolConfig, new OffHeapPoolEvictorImpl());
                OFFHEAP_POOLS.put(manager, pool);
                LicenseManager.commitOffHeapUsage(manager, null, size);
            }
            return pool;
        }
    }

    @Override
    public synchronized void startup() {
        this.restartability.startup();
        if (this.luceneIndexedSearchManager != null) {
            this.luceneIndexedSearchManager.recoveryComplete();
        }
    }

    @Override
    public synchronized void dispose() {
        this.restartability.shutdown();
        if (this.luceneIndexedSearchManager != null) {
            this.luceneIndexedSearchManager.shutdown();
        }
    }

    @Override
    public synchronized Store createStore(Cache cache, Pool<PoolableStore> onHeapPool, Pool<PoolableStore> onDiskPool) {
        CacheConfiguration cacheConfig = cache.getCacheConfiguration();
        long offHeapSize = 0L;
        if (cacheConfig.isOverflowToOffHeap()) {
            offHeapSize = EnterpriseFeaturesManager.getOffHeapSize(cache.getCacheConfiguration(), cache.getCacheManager().getConfiguration().getMaxBytesLocalOffHeap());
            try {
                LicenseManager.verifyOffHeapUsage(cache.getCacheManager(), cache.getName(), offHeapSize);
            }
            catch (LicenseException e) {
                throw new CacheException(e.getMessage());
            }
        }
        Store store = this.basicCreateStore(cache, onHeapPool, onDiskPool);
        if (offHeapSize > 0L) {
            LicenseManager.commitOffHeapUsage(cache.getCacheManager(), cache.getName(), offHeapSize);
        }
        if (cache.isSearchable()) {
            LongSequence sequence = cacheConfig.getPersistenceConfiguration() == null || cacheConfig.getPersistenceConfiguration().getStrategy() != PersistenceConfiguration.Strategy.LOCALRESTARTABLE ? new AtomicLongSequence() : this.restartability.getElementIdSequence(cache.getName());
            store = new ElementIdAssigningStore(store, sequence);
        }
        return store;
    }

    private Store basicCreateStore(Cache cache, Pool<PoolableStore> onHeapPool, Pool<PoolableStore> onDiskPool) {
        CacheConfiguration config = cache.getCacheConfiguration();
        PersistenceConfiguration persistence = config.getPersistenceConfiguration();
        if (persistence == null) {
            if (EnterpriseFeaturesManager.isDiskPersistent(config)) {
                throw new AssertionError((Object)"Configuration is inconsistent");
            }
            return this.createNonPersistentStore(cache, onHeapPool, onDiskPool);
        }
        switch (persistence.getStrategy()) {
            case NONE: {
                return this.createNonPersistentStore(cache, onHeapPool, onDiskPool);
            }
            case LOCALTEMPSWAP: {
                if (EnterpriseFeaturesManager.isDiskPersistent(config)) {
                    return this.createPersistentStore(cache, onHeapPool, onDiskPool);
                }
                return this.createNonPersistentStore(cache, onHeapPool, onDiskPool);
            }
            case LOCALRESTARTABLE: {
                boolean synchronousWrites = persistence.getSynchronousWrites();
                return this.createRestartableStore(cache, onHeapPool, onDiskPool, synchronousWrites);
            }
            case DISTRIBUTED: {
                throw new AssertionError();
            }
        }
        throw new AssertionError();
    }

    private static long getOffHeapSize(CacheConfiguration cacheConfig, long cacheManagerOffHeapBytes) {
        if (cacheConfig.isMaxBytesLocalOffHeapPercentageSet()) {
            return cacheManagerOffHeapBytes * (long)cacheConfig.getMaxBytesLocalOffHeapPercentage().intValue() / 100L;
        }
        return cacheConfig.getMaxBytesLocalOffHeap();
    }

    private LuceneIndexedSearchManager getOrCreateSearchManager(Cache cache) {
        if (!cache.isSearchable()) {
            return null;
        }
        if (this.luceneIndexedSearchManager == null) {
            this.luceneIndexedSearchManager = new LuceneIndexedSearchManager(this.cacheManager.getDiskStorePathManager(), this.restartability.getRestartableCaches(), this.pageSource);
            this.luceneIndexedSearchManager.startup();
        }
        return this.luceneIndexedSearchManager;
    }

    private Store createNonPersistentStore(Cache cache, Pool<PoolableStore> onHeapPool, Pool<PoolableStore> onDiskPool) {
        CacheConfiguration config = cache.getCacheConfiguration();
        if (config.isOverflowToDisk()) {
            LuceneIndexedSearchManager searchManager = this.getOrCreateSearchManager(cache);
            if (config.isOverflowToOffHeap()) {
                return new DiskBackedOffHeapStore(new OnHeapFrontedOffHeapStore(config, MemoryStore.create(cache, onHeapPool), OffHeapStoreFactory.createCache(cache, this.getOffHeapPool(cache), null), null), OffHeapDiskStoreFactory.create(cache, onDiskPool, searchManager), searchManager);
            }
            return new DiskBackedOffHeapStore(MemoryStore.create(cache, onHeapPool), OffHeapDiskStoreFactory.create(cache, onDiskPool, searchManager), searchManager);
        }
        if (config.isOverflowToOffHeap()) {
            LuceneIndexedSearchManager searchManager = this.getOrCreateSearchManager(cache);
            return new OnHeapFrontedOffHeapStore(config, MemoryStore.create(cache, onHeapPool), OffHeapStoreFactory.createAuthority(cache, this.getOffHeapPool(cache), searchManager), searchManager);
        }
        return MemoryOnlyStore.create(cache, onHeapPool);
    }

    private Store createPersistentStore(Cache cache, Pool<PoolableStore> onHeapPool, Pool<PoolableStore> onDiskPool) {
        CacheConfiguration config = cache.getCacheConfiguration();
        LuceneIndexedSearchManager searchManager = this.getOrCreateSearchManager(cache);
        if (config.isOverflowToOffHeap()) {
            return new DiskBackedOffHeapStore(new OnHeapFrontedOffHeapStore(config, MemoryStore.create(cache, onHeapPool), OffHeapStoreFactory.createCache(cache, this.getOffHeapPool(cache), null), null), OffHeapDiskStoreFactory.createPersistent(cache, onDiskPool, searchManager), searchManager);
        }
        return new DiskBackedOffHeapStore(MemoryStore.create(cache, onHeapPool), OffHeapDiskStoreFactory.createPersistent(cache, onDiskPool, searchManager), searchManager);
    }

    private Store createRestartableStore(Cache cache, Pool<PoolableStore> onHeapPool, Pool<PoolableStore> onDiskPool, boolean synchronousWrites) {
        LuceneIndexedSearchManager searchManager;
        Boolean persistentTxns;
        CacheConfiguration config = cache.getCacheConfiguration();
        if (!CacheConfiguration.TransactionalMode.OFF.equals((Object)config.getTransactionalMode()) && Boolean.FALSE.equals(persistentTxns = cache.getCacheManager().getOrCreateTransactionIDFactory().isPersistent())) {
            throw new InvalidConfigurationException("Transactions system is already bootstrapped as non-persistent - cannot add a restartable cache");
        }
        if (config.isOverflowToDisk()) {
            searchManager = this.getOrCreateSearchManager(cache);
            if (config.isOverflowToOffHeap()) {
                return new DiskBackedOffHeapStore(new OnHeapFrontedOffHeapStore(config, MemoryStore.create(cache, onHeapPool), OffHeapStoreFactory.createCache(cache, this.getOffHeapPool(cache), null), null), OffHeapDiskStoreFactory.createRestartable(this.restartability, cache, onDiskPool, synchronousWrites, searchManager), searchManager);
            }
            return new DiskBackedOffHeapStore(MemoryStore.create(cache, onHeapPool), OffHeapDiskStoreFactory.createRestartable(this.restartability, cache, onDiskPool, synchronousWrites, searchManager), searchManager);
        }
        if (config.isOverflowToOffHeap()) {
            searchManager = this.getOrCreateSearchManager(cache);
            return new OnHeapFrontedOffHeapStore(config, MemoryStore.create(cache, onHeapPool), OffHeapStoreFactory.createRestartableAuthority(this.restartability, cache, this.getOffHeapPool(cache), searchManager, synchronousWrites), searchManager);
        }
        return RestartableHeapOnlyStore.create(this.restartability, synchronousWrites, cache, onHeapPool);
    }

    public static long getMaxBytesAllocatable() {
        return Math.min(Vm.maxDirectMemory(), LicenseManager.getEhcacheOffHeapTotalSizeLimit());
    }

    private OffHeapPool getOffHeapPool(Cache cache) {
        if (cache.getCacheConfiguration().getMaxBytesLocalOffHeap() > 0L) {
            return null;
        }
        return this.getOrCreateCacheManagerOffHeapPool(cache.getCacheManager());
    }

    private HeuristicPoolConfiguration getPoolConfig(CacheManager manager) {
        return new HeuristicPoolConfiguration(manager.getName(), EnterpriseFeaturesManager.calculateCacheManagerFreeMaxBytesLocalOffHeap(manager), EnterpriseFeaturesManager.calculateCacheCountSharingCacheManagerOffHeapPool(manager));
    }

    private static long calculateCacheManagerFreeMaxBytesLocalOffHeap(CacheManager manager) {
        Map<String, CacheConfiguration> cacheConfigurations = manager.getConfiguration().getCacheConfigurations();
        long totalCacheSpecificMemory = 0L;
        for (CacheConfiguration cacheConfig : cacheConfigurations.values()) {
            totalCacheSpecificMemory += EnterpriseFeaturesManager.getOffHeapSize(cacheConfig, manager.getConfiguration().getMaxBytesLocalOffHeap());
        }
        return manager.getConfiguration().getMaxBytesLocalOffHeap() - totalCacheSpecificMemory;
    }

    private static int calculateCacheCountSharingCacheManagerOffHeapPool(CacheManager manager) {
        Map<String, CacheConfiguration> cacheConfigurations = manager.getConfiguration().getCacheConfigurations();
        Iterator<Map.Entry<String, CacheConfiguration>> iterator = cacheConfigurations.entrySet().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, CacheConfiguration> entry = iterator.next();
            if (entry.getValue().getMaxBytesLocalOffHeapPercentage() != null && entry.getValue().getMaxBytesLocalOffHeap() <= 0L) continue;
            ++count;
        }
        return count;
    }

    private static boolean isDiskPersistent(CacheConfiguration cacheConfig) {
        return cacheConfig.isDiskPersistent();
    }

    @Override
    public WriteBehind createWriteBehind(Cache cache) {
        return new RestartableWriteBehindQueueManager(cache.getCacheConfiguration(), this.restartability);
    }

    @Override
    public TransactionIDFactory createTransactionIDFactory() {
        if (this.restartability.bootstrapped()) {
            return this.restartability.getTransactionIDFactory();
        }
        return new TransactionIDFactoryImpl();
    }

    @Override
    public SoftLockManager createSoftLockManager(Ehcache cache, SoftLockFactory lockFactory) {
        if (cache.getCacheConfiguration().getPersistenceConfiguration() != null && cache.getCacheConfiguration().getPersistenceConfiguration().getStrategy() == PersistenceConfiguration.Strategy.LOCALRESTARTABLE) {
            return new RestartableSoftLockManager(cache.getName(), lockFactory, this.restartability);
        }
        return new SoftLockManagerImpl(cache.getName(), lockFactory);
    }

    @Override
    public UpdateChecker createUpdateChecker() {
        return new EnterpriseUpdateChecker(this.cacheManager);
    }
}

