/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.terracotta.license.AbstractLicenseResolverFactory;
import org.terracotta.license.EnterpriseLicense;
import org.terracotta.license.License;
import org.terracotta.license.LicenseConstants;
import org.terracotta.license.LicenseException;
import org.terracotta.license.LicenseSigner;
import org.terracotta.license.util.IOUtils;
import org.terracotta.license.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseLicenseResolverFactory
extends AbstractLicenseResolverFactory {
    private static final boolean DEBUG_LICENSE = Boolean.getBoolean("org.terracotta.license.debug");
    private static final String TC_INSTALL_ROOT = "tc.install-root";
    private static final boolean SKIP_DEFAULT_LOCATION = Boolean.getBoolean("org.terracotta.license.skip.default.locations");
    private static final String DEFAULT_LICENSE_RESOURCE_PATH = "/terracotta-license.key";
    private String licenseLocation;

    @Override
    public License resolveLicense() {
        License license = null;
        String path = null;
        path = this.getProperty("com.tc.productkey.resource.path");
        this.debugLog("Trying to load license from property com.tc.productkey.resource.path, value '" + path + "'");
        if (path != null && (license = this.resolveLicenseFromResource(path)) != null) {
            return license;
        }
        for (String key : new String[]{"org.terracotta.license.path", "com.tc.productkey.path"}) {
            path = this.getProperty(key);
            this.debugLog("Trying to load license from property " + key + ", value '" + path + "'");
            if (path == null || (license = this.resolveLicenseFromPath(path)) == null) continue;
            return license;
        }
        if (!SKIP_DEFAULT_LOCATION) {
            path = this.getProperty(TC_INSTALL_ROOT);
            this.debugLog("Trying to load license from property tc.install-root, value '" + path + "'");
            if (path != null) {
                license = this.loadFromDefaultPath(path + File.separator + "terracotta-license.key");
                if (license != null) {
                    return license;
                }
                license = this.loadFromDefaultPath(path + File.separator + "product.key");
                if (license != null) {
                    return license;
                }
            }
            this.debugLog("Trying to load license from resource /terracotta-license.key");
            license = this.resolveLicenseFromResource(DEFAULT_LICENSE_RESOURCE_PATH);
            if (license != null) {
                return license;
            }
        }
        return null;
    }

    private License loadFromDefaultPath(String path) {
        File rootLicenseKey = new File(path);
        if (rootLicenseKey.exists()) {
            try {
                return this.resolveLicenseFromPath(rootLicenseKey.getCanonicalPath());
            }
            catch (IOException e) {
                throw new LicenseException(e);
            }
        }
        return null;
    }

    @Override
    public String getLicenseLocation() {
        return this.licenseLocation;
    }

    protected License resolveLicenseFromPath(String productKeyPath) {
        License license;
        this.debugLog("Resolving license from path " + productKeyPath);
        if (productKeyPath == null) {
            return null;
        }
        if (productKeyPath.startsWith("resource:")) {
            String resourcePath = productKeyPath.substring("resource:".length());
            this.debugLog("XXX Path starts with 'resource:', will load as resource " + resourcePath);
            return this.resolveLicenseFromResource(resourcePath);
        }
        File productKeyFile = new File(productKeyPath);
        if (!productKeyFile.isFile() || !productKeyFile.canRead()) {
            throw new LicenseException("License key file " + productKeyFile.getAbsolutePath() + " does not exist or cannot be read");
        }
        FileInputStream in = null;
        try {
            this.licenseLocation = productKeyPath;
            in = new FileInputStream(productKeyFile);
            license = this.resolveLicenseFromStream(in);
        }
        catch (FileNotFoundException e) {
            try {
                throw new LicenseException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        return license;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected License resolveLicenseFromResource(String resourcePath) {
        InputStream in = EnterpriseLicenseResolverFactory.class.getResourceAsStream(resourcePath);
        if (in == null) {
            return null;
        }
        try {
            this.licenseLocation = "resource " + resourcePath;
            License license = this.resolveLicenseFromStream(in);
            return license;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    protected License resolveLicenseFromStream(InputStream in) {
        if (in == null) {
            return null;
        }
        Properties licenseProps = null;
        LicenseSigner signer = new LicenseSigner();
        try {
            boolean licenseValid;
            List<String> lines = Utils.readLines(in);
            if (this.isOldLicense(lines)) {
                String signature = this.extractSignatureFromOldLicense(lines);
                licenseValid = signer.verify(Utils.toBytes(lines, "UTF-8"), signature);
                licenseProps = this.upgradeLicense(lines, signature);
            } else {
                licenseProps = Utils.loadProperties(lines);
                licenseValid = new LicenseSigner().verify(Utils.toBytes(licenseProps, LicenseConstants.IGNORED_KEYS, "UTF-8"), licenseProps.getProperty("Signature"));
            }
            if (!licenseValid) {
                throw new LicenseException("Your Terracotta license key is not valid. The content doesn't match with the provided signature.");
            }
            return new EnterpriseLicense(licenseProps);
        }
        catch (UnsupportedEncodingException e) {
            throw new LicenseException(e.getMessage());
        }
        catch (IOException e) {
            throw new LicenseException(e.getMessage());
        }
    }

    @Override
    public License resolveLicense(InputStream in) {
        this.licenseLocation = "stream";
        return this.resolveLicenseFromStream(in);
    }

    private void debugLog(String message) {
        if (DEBUG_LICENSE) {
            System.err.println(String.format("[DEBUG] %s: %s", EnterpriseLicenseResolverFactory.class.getName(), message));
            System.err.flush();
        }
    }

    private boolean isOldLicense(List<String> lines) {
        for (String line : lines) {
            if (!line.contains("--------------------- BEGIN TERRACOTTA LICENSE KEY ---------------------")) continue;
            return true;
        }
        return false;
    }

    private String extractSignatureFromOldLicense(List<String> lines) {
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (!line.contains("---------------------------- BEGIN SIGNATURE ---------------------------")) continue;
            if (i + 1 >= lines.size()) {
                throw new LicenseException("You don't have a valid Terracotta license key. License sigature is missing.");
            }
            return lines.get(i + 1);
        }
        throw new LicenseException("You don't have a valid Terracotta license key.");
    }

    private Properties upgradeLicense(List<String> lines, String signature) {
        ArrayList<String> newLines = new ArrayList<String>();
        for (String line : Utils.filterNoneLicenseInfo(lines)) {
            line = line.replace("Terracotta operator console", "operator console");
            line = line.replace("TOC", "operator console");
            line = line.replace("Max clients", "Max Client Count");
            line = line.replace("License type", "License Type");
            line = line.replace("License number", "License Number");
            if ((line = line.replace("Expiration date", "Expiration Date")).startsWith("Capabilities") && !line.contains("DCV2")) {
                line = line + ", " + "DCV2";
            }
            newLines.add(line);
        }
        Properties props = Utils.loadProperties(newLines);
        props.setProperty("Product", "Enterprise Suite");
        props.setProperty("Edition", "Custom");
        props.setProperty("Date of Issue", "Upgraded from old license key on " + LicenseConstants.dateFormatter().format(new Date()));
        props.setProperty("Signature", signature);
        return props;
    }

    protected String getProperty(String key) {
        String value = System.getProperty(key);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }
}

