/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.search;

import com.terracottatech.offheapstore.storage.listener.StorageEngineListener;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.SearchAttribute;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.store.offheap.search.LuceneIndexedSearchManager;

public class SearchStorageEngineListener<K>
implements StorageEngineListener<K, Element> {
    private final Map<String, AttributeExtractor> extractors = new HashMap<String, AttributeExtractor>();
    private final LuceneIndexedSearchManager searchManager;
    private final String cacheName;
    private final int segmentId;
    private final CacheConfiguration config;

    public SearchStorageEngineListener(LuceneIndexedSearchManager searchManager, CacheConfiguration cacheConfig, int segmentId) {
        this.searchManager = searchManager;
        this.segmentId = segmentId;
        this.cacheName = cacheConfig.getName();
        this.config = cacheConfig;
        for (Map.Entry<String, SearchAttribute> entry : cacheConfig.getSearchable().getSearchAttributes().entrySet()) {
            this.extractors.put(entry.getKey(), entry.getValue().constructExtractor());
        }
    }

    @Override
    public void written(K key, Element value, ByteBuffer binaryKey, ByteBuffer binaryValue, int hash, int metadata, long encoding) {
        if (this.searchManager.shouldIndex()) {
            this.searchManager.put(this.cacheName, this.segmentId, value, this.extractors, this.config.getDynamicExtractor());
        }
    }

    @Override
    public void freed(K key, long encoding, int hash, boolean removed) {
        if (this.searchManager.shouldIndex()) {
            this.searchManager.remove(this.cacheName, key, this.segmentId, removed);
        }
    }

    @Override
    public void cleared() {
        if (this.searchManager.shouldIndex()) {
            this.searchManager.clear(this.cacheName, this.segmentId);
        }
    }

    @Override
    public void copied(int hash, long oldEncoding, long newEncoding, int metadata) {
    }
}

