/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.util;

import com.terracottatech.offheapstore.util.AbstractStatistic;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class AtomicStatistic
extends AbstractStatistic {
    private static final int RATE_SAMPLE_TIME_FLAG_BITS = 1;
    private static final long RATE_CALCULATION_FLAG = 1L;
    private final AtomicLong count = new AtomicLong(0L);
    private final AtomicLong rateSampleTime = new AtomicLong(AtomicStatistic.getTime() << 1);
    private volatile float rateSample = Float.NaN;
    private volatile long sampleRateMask = 0L;
    private volatile long previousSample = 0L;

    public AtomicStatistic(long averagePeriod, TimeUnit unit) {
        super(averagePeriod, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void event() {
        long value = this.count.incrementAndGet();
        if ((value & this.sampleRateMask) == 0L) {
            long now = AtomicStatistic.getTime();
            long previous = this.startIncrementTime(now);
            try {
                if (now != previous && value > this.previousSample) {
                    float nowRate = (float)(value - this.previousSample) / (float)(now - previous);
                    this.rateSample = this.iterateMovingAverage(nowRate, now, this.rateSample, previous);
                    this.previousSample = value;
                    long suggestedSampleRateMask = Long.highestOneBit(Math.max(1L, (long)((float)this.rateAveragePeriod * this.rateSample))) - 1L;
                    if (suggestedSampleRateMask != this.sampleRateMask) {
                        this.sampleRateMask = suggestedSampleRateMask;
                    }
                }
            }
            finally {
                this.finishIncrementTime(now);
            }
        }
    }

    @Override
    public long getCount() {
        return this.count.get();
    }

    @Override
    public float getRate() {
        float thenAverage;
        long lastSample;
        long then;
        do {
            then = this.startReadTime();
            lastSample = this.previousSample;
            thenAverage = this.rateSample;
        } while (!this.validateTimeRead(then));
        long now = AtomicStatistic.getTime();
        if (now == then) {
            return thenAverage;
        }
        float nowValue = (float)(this.count.get() - lastSample) / (float)(now - then);
        float rate = this.iterateMovingAverage(nowValue, now, thenAverage, then) * (float)TimeUnit.SECONDS.toNanos(1L);
        if (Float.isNaN(rate)) {
            if (Float.isNaN(thenAverage)) {
                return 0.0f;
            }
            return thenAverage;
        }
        return rate;
    }

    private long startIncrementTime(long newTime) {
        long current;
        while (((current = this.rateSampleTime.get()) & 1L) != 0L || !this.rateSampleTime.compareAndSet(current, newTime << 1 | 1L)) {
        }
        return current >>> 1;
    }

    private void finishIncrementTime(long value) {
        if (!this.rateSampleTime.compareAndSet(value << 1 | 1L, value << 1)) {
            throw new AssertionError();
        }
    }

    private long startReadTime() {
        long current;
        while (((current = this.rateSampleTime.get()) & 1L) != 0L) {
        }
        return current >>> 1;
    }

    private boolean validateTimeRead(long current) {
        return this.rateSampleTime.get() == current << 1;
    }

    private static long getTime() {
        return System.nanoTime();
    }
}

