/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.concurrent;

import com.terracottatech.offheapstore.concurrent.AbstractConcurrentOffHeapMap;
import com.terracottatech.offheapstore.concurrent.ReadWriteLockedOffHeapHashMapFactory;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.util.Factory;

public class ConcurrentOffHeapHashMap<K, V>
extends AbstractConcurrentOffHeapMap<K, V> {
    public ConcurrentOffHeapHashMap(PageSource tableSource, Factory<? extends StorageEngine<? super K, ? super V>> storageEngineFactory) {
        super(new ReadWriteLockedOffHeapHashMapFactory(tableSource, storageEngineFactory), false);
    }

    public ConcurrentOffHeapHashMap(PageSource tableSource, boolean tableAllocationsSteal, Factory<? extends StorageEngine<? super K, ? super V>> storageEngineFactory) {
        super(new ReadWriteLockedOffHeapHashMapFactory(tableSource, tableAllocationsSteal, storageEngineFactory), false);
    }

    public ConcurrentOffHeapHashMap(PageSource tableSource, Factory<? extends StorageEngine<? super K, ? super V>> storageEngineFactory, boolean latencyMonitoring) {
        super(new ReadWriteLockedOffHeapHashMapFactory(tableSource, storageEngineFactory), latencyMonitoring);
    }

    public ConcurrentOffHeapHashMap(PageSource tableSource, Factory<? extends StorageEngine<? super K, ? super V>> storageEngineFactory, long tableSize, int concurrency) {
        super(new ReadWriteLockedOffHeapHashMapFactory(tableSource, storageEngineFactory, (int)(tableSize / (long)concurrency)), concurrency, false);
    }

    public ConcurrentOffHeapHashMap(PageSource tableSource, boolean tableAllocationsSteal, Factory<? extends StorageEngine<? super K, ? super V>> storageEngineFactory, long tableSize, int concurrency) {
        super(new ReadWriteLockedOffHeapHashMapFactory(tableSource, tableAllocationsSteal, storageEngineFactory, (int)(tableSize / (long)concurrency)), concurrency, false);
    }
}

