/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io;

import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.CachingBufferSource;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class GlobalBufferSource
implements BufferSource {
    private static GlobalBufferSource GLOBAL = new GlobalBufferSource();
    private long maxCapacity = 0L;
    private final CachingBufferSource delegate = new CachingBufferSource();
    private static Map<BufferSource, Long> clients = Collections.synchronizedMap(new HashMap());

    GlobalBufferSource() {
    }

    static GlobalBufferSource getInstance(BufferSource client, long capacity) {
        clients.put(client, capacity);
        GLOBAL.addCapacity(capacity);
        return GLOBAL;
    }

    static void release(BufferSource client) {
        Long cap = clients.remove(client);
        if (cap != null) {
            GLOBAL.releaseCapacity(cap);
            if (clients.isEmpty()) {
                GLOBAL = new GlobalBufferSource();
            }
        }
    }

    public synchronized void addCapacity(long max) {
        if (this.maxCapacity < max) {
            this.maxCapacity = max;
        }
    }

    public synchronized void releaseCapacity(long max) {
        this.maxCapacity -= max;
    }

    @Override
    public synchronized ByteBuffer getBuffer(int size) {
        return this.delegate.getBuffer(size);
    }

    @Override
    public synchronized void reclaim() {
        this.delegate.reclaim();
    }

    @Override
    public synchronized void returnBuffer(ByteBuffer buffer) {
        if (this.delegate.getSize() + (long)buffer.capacity() > this.maxCapacity) {
            return;
        }
        this.delegate.returnBuffer(buffer);
    }
}

