/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.terracotta.shaded.lucene.search.Collector;
import org.terracotta.shaded.lucene.search.DocIdSetIterator;
import org.terracotta.shaded.lucene.search.Weight;

public abstract class Scorer
extends DocIdSetIterator {
    protected final Weight weight;

    protected Scorer(Weight weight) {
        this.weight = weight;
    }

    public void score(Collector collector) throws IOException {
        int doc;
        collector.setScorer(this);
        while ((doc = this.nextDoc()) != Integer.MAX_VALUE) {
            collector.collect(doc);
        }
    }

    public boolean score(Collector collector, int max, int firstDocID) throws IOException {
        collector.setScorer(this);
        int doc = firstDocID;
        while (doc < max) {
            collector.collect(doc);
            doc = this.nextDoc();
        }
        return doc != Integer.MAX_VALUE;
    }

    public abstract float score() throws IOException;

    public abstract float freq() throws IOException;

    public Weight getWeight() {
        return this.weight;
    }

    public Collection<ChildScorer> getChildren() {
        return Collections.emptyList();
    }

    public static class ChildScorer {
        public final Scorer child;
        public final String relationship;

        public ChildScorer(Scorer child, String relationship) {
            this.child = child;
            this.relationship = relationship;
        }
    }
}

