/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.terracotta.shaded.lucene.index.DocInverterPerField;
import org.terracotta.shaded.lucene.index.DocumentsWriterPerThread;
import org.terracotta.shaded.lucene.index.FieldInfo;
import org.terracotta.shaded.lucene.index.IntBlockPool;
import org.terracotta.shaded.lucene.index.InvertedDocConsumer;
import org.terracotta.shaded.lucene.index.InvertedDocConsumerPerField;
import org.terracotta.shaded.lucene.index.SegmentWriteState;
import org.terracotta.shaded.lucene.index.TermsHashConsumer;
import org.terracotta.shaded.lucene.index.TermsHashConsumerPerField;
import org.terracotta.shaded.lucene.index.TermsHashPerField;
import org.terracotta.shaded.lucene.util.ByteBlockPool;
import org.terracotta.shaded.lucene.util.BytesRef;

final class TermsHash
extends InvertedDocConsumer {
    final TermsHashConsumer consumer;
    final TermsHash nextTermsHash;
    final DocumentsWriterPerThread docWriter;
    final IntBlockPool intPool;
    final ByteBlockPool bytePool;
    ByteBlockPool termBytePool;
    final boolean primary;
    final DocumentsWriterPerThread.DocState docState;
    final BytesRef tr1 = new BytesRef();
    final BytesRef tr2 = new BytesRef();
    final BytesRef termBytesRef = new BytesRef(10);
    final boolean trackAllocations;

    public TermsHash(DocumentsWriterPerThread docWriter, TermsHashConsumer consumer, boolean trackAllocations, TermsHash nextTermsHash) {
        this.docState = docWriter.docState;
        this.docWriter = docWriter;
        this.consumer = consumer;
        this.trackAllocations = trackAllocations;
        this.nextTermsHash = nextTermsHash;
        this.intPool = new IntBlockPool(docWriter);
        this.bytePool = new ByteBlockPool(docWriter.byteBlockAllocator);
        if (nextTermsHash != null) {
            this.primary = true;
            this.termBytePool = this.bytePool;
            nextTermsHash.termBytePool = this.bytePool;
        } else {
            this.primary = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        this.reset();
        try {
            this.consumer.abort();
        }
        finally {
            if (this.nextTermsHash != null) {
                this.nextTermsHash.abort();
            }
        }
    }

    void reset() {
        this.intPool.reset();
        this.bytePool.reset();
        if (this.primary) {
            this.bytePool.reset();
        }
    }

    @Override
    void flush(Map<String, InvertedDocConsumerPerField> fieldsToFlush, SegmentWriteState state) throws IOException {
        HashMap<String, TermsHashConsumerPerField> childFields = new HashMap<String, TermsHashConsumerPerField>();
        HashMap<String, InvertedDocConsumerPerField> nextChildFields = this.nextTermsHash != null ? new HashMap<String, InvertedDocConsumerPerField>() : null;
        for (Map.Entry<String, InvertedDocConsumerPerField> entry : fieldsToFlush.entrySet()) {
            TermsHashPerField perField = (TermsHashPerField)entry.getValue();
            childFields.put(entry.getKey(), perField.consumer);
            if (this.nextTermsHash == null) continue;
            nextChildFields.put(entry.getKey(), perField.nextPerField);
        }
        this.consumer.flush(childFields, state);
        if (this.nextTermsHash != null) {
            this.nextTermsHash.flush(nextChildFields, state);
        }
    }

    @Override
    InvertedDocConsumerPerField addField(DocInverterPerField docInverterPerField, FieldInfo fieldInfo) {
        return new TermsHashPerField(docInverterPerField, this, this.nextTermsHash, fieldInfo);
    }

    @Override
    public boolean freeRAM() {
        return false;
    }

    @Override
    void finishDocument() throws IOException {
        this.consumer.finishDocument(this);
        if (this.nextTermsHash != null) {
            this.nextTermsHash.consumer.finishDocument(this.nextTermsHash);
        }
    }

    @Override
    void startDocument() throws IOException {
        this.consumer.startDocument();
        if (this.nextTermsHash != null) {
            this.nextTermsHash.consumer.startDocument();
        }
    }
}

