/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.codecs.lucene40.values;

import java.util.Comparator;
import org.terracotta.shaded.lucene.codecs.DocValuesConsumer;
import org.terracotta.shaded.lucene.codecs.lucene40.values.Bytes;
import org.terracotta.shaded.lucene.codecs.lucene40.values.Floats;
import org.terracotta.shaded.lucene.codecs.lucene40.values.Ints;
import org.terracotta.shaded.lucene.index.DocValues;
import org.terracotta.shaded.lucene.store.Directory;
import org.terracotta.shaded.lucene.store.IOContext;
import org.terracotta.shaded.lucene.util.BytesRef;
import org.terracotta.shaded.lucene.util.Counter;

abstract class Writer
extends DocValuesConsumer {
    protected final Counter bytesUsed;
    protected DocValues.Type type;

    protected Writer(Counter bytesUsed, DocValues.Type type) {
        this.bytesUsed = bytesUsed;
        this.type = type;
    }

    @Override
    protected DocValues.Type getType() {
        return this.type;
    }

    public static DocValuesConsumer create(DocValues.Type type, String id, Directory directory, Comparator<BytesRef> comp, Counter bytesUsed, IOContext context, float acceptableOverheadRatio) {
        if (comp == null) {
            comp = BytesRef.getUTF8SortedAsUnicodeComparator();
        }
        switch (type) {
            case FIXED_INTS_16: 
            case FIXED_INTS_32: 
            case FIXED_INTS_64: 
            case FIXED_INTS_8: 
            case VAR_INTS: {
                return Ints.getWriter(directory, id, bytesUsed, type, context);
            }
            case FLOAT_32: {
                return Floats.getWriter(directory, id, bytesUsed, context, type);
            }
            case FLOAT_64: {
                return Floats.getWriter(directory, id, bytesUsed, context, type);
            }
            case BYTES_FIXED_STRAIGHT: {
                return Bytes.getWriter(directory, id, Bytes.Mode.STRAIGHT, true, comp, bytesUsed, context, acceptableOverheadRatio);
            }
            case BYTES_FIXED_DEREF: {
                return Bytes.getWriter(directory, id, Bytes.Mode.DEREF, true, comp, bytesUsed, context, acceptableOverheadRatio);
            }
            case BYTES_FIXED_SORTED: {
                return Bytes.getWriter(directory, id, Bytes.Mode.SORTED, true, comp, bytesUsed, context, acceptableOverheadRatio);
            }
            case BYTES_VAR_STRAIGHT: {
                return Bytes.getWriter(directory, id, Bytes.Mode.STRAIGHT, false, comp, bytesUsed, context, acceptableOverheadRatio);
            }
            case BYTES_VAR_DEREF: {
                return Bytes.getWriter(directory, id, Bytes.Mode.DEREF, false, comp, bytesUsed, context, acceptableOverheadRatio);
            }
            case BYTES_VAR_SORTED: {
                return Bytes.getWriter(directory, id, Bytes.Mode.SORTED, false, comp, bytesUsed, context, acceptableOverheadRatio);
            }
        }
        throw new IllegalArgumentException("Unknown Values: " + (Object)((Object)type));
    }
}

