/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.codecs.lucene40.values;

import java.io.IOException;
import org.terracotta.shaded.lucene.codecs.DocValuesArraySource;
import org.terracotta.shaded.lucene.codecs.DocValuesConsumer;
import org.terracotta.shaded.lucene.codecs.lucene40.values.FixedStraightBytesImpl;
import org.terracotta.shaded.lucene.codecs.lucene40.values.PackedIntValues;
import org.terracotta.shaded.lucene.index.DocValues;
import org.terracotta.shaded.lucene.index.IndexableField;
import org.terracotta.shaded.lucene.store.Directory;
import org.terracotta.shaded.lucene.store.IOContext;
import org.terracotta.shaded.lucene.store.IndexInput;
import org.terracotta.shaded.lucene.util.BytesRef;
import org.terracotta.shaded.lucene.util.Counter;
import org.terracotta.shaded.lucene.util.IOUtils;

public final class Ints {
    protected static final String CODEC_NAME = "Ints";
    protected static final int VERSION_START = 0;
    protected static final int VERSION_CURRENT = 0;

    private Ints() {
    }

    public static DocValuesConsumer getWriter(Directory dir, String id, Counter bytesUsed, DocValues.Type type, IOContext context) {
        return type == DocValues.Type.VAR_INTS ? new PackedIntValues.PackedIntsWriter(dir, id, bytesUsed, context) : new IntsWriter(dir, id, bytesUsed, context, type);
    }

    public static DocValues getValues(Directory dir, String id, int numDocs, DocValues.Type type, IOContext context) throws IOException {
        return type == DocValues.Type.VAR_INTS ? new PackedIntValues.PackedIntsReader(dir, id, numDocs, context) : new IntsReader(dir, id, numDocs, context, type);
    }

    private static DocValues.Type sizeToType(int size) {
        switch (size) {
            case 1: {
                return DocValues.Type.FIXED_INTS_8;
            }
            case 2: {
                return DocValues.Type.FIXED_INTS_16;
            }
            case 4: {
                return DocValues.Type.FIXED_INTS_32;
            }
            case 8: {
                return DocValues.Type.FIXED_INTS_64;
            }
        }
        throw new IllegalStateException("illegal size " + size);
    }

    private static int typeToSize(DocValues.Type type) {
        switch (type) {
            case FIXED_INTS_16: {
                return 2;
            }
            case FIXED_INTS_32: {
                return 4;
            }
            case FIXED_INTS_64: {
                return 8;
            }
            case FIXED_INTS_8: {
                return 1;
            }
        }
        throw new IllegalStateException("illegal type " + (Object)((Object)type));
    }

    static final class IntsReader
    extends FixedStraightBytesImpl.FixedStraightReader {
        private final DocValuesArraySource arrayTemplate;

        IntsReader(Directory dir, String id, int maxDoc, IOContext context, DocValues.Type type) throws IOException {
            super(dir, id, Ints.CODEC_NAME, 0, maxDoc, context, type);
            this.arrayTemplate = DocValuesArraySource.forType(type);
            assert (this.arrayTemplate != null);
            assert (type == Ints.sizeToType(this.size));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DocValues.Source load() throws IOException {
            DocValuesArraySource docValuesArraySource;
            IndexInput indexInput = this.cloneData();
            try {
                docValuesArraySource = this.arrayTemplate.newFromInput(indexInput, this.maxDoc);
            }
            catch (Throwable throwable) {
                IOUtils.close(indexInput);
                throw throwable;
            }
            IOUtils.close(indexInput);
            return docValuesArraySource;
        }
    }

    static class IntsWriter
    extends FixedStraightBytesImpl.Writer {
        private final DocValuesArraySource template;

        public IntsWriter(Directory dir, String id, Counter bytesUsed, IOContext context, DocValues.Type valueType) {
            this(dir, id, Ints.CODEC_NAME, 0, bytesUsed, context, valueType);
        }

        protected IntsWriter(Directory dir, String id, String codecName, int version, Counter bytesUsed, IOContext context, DocValues.Type valueType) {
            super(dir, id, codecName, version, bytesUsed, context);
            this.size = Ints.typeToSize(valueType);
            this.bytesRef = new BytesRef(this.size);
            this.bytesRef.length = this.size;
            this.template = DocValuesArraySource.forType(valueType);
        }

        @Override
        protected void setMergeBytes(DocValues.Source source, int sourceDoc) {
            long value = source.getInt(sourceDoc);
            this.template.toBytes(value, this.bytesRef);
        }

        @Override
        public void add(int docID, IndexableField value) throws IOException {
            this.template.toBytes(value.numericValue().longValue(), this.bytesRef);
            this.bytesSpareField.setBytesValue(this.bytesRef);
            super.add(docID, this.bytesSpareField);
        }

        @Override
        protected boolean tryBulkMerge(DocValues docValues) {
            return super.tryBulkMerge(docValues) && docValues.getType() == this.template.getType();
        }
    }
}

