/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.terracotta.license.LicenseException;
import org.terracotta.license.util.Base64;
import org.terracotta.license.util.IOUtils;

public class LicenseSigner {
    private static final String LICENSE_PUBLIC_KEY_RESOURCE_NAME = "license-public-key.x509";

    public String sign(byte[] content, File privateKeyFile) {
        if (privateKeyFile == null || !privateKeyFile.exists()) {
            throw new IllegalArgumentException("Private key file is needed to sign");
        }
        try {
            Signature signature = LicenseSigner.prepareSignSignature(new FileInputStream(privateKeyFile));
            signature.update(content);
            byte[] signatureData = signature.sign();
            return Base64.encodeBytes(signatureData);
        }
        catch (FileNotFoundException fne) {
            throw new IllegalArgumentException("Private key not found: " + privateKeyFile);
        }
        catch (SignatureException e) {
            throw new LicenseException("failed to sign license", e);
        }
    }

    public String sign(byte[] content, InputStream privateKeyInputStream) {
        Signature signature = LicenseSigner.prepareSignSignature(privateKeyInputStream);
        try {
            signature.update(content);
            byte[] signatureData = signature.sign();
            return Base64.encodeBytes(signatureData);
        }
        catch (SignatureException e) {
            throw new LicenseException("failed to sign license", e);
        }
    }

    public boolean verify(byte[] content, String signatureString) {
        try {
            Signature signature = LicenseSigner.prepareVerifySignature();
            signature.update(content);
            return signature.verify(Base64.decode(signatureString));
        }
        catch (Exception e) {
            throw new LicenseException("Failed to verify license signature", e);
        }
    }

    private static Signature prepareVerifySignature() {
        InputStream in = LicenseSigner.class.getResourceAsStream(LICENSE_PUBLIC_KEY_RESOURCE_NAME);
        if (in == null) {
            throw new RuntimeException("Can't find public key: license-public-key.x509");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IOUtils.copy(in, baos);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(baos.toByteArray());
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(publicKey);
            Signature signature2 = signature;
            return signature2;
        }
        catch (Throwable e) {
            throw new LicenseException(e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    private static Signature prepareSignSignature(InputStream privateKeyInputStream) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IOUtils.copy(privateKeyInputStream, baos);
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(baos.toByteArray());
            KeyFactory factory = KeyFactory.getInstance("DSA");
            PrivateKey privateKey = factory.generatePrivate(privateKeySpec);
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initSign(privateKey);
            Signature signature2 = signature;
            return signature2;
        }
        catch (Throwable e) {
            throw new LicenseException(e);
        }
        finally {
            IOUtils.closeQuietly(privateKeyInputStream);
        }
    }
}

