/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VmVersion {
    private static final Pattern JVM_VERSION_PATTERN = Pattern.compile("^(\\p{Digit})\\.(\\p{Digit})\\.(\\p{Digit})(?:.(.+))?$");
    static final Pattern IBM_SERVICE_RELEASE_PATTERN = Pattern.compile("^[^-]+-\\p{Digit}{8}[^\\p{Space}]*\\p{Space}*.*$");
    private final String vmVersion;
    private final int mega;
    private final int major;
    private final int minor;
    private final String patch;
    private final boolean isIBM;
    private final boolean isJRockit;
    private final boolean isAzul;
    private final boolean isHotSpot;

    public VmVersion(Properties props) {
        this(VmVersion.javaVersion(props), VmVersion.runtimeVersion(props), VmVersion.isHotspot(props), VmVersion.isJRockit(props), VmVersion.isIBM(props), VmVersion.isAzul(props));
    }

    private VmVersion(String vendorVersion, String runtimeVersion, boolean isSun, boolean isJRockit, boolean isIBM, boolean isAzul) {
        this.isHotSpot = isSun;
        this.isIBM = isIBM;
        this.isJRockit = isJRockit;
        this.isAzul = isAzul;
        Matcher versionMatcher = JVM_VERSION_PATTERN.matcher(vendorVersion);
        if (versionMatcher.matches()) {
            String version_patch;
            this.mega = Integer.parseInt(versionMatcher.group(1));
            this.major = Integer.parseInt(versionMatcher.group(2));
            this.minor = Integer.parseInt(versionMatcher.group(3));
            String string = version_patch = versionMatcher.groupCount() == 4 ? versionMatcher.group(4) : null;
            if (isIBM) {
                Matcher serviceReleaseMatcher = IBM_SERVICE_RELEASE_PATTERN.matcher(runtimeVersion);
                if (serviceReleaseMatcher.matches()) {
                    String serviceRelease;
                    String string2 = serviceRelease = serviceReleaseMatcher.groupCount() == 1 ? serviceReleaseMatcher.group(1).toLowerCase() : null;
                    this.patch = null == version_patch && null == serviceRelease ? null : (null == version_patch ? serviceRelease : (null == serviceRelease ? version_patch : version_patch + serviceRelease));
                } else {
                    this.patch = version_patch;
                }
            } else {
                this.patch = version_patch;
            }
        } else {
            throw new RuntimeException("Unknown version: " + vendorVersion);
        }
        this.vmVersion = this.mega + "." + this.major + "." + this.minor + (null == this.patch ? "" : "_" + this.patch);
    }

    public int getMegaVersion() {
        return this.mega;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public String getPatchLevel() {
        return this.patch;
    }

    public boolean isJDK14() {
        return this.mega == 1 && this.major == 4;
    }

    public boolean isJDK15() {
        return this.mega == 1 && this.major == 5;
    }

    public boolean isJDK16() {
        return this.mega == 1 && this.major == 6;
    }

    public boolean isJDK17() {
        return this.mega == 1 && this.major == 7;
    }

    public boolean isHotSpot() {
        return this.isHotSpot;
    }

    public boolean isIBM() {
        return this.isIBM;
    }

    public boolean isAzul() {
        return this.isAzul;
    }

    public boolean isJRockit() {
        return this.isJRockit;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VmVersion)) {
            return false;
        }
        VmVersion other = (VmVersion)o;
        return this.vmVersion.equals(other.vmVersion);
    }

    public int hashCode() {
        return this.vmVersion.hashCode();
    }

    public String toString() {
        return this.vmVersion;
    }

    private static String javaVersion(Properties props) {
        return props.getProperty("java.version", "<error: java.version not specified in properties>");
    }

    private static String runtimeVersion(Properties props) {
        if (VmVersion.thisVMisIBM()) {
            return VmVersion.getIBMRuntimeVersion();
        }
        return props.getProperty("java.runtime.version", "<error: java.runtime.version not specified in properties>");
    }

    static boolean thisVMisIBM() {
        return VmVersion.isIBM(System.getProperties());
    }

    private static String getIBMRuntimeVersion() {
        Properties props = new Properties();
        try {
            InputStream is = Class.class.getResourceAsStream("/javasdkversion.properties");
            if (is != null) {
                props.load(is);
                String version = props.getProperty("sdk.version");
                if (version != null) {
                    return version;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            Class<?> c = Class.forName("com.ibm.misc.JavaRuntimeVersion");
            Method m = c.getDeclaredMethod("getValue", new Class[0]);
            m.setAccessible(true);
            return (String)m.invoke(c, new Object[0]);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static boolean isAzul(Properties props) {
        return props.getProperty("java.vendor", "").toLowerCase().contains("azul");
    }

    private static boolean isIBM(Properties props) {
        return props.getProperty("java.vm.name", "").toLowerCase().contains("ibm");
    }

    private static boolean isJRockit(Properties props) {
        return props.getProperty("jrockit.version") != null || props.getProperty("java.vm.name", "").toLowerCase().indexOf("jrockit") >= 0;
    }

    private static boolean isHotspot(Properties props) {
        return props.getProperty("java.vm.name", "").toLowerCase().contains("hotspot") || props.getProperty("java.vm.name", "").toLowerCase().contains("openjdk");
    }
}

