/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import com.terracottatech.offheapstore.filesystem.FileSystem;
import com.terracottatech.offheapstore.filesystem.impl.OffheapFileSystem;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.search.AbstractNVPair;
import com.terracottatech.search.AggregatorOperations;
import com.terracottatech.search.Configuration;
import com.terracottatech.search.GroupedIndexQueryResultImpl;
import com.terracottatech.search.GroupedQueryResult;
import com.terracottatech.search.IndexException;
import com.terracottatech.search.IndexFile;
import com.terracottatech.search.IndexFileImpl;
import com.terracottatech.search.IndexOwner;
import com.terracottatech.search.IndexQueryResult;
import com.terracottatech.search.Logger;
import com.terracottatech.search.LoggerFactory;
import com.terracottatech.search.LuceneIndex;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.NonGroupedIndexQueryResultImpl;
import com.terracottatech.search.NonGroupedQueryResult;
import com.terracottatech.search.ProcessingContext;
import com.terracottatech.search.QueryResultComparator;
import com.terracottatech.search.ResultTools;
import com.terracottatech.search.SearchResult;
import com.terracottatech.search.SyncSnapshot;
import com.terracottatech.search.Util;
import com.terracottatech.search.ValueID;
import com.terracottatech.search.ValueType;
import com.terracottatech.search.aggregator.AbstractAggregator;
import com.terracottatech.search.aggregator.Aggregator;
import com.terracottatech.search.aggregator.Count;
import com.terracottatech.search.store.OffHeapDirectory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.terracotta.shaded.lucene.store.Directory;
import org.terracotta.shaded.lucene.store.FSDirectory;
import org.terracotta.shaded.lucene.store.IOContext;
import org.terracotta.shaded.lucene.store.IndexOutput;
import org.terracotta.shaded.lucene.store.RAMDirectory;
import org.terracotta.shaded.lucene.util.Constants;

public class LuceneIndexManager {
    private final Logger logger;
    private final AtomicBoolean init = new AtomicBoolean();
    private final ConcurrentMap<String, IndexGroup> idxGroups = new ConcurrentHashMap<String, IndexGroup>();
    private final ConcurrentMap<String, Directory> tempDirs = new ConcurrentHashMap<String, Directory>();
    private final ConcurrentMap<Directory, IndexOutput> tempRamOutput = new ConcurrentHashMap<Directory, IndexOutput>();
    private final File indexDir;
    private final boolean ramdir;
    private final boolean offHeapdir;
    private final boolean useCommitThread;
    private final LoggerFactory loggerFactory;
    private final Configuration cfg;
    private final int perCacheIdxCt;
    private final ExecutorService queryThreadPool;
    private final FileSystem offHeapFileSystem;
    private boolean shutdown;
    static final String TERRACOTTA_CACHE_NAME_FILE = "__terracotta_cache_name.txt";
    static final String TERRACOTTA_SCHEMA_FILE = "__terracotta_schema.properties";
    private static final String COUNT_AGG_NAME = "__TC_AGG_COUNT" + LuceneIndexManager.class.hashCode();

    public LuceneIndexManager(File indexDir, boolean isPermStore, LoggerFactory loggerFactory, Configuration cfg) {
        this(indexDir, isPermStore, loggerFactory, cfg, null);
    }

    public LuceneIndexManager(File indexDir, boolean isPermStore, LoggerFactory loggerFactory, Configuration cfg, PageSource pageSource) {
        this.loggerFactory = loggerFactory;
        this.cfg = cfg;
        this.logger = loggerFactory.getLogger(LuceneIndexManager.class);
        this.perCacheIdxCt = cfg.indexesPerCache();
        this.logger.info("Lucene version: " + Constants.LUCENE_MAIN_VERSION);
        this.queryThreadPool = LuceneIndexManager.createQueryThreadPool(cfg.maxConcurrentQueries(), cfg.indexesPerCache());
        this.indexDir = indexDir;
        boolean useRamdir = cfg.useRamDir();
        boolean useOffHeapdir = cfg.useOffHeap();
        if (useRamdir && useOffHeapdir) {
            throw new AssertionError((Object)"Can't have both Ram Directory and OffHeap Directory enabled !");
        }
        if (isPermStore && (useRamdir || useOffHeapdir)) {
            this.logger.warn("Server persistence is configured for permanent store mode - ignoring ram directory setting.");
        }
        this.ramdir = !isPermStore && useRamdir;
        boolean bl = this.offHeapdir = !isPermStore && useOffHeapdir;
        if (this.ramdir) {
            this.logger.warn("Using on-heap ram directory for search indices. Heap usage is unbounded");
        }
        this.useCommitThread = cfg.useCommitThread();
        if (this.offHeapdir) {
            this.logger.info("Using off-heap directory for search indices ");
            this.offHeapFileSystem = new OffheapFileSystem(pageSource, cfg.getOffHeapFileBlockSize(), cfg.getOffHeapFileMaxPageSize(), cfg.getOffHeapFileSegmentCount());
        } else {
            this.offHeapFileSystem = null;
        }
    }

    private static ExecutorService createQueryThreadPool(int maxConcurrentQueries, int indexesPerCahce) {
        return Executors.newFixedThreadPool(maxConcurrentQueries * indexesPerCahce, new ThreadFactory(){
            private final AtomicInteger ct = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread worker = new Thread(r, "SearchQueryWorker-" + this.ct.incrementAndGet());
                worker.setDaemon(true);
                return worker;
            }
        });
    }

    public void init() throws IOException {
        if (this.init.compareAndSet(false, true)) {
            Util.ensureDirectory(this.indexDir);
            this.logger.info("Initializing lucene index directory at " + this.indexDir.getAbsolutePath() + " offheap : " + this.offHeapdir + " ram : " + this.ramdir + " index/cache ratio : " + this.perCacheIdxCt);
            ArrayList<File> incomplete = new ArrayList<File>();
            FileFilter dirsOnly = new FileFilter(){

                @Override
                public boolean accept(File path) {
                    return path.isDirectory();
                }
            };
            for (File dir : this.indexDir.listFiles(dirsOnly)) {
                try {
                    boolean isCleanGroup = true;
                    File schemaFile = new File(dir, TERRACOTTA_SCHEMA_FILE);
                    File[] subDirs = dir.listFiles(dirsOnly);
                    if (!schemaFile.canRead() || subDirs.length != this.perCacheIdxCt) {
                        incomplete.add(dir);
                        isCleanGroup = false;
                    } else {
                        for (File subDir : subDirs) {
                            if (LuceneIndex.hasInitFile(subDir)) continue;
                            incomplete.add(dir);
                            isCleanGroup = false;
                            break;
                        }
                    }
                    if (!isCleanGroup) continue;
                    this.getOrCreateGroup(LuceneIndexManager.loadName(dir), null, true);
                }
                catch (IndexException e) {
                    IOException ioe = new IOException(e);
                    throw ioe;
                }
            }
            for (File dir : incomplete) {
                this.logger.warn("Removing incomplete index directory: " + dir.getAbsolutePath());
                Util.deleteDirectory(dir);
            }
            if (!this.tempDirs.isEmpty()) {
                throw new AssertionError((Object)("Not all temp ram/offheap dirs consumed: " + this.tempDirs));
            }
            if (!this.tempRamOutput.isEmpty()) {
                throw new AssertionError((Object)("Not all ram/offheap output closed: " + this.tempRamOutput));
            }
        }
    }

    public void optimizeSearchIndex(String indexName) {
        IndexGroup indexes = this.getGroup(indexName);
        if (indexes == null) {
            this.logger.warn("Ignoring request to optimize non-existent indexes [" + indexName + "]");
            return;
        }
        indexes.optimize();
    }

    public String[] getSearchIndexNames() {
        return this.indexDir.isDirectory() ? this.indexDir.list() : new String[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyGroup(String indexName) {
        IndexGroup group;
        ConcurrentMap<String, IndexGroup> concurrentMap = this.idxGroups;
        synchronized (concurrentMap) {
            group = (IndexGroup)this.idxGroups.remove(indexName);
        }
        if (group == null) {
            return;
        }
        this.logger.info("Destroying existing search index for " + indexName);
        group.close();
        try {
            Util.deleteDirectory(group.getPath());
        }
        catch (IOException e) {
            this.logger.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexGroup getOrCreateGroup(String name, List<NVPair> attrs, boolean load) throws IndexException {
        IndexGroup group = this.getGroup(name);
        if (group == null) {
            ConcurrentMap<String, IndexGroup> concurrentMap = this.idxGroups;
            synchronized (concurrentMap) {
                IndexGroup prev;
                group = this.getGroup(name);
                if (group == null && (prev = this.idxGroups.put(name, group = new IndexGroup(name, load))) != null) {
                    throw new AssertionError((Object)("replaced group for " + name));
                }
            }
            group.storeName();
            IndexGroup indexGroup = group;
            synchronized (indexGroup) {
                Map<String, AttributeProperties> idxSchema;
                if (attrs == null) {
                    idxSchema = group.loadSchema();
                } else {
                    idxSchema = LuceneIndexManager.extractSchema(attrs);
                    group.storeSchema(idxSchema);
                }
                group.schema.putAll(idxSchema);
            }
        }
        return group;
    }

    private IndexGroup getGroup(String name) {
        return (IndexGroup)this.idxGroups.get(name);
    }

    public SearchResult searchIndex(String name, List queryStack, boolean includeKeys, boolean includeValues, Set<String> attributeSet, Set<String> groupByAttributes, List<NVPair> sortAttributes, List<NVPair> aggregators, int maxResults) throws IndexException {
        IndexGroup indexes = this.getGroup(name);
        if (indexes == null) {
            return SearchResult.NULL_RESULT;
        }
        return indexes.searchIndex(queryStack, includeKeys, includeValues, attributeSet, groupByAttributes, sortAttributes, aggregators, maxResults);
    }

    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.queryThreadPool.shutdown();
        this.shutdown = true;
        for (IndexGroup group : this.idxGroups.values()) {
            group.close();
        }
        this.idxGroups.clear();
    }

    private Directory directoryFor(String name, String idxId, File path) throws IOException {
        String dirName = LuceneIndexManager.getDirName(name, idxId);
        if (this.ramdir || this.offHeapdir) {
            Directory dir = (Directory)this.tempDirs.remove(dirName);
            if (dir == null) {
                throw new AssertionError((Object)("missing ramdir/offheap dir for " + dirName + ": " + this.tempDirs));
            }
            return dir;
        }
        return FSDirectory.open(path);
    }

    private Directory createDirectoryFor(File path, String name) throws IOException {
        if (this.ramdir) {
            return new RAMDirectory();
        }
        if (this.offHeapdir) {
            Random random = new Random();
            return new OffHeapDirectory(this.offHeapFileSystem, String.valueOf(random.nextInt()));
        }
        return FSDirectory.open(path);
    }

    public void remove(String indexName, String key, long segmentId, ProcessingContext context) throws IndexException {
        IndexGroup group = this.getGroup(indexName);
        if (group != null) {
            group.remove(key, segmentId, context);
        } else {
            this.logger.info("Remove ignored: no such index group [" + indexName + "] exists");
            context.processed();
        }
    }

    public void replace(String indexName, String key, ValueID value, ValueID previousValue, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentId, ProcessingContext context) throws IndexException {
        IndexGroup group = this.getGroup(indexName);
        if (group != null) {
            group.replaceIfPresent(key, value, previousValue, attributes, storeOnlyAttributes, segmentId, context);
        } else {
            this.logger.info("Replace ignored: no such index group [" + indexName + "] exists");
            context.processed();
        }
    }

    public void removeIfValueEqual(String indexName, Map<String, ValueID> toRemove, long segmentId, ProcessingContext context, boolean fromEviction) throws IndexException {
        IndexGroup group = this.getGroup(indexName);
        if (group != null) {
            group.removeIfValueEqual(toRemove, segmentId, context);
        } else {
            if (!fromEviction) {
                this.logger.info("RemoveIfValueEqual ignored: no such index group [" + indexName + "] exists");
            }
            context.processed();
        }
    }

    public void update(String indexName, String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentId, ProcessingContext context) throws IndexException {
        IndexGroup group = this.getOrCreateGroup(indexName, attributes, false);
        group.update(key, value, attributes, storeOnlyAttributes, segmentId, context);
    }

    public void insert(String indexName, String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentId, ProcessingContext context) throws IndexException {
        IndexGroup group = this.getOrCreateGroup(indexName, attributes, false);
        group.insert(key, value, attributes, storeOnlyAttributes, segmentId, context);
    }

    public void putIfAbsent(String indexName, String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentId, ProcessingContext context) throws IndexException {
        IndexGroup group = this.getOrCreateGroup(indexName, attributes, false);
        group.putIfAbsent(key, value, attributes, storeOnlyAttributes, segmentId, context);
    }

    public void destroy(String indexName) {
        this.destroyGroup(indexName);
    }

    public void clear(String indexName, long segmentId, ProcessingContext context) throws IndexException {
        IndexGroup group = this.getGroup(indexName);
        if (group != null) {
            group.clear(segmentId, context);
        } else {
            this.logger.info("Clear ignored: no such index group [" + indexName + "] exists");
            context.processed();
        }
    }

    private static Map<String, AttributeProperties> extractSchema(List<NVPair> attributes) throws IndexException {
        HashMap<String, AttributeProperties> schema = new HashMap<String, AttributeProperties>();
        for (NVPair attr : attributes) {
            AttributeProperties prev = schema.put(attr.getName(), new AttributeProperties(attr.getType(), true));
            if (prev == null || attr.getType() == prev.getType()) continue;
            throw new IndexException("Differing types for repeated attribute: " + attr.getName());
        }
        return schema;
    }

    public SyncSnapshot snapshot(final String id) throws IndexException {
        final Map<String, List<IndexFile>> filesToSync = this.getFilesToSync(id);
        return new SyncSnapshot(){

            @Override
            public void release() {
                for (String name : filesToSync.keySet()) {
                    LuceneIndexManager.this.release(id, name);
                }
            }

            @Override
            public Map<String, List<IndexFile>> getFilesToSync() {
                return filesToSync;
            }
        };
    }

    public InputStream getIndexFile(String cacheName, String indexId, String fileName) throws IOException {
        IndexGroup group = this.getGroup(cacheName);
        if (group == null) {
            throw new AssertionError((Object)("missing index group for " + cacheName));
        }
        return group.getIndexFile(indexId, fileName);
    }

    private void release(String syncId, String name) {
        IndexGroup group = this.getGroup(name);
        if (group != null) {
            group.release(syncId);
        } else {
            this.logger.error("No such index group [" + name + "] exists to release");
        }
    }

    private Map<String, List<IndexFile>> getFilesToSync(String syncId) throws IndexException {
        HashMap<String, List<IndexFile>> filesSyncMap = new HashMap<String, List<IndexFile>>();
        for (Map.Entry entry : this.idxGroups.entrySet()) {
            String cacheName = (String)entry.getKey();
            List idxFiles = ((IndexGroup)entry.getValue()).getSyncFiles(syncId);
            if (idxFiles == null) continue;
            filesSyncMap.put(cacheName, idxFiles);
        }
        return filesSyncMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyIndexSync(String cacheName, String indexId, String fileName, byte[] fileData, boolean isTCFile, boolean isLast) throws IOException {
        if (!this.ramdir && !this.offHeapdir || isTCFile) {
            File cacheIndexDir = new File(this.indexDir, Util.sanitizeCacheName(cacheName));
            if (indexId != null) {
                cacheIndexDir = new File(cacheIndexDir, indexId);
            }
            Util.ensureDirectory(cacheIndexDir);
            File syncFile = new File(cacheIndexDir, fileName);
            syncFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(syncFile, true);
            try {
                fos.write(fileData);
                fos.flush();
            }
            finally {
                fos.close();
            }
        }
        if ((this.ramdir || this.offHeapdir) && !isTCFile) {
            Directory dir = this.getOrCreateTempRamDirectory(cacheName, indexId);
            IndexOutput output = (IndexOutput)this.tempRamOutput.get(dir);
            if (output == null) {
                output = dir.createOutput(fileName, IOContext.DEFAULT);
                this.tempRamOutput.put(dir, output);
            }
            output.writeBytes(fileData, fileData.length);
            if (isLast) {
                output.close();
                this.tempRamOutput.remove(dir);
            }
        }
    }

    private static String getDirName(String cacheName, String idxId) {
        return cacheName + File.separator + idxId;
    }

    private synchronized Directory getOrCreateTempRamDirectory(String cacheName, String idxId) throws IOException {
        String indexName = LuceneIndexManager.getDirName(cacheName, idxId);
        Directory memoryDir = (Directory)this.tempDirs.get(indexName);
        if (memoryDir != null) {
            return memoryDir;
        }
        if (this.ramdir) {
            memoryDir = new RAMDirectory();
        } else if (this.offHeapdir) {
            Random random = new Random();
            memoryDir = new OffHeapDirectory(this.offHeapFileSystem, String.valueOf(random.nextInt()));
        } else {
            throw new AssertionError((Object)"Shouldnt get here");
        }
        Directory existing = this.tempDirs.put(indexName, memoryDir);
        if (existing != null) {
            throw new AssertionError((Object)("Directory for " + indexName + " already exists"));
        }
        return memoryDir;
    }

    private static String loadName(File path) throws IndexException {
        FileInputStream in = null;
        try {
            int read;
            in = new FileInputStream(new File(path, TERRACOTTA_CACHE_NAME_FILE));
            StringBuilder sb = new StringBuilder();
            byte[] buf = new byte[2];
            while ((read = in.read(buf)) != -1) {
                if (read != 2) {
                    throw new IOException("read " + read + " bytes");
                }
                char c = (char)(buf[0] << 8 | buf[1] & 0xFF);
                sb.append(c);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ioe) {
            throw new IndexException(ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    static class AttributeProperties {
        private final ValueType type;
        private final boolean indexed;

        AttributeProperties(ValueType type, boolean indexed) {
            this.type = type;
            this.indexed = indexed;
        }

        ValueType getType() {
            return this.type;
        }

        boolean isIndexed() {
            return this.indexed;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.type.name() + ",indexed=" + this.indexed + ")";
        }
    }

    final class IndexGroup
    implements IndexOwner {
        private final ConcurrentMap<Integer, LuceneIndex> indices;
        private final String groupName;
        private final ConcurrentMap<String, AttributeProperties> schema;
        private final Map<String, File> schemaSnapshots;
        private final Timer searcherRefreshTimer;

        private IndexGroup(String name, boolean load) throws IndexException {
            this.indices = new ConcurrentHashMap<Integer, LuceneIndex>(LuceneIndexManager.this.perCacheIdxCt);
            this.schema = new ConcurrentHashMap<String, AttributeProperties>();
            this.schemaSnapshots = new HashMap<String, File>();
            this.groupName = name;
            this.schema.put("__TC_KEY_FIELD", new AttributeProperties(ValueType.STRING, true));
            this.schema.put("__TC_VALUE_FIELD", new AttributeProperties(ValueType.LONG, true));
            this.schema.put("__TC_SEGMENT_ID", new AttributeProperties(ValueType.LONG, true));
            this.searcherRefreshTimer = new Timer(this.groupName + "-searcherRefreshTask", true);
            try {
                Util.ensureDirectory(this.getPath());
                this.createIndices(load);
            }
            catch (IOException x) {
                throw new IndexException(x);
            }
        }

        private void close() {
            this.searcherRefreshTimer.cancel();
            for (LuceneIndex index : this.indices.values()) {
                index.close();
            }
        }

        private LuceneIndex getIndex(long segmentId) {
            return (LuceneIndex)this.indices.get(this.getIndexId(segmentId));
        }

        private int getIndexId(long segmentId) {
            return (int)(Math.abs(segmentId) % (long)LuceneIndexManager.this.perCacheIdxCt);
        }

        private InputStream getIndexFile(String indexId, String fileName) throws IOException {
            if (indexId != null) {
                Integer idxId;
                try {
                    idxId = Integer.valueOf(indexId);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException(String.format("Illegal index id %s", indexId), e);
                }
                LuceneIndex idx = (LuceneIndex)this.indices.get(idxId);
                if (idx == null) {
                    throw new AssertionError((Object)String.format("Non-existent index id %d specified for group %s", idxId, this.groupName));
                }
                return idx.getIndexFile(fileName);
            }
            return new BufferedInputStream(new FileInputStream(new File(this.getPath(), fileName)));
        }

        private synchronized void release(String syncId) {
            boolean deleted;
            File schemaSnapshot = this.schemaSnapshots.remove(syncId);
            if (schemaSnapshot != null && schemaSnapshot.exists() && !(deleted = schemaSnapshot.delete())) {
                LuceneIndexManager.this.logger.warn("failed to delete temp schema snapshot: " + schemaSnapshot.getAbsolutePath());
            }
            for (LuceneIndex index : this.indices.values()) {
                index.release(syncId);
            }
        }

        private synchronized List<IndexFile> getSyncFiles(String syncId) throws IndexException {
            ArrayList<IndexFile> files = new ArrayList<IndexFile>();
            File schemaFile = new File(this.getPath(), LuceneIndexManager.TERRACOTTA_SCHEMA_FILE);
            if (schemaFile.exists()) {
                File snapshot;
                try {
                    snapshot = File.createTempFile("tmp", LuceneIndexManager.TERRACOTTA_SCHEMA_FILE, this.getPath());
                    this.schemaSnapshots.put(syncId, snapshot);
                    Util.copyFile(schemaFile, snapshot);
                }
                catch (IOException e) {
                    throw new IndexException(e);
                }
                files.add(new IndexFileImpl(LuceneIndexManager.TERRACOTTA_SCHEMA_FILE, snapshot.getName(), null, true, snapshot.length()));
            } else {
                LuceneIndexManager.this.logger.info("Schema file doesn't exist: " + schemaFile);
            }
            files.add(new IndexFileImpl(LuceneIndexManager.TERRACOTTA_CACHE_NAME_FILE, LuceneIndexManager.TERRACOTTA_CACHE_NAME_FILE, null, true, new File(this.getPath(), LuceneIndexManager.TERRACOTTA_CACHE_NAME_FILE).length()));
            for (LuceneIndex idx : this.indices.values()) {
                List<IndexFile> idxFiles = idx.getSnapshot(syncId);
                if (idxFiles == null) continue;
                files.addAll(idxFiles);
            }
            return files;
        }

        private void optimize() {
            for (LuceneIndex index : this.indices.values()) {
                try {
                    index.optimize();
                }
                catch (Exception e) {
                    LuceneIndexManager.this.logger.error("Error optimizing index [" + this.groupName + "/" + index.getName() + "]", e);
                }
            }
        }

        private void replaceIfPresent(String key, ValueID value, ValueID previousValue, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentId, ProcessingContext context) throws IndexException {
            LuceneIndex index = this.getIndex(segmentId);
            if (index == null) {
                throw new IndexException("Unable to run replaceIfPresent: segment " + segmentId + " has no index in group " + this.groupName);
            }
            index.replaceIfPresent(key, value, previousValue, attributes, storeOnlyAttributes, segmentId, context);
        }

        private void removeIfValueEqual(Map<String, ValueID> toRemove, long segmentId, ProcessingContext context) throws IndexException {
            LuceneIndex index = this.getIndex(segmentId);
            if (index == null) {
                throw new IndexException("Unable to run removeIfValueEqual: segment " + segmentId + " has no index in group " + this.groupName);
            }
            index.removeIfValueEqual(toRemove, context);
        }

        private void remove(String key, long segmentId, ProcessingContext context) throws IndexException {
            LuceneIndex index = this.getIndex(segmentId);
            if (index == null) {
                throw new IndexException("Unable to run remove: segment " + segmentId + " has no index in group " + this.groupName);
            }
            index.remove(key, context);
        }

        private void clear(long segmentId, ProcessingContext context) throws IndexException {
            LuceneIndex index = this.getIndex(segmentId);
            if (index == null) {
                throw new IndexException("Unable to run clear: segment " + segmentId + " has no index in group " + this.groupName);
            }
            index.clear(segmentId, context);
        }

        private void update(String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentId, ProcessingContext context) throws IndexException {
            LuceneIndex index = this.getIndex(segmentId);
            if (index == null) {
                throw new IndexException("Unable to run update: segment " + segmentId + " has no index in group " + this.groupName);
            }
            index.update(key, value, attributes, storeOnlyAttributes, segmentId, context);
        }

        private void insert(String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentId, ProcessingContext context) throws IndexException {
            LuceneIndex index = this.getIndex(segmentId);
            if (index == null) {
                throw new IndexException("Unable to run insert: segment " + segmentId + " has no index in group " + this.groupName);
            }
            index.insert(key, value, attributes, storeOnlyAttributes, segmentId, context);
        }

        private void putIfAbsent(String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentId, ProcessingContext context) throws IndexException {
            LuceneIndex index = this.getIndex(segmentId);
            if (index == null) {
                throw new IndexException("Unable to run putIfAbsent: segment " + segmentId + " has no index in group " + this.groupName);
            }
            index.putIfAbsent(key, value, attributes, storeOnlyAttributes, segmentId, context);
        }

        private Map<String, List<Aggregator>> createAggregators(List<NVPair> requestedAggregators) {
            if (requestedAggregators.isEmpty()) {
                return Collections.EMPTY_MAP;
            }
            HashMap<String, List<Aggregator>> rv = new HashMap<String, List<Aggregator>>();
            NVPair count = null;
            for (NVPair aggregator : requestedAggregators) {
                String attrName = aggregator.getName();
                if (AggregatorOperations.COUNT.equals(aggregator.getObjectValue())) {
                    count = aggregator;
                    continue;
                }
                ArrayList<Aggregator> attrAggregators = (ArrayList<Aggregator>)rv.get(attrName);
                if (attrAggregators == null) {
                    attrAggregators = new ArrayList<Aggregator>();
                    rv.put(attrName, attrAggregators);
                }
                attrAggregators.add(this.createAggregator(aggregator));
            }
            if (count != null) {
                rv.put(COUNT_AGG_NAME, Collections.singletonList(this.createAggregator(count)));
            }
            return rv;
        }

        private Aggregator createAggregator(NVPair aggregator) {
            AbstractNVPair.EnumNVPair enumPair = (AbstractNVPair.EnumNVPair)aggregator;
            String attributeName = enumPair.getName();
            AttributeProperties attrProps = (AttributeProperties)this.schema.get(attributeName);
            ValueType type = attrProps != null ? attrProps.getType() : null;
            AggregatorOperations aggregatorType = AggregatorOperations.values()[enumPair.getOrdinal()];
            return AbstractAggregator.aggregator(aggregatorType, attributeName, type);
        }

        private SearchResult searchIndex(final List queryStack, final boolean includeKeys, final boolean includeValues, Set<String> attributeSet, final Set<String> groupByAttributes, final List<NVPair> sortAttributes, List<NVPair> aggPairs, final int maxResults) throws IndexException {
            Map<String, List<Aggregator>> aggregators;
            SearchResult mergeResult = new SearchResult(new ArrayList(), new ArrayList<Aggregator>(), false);
            boolean isGroupBy = !groupByAttributes.isEmpty();
            ArrayList<1> searchTasks = new ArrayList<1>();
            try {
                aggregators = this.createAggregators(aggPairs);
            }
            catch (IllegalArgumentException e) {
                throw new IndexException(e);
            }
            final boolean includeCount = aggregators.containsKey(COUNT_AGG_NAME);
            final HashSet<String> attrs = new HashSet<String>();
            attrs.addAll(attributeSet);
            for (String agg : aggregators.keySet()) {
                if (includeCount && COUNT_AGG_NAME.equals(agg)) continue;
                attrs.add(agg);
            }
            for (final LuceneIndex idx : this.indices.values()) {
                searchTasks.add(new Callable<SearchResult>(){

                    @Override
                    public SearchResult call() throws Exception {
                        return idx.search(queryStack, includeKeys, includeValues, attrs, groupByAttributes, sortAttributes, maxResults, includeCount);
                    }
                });
            }
            boolean unOrdered = sortAttributes == null || sortAttributes.isEmpty();
            List<Object> allQueryResults = new ArrayList();
            try {
                boolean isAny = mergeResult.isAnyCriteriaMatch();
                for (Future future : LuceneIndexManager.this.queryThreadPool.invokeAll(searchTasks)) {
                    SearchResult curRes = (SearchResult)future.get();
                    isAny |= curRes.isAnyCriteriaMatch();
                    if (unOrdered && !isGroupBy) {
                        List qRes = mergeResult.getQueryResults();
                        if (maxResults >= 0) {
                            Iterator iter = curRes.getQueryResults().iterator();
                            while (iter.hasNext() && qRes.size() < maxResults) {
                                qRes.add(iter.next());
                            }
                            if (qRes.size() == maxResults) {
                                break;
                            }
                        } else {
                            qRes.addAll(curRes.getQueryResults());
                        }
                        mergeResult = new SearchResult(mergeResult.getQueryResults(), mergeResult.getAggregators(), isAny);
                        continue;
                    }
                    allQueryResults.addAll(curRes.getQueryResults());
                }
            }
            catch (Throwable t) {
                if (t instanceof ExecutionException) {
                    t = t.getCause();
                }
                LuceneIndexManager.this.logger.error(String.format("Search executor for index group %s threw exception: ", this.groupName), t);
                if (t instanceof IndexException) {
                    throw (IndexException)t;
                }
                throw new IndexException(t);
            }
            if (!unOrdered || isGroupBy) {
                if (isGroupBy) {
                    allQueryResults = this.mergeGroups(allQueryResults, sortAttributes, aggregators, attributeSet);
                    mergeResult = new SearchResult(mergeResult.getQueryResults(), mergeResult.getAggregators(), !allQueryResults.isEmpty());
                } else {
                    Collections.sort(allQueryResults, new QueryResultComparator(sortAttributes));
                    if (maxResults >= 0 && allQueryResults.size() > maxResults) {
                        ArrayList<Object> trimmed = new ArrayList<Object>(allQueryResults.subList(0, maxResults));
                        allQueryResults = trimmed;
                    }
                }
                mergeResult.getQueryResults().addAll(allQueryResults);
            }
            if (!isGroupBy) {
                allQueryResults = mergeResult.getQueryResults();
                Count count = null;
                if (includeCount) {
                    List<Aggregator> countAggs = aggregators.remove(COUNT_AGG_NAME);
                    if (countAggs.isEmpty()) {
                        throw new AssertionError((Object)"Count aggregators: expected non-empty singleton list");
                    }
                    count = (Count)countAggs.iterator().next();
                    count.increment(allQueryResults.size());
                    if (!includeKeys && !includeValues && attrs.isEmpty()) {
                        allQueryResults.clear();
                    }
                }
                if (!aggregators.isEmpty()) {
                    ListIterator<Object> rowItr = allQueryResults.listIterator();
                    while (rowItr.hasNext()) {
                        NonGroupedQueryResult nonGroupedQueryResult = (NonGroupedQueryResult)rowItr.next();
                        ArrayList<NVPair> rowAttrs = new ArrayList<NVPair>(nonGroupedQueryResult.getAttributes());
                        Iterator itr = rowAttrs.iterator();
                        while (itr.hasNext()) {
                            NVPair attr = (NVPair)itr.next();
                            Collection attrAggs = aggregators.get(attr.getName());
                            if (attrAggs == null) continue;
                            if (!attributeSet.contains(attr.getName()) && maxResults < 0) {
                                itr.remove();
                                if (rowAttrs.isEmpty() && !includeKeys && !includeValues) {
                                    rowItr.remove();
                                } else {
                                    rowItr.set(new NonGroupedIndexQueryResultImpl(nonGroupedQueryResult.getKey(), nonGroupedQueryResult.getValue(), rowAttrs, nonGroupedQueryResult.getSortAttributes()));
                                }
                            }
                            for (Aggregator agg : attrAggs) {
                                try {
                                    agg.accept(ValueType.ENUM == attr.getType() ? AbstractNVPair.enumStorageString((AbstractNVPair.EnumNVPair)attr) : attr.getObjectValue());
                                }
                                catch (IllegalArgumentException e) {
                                    throw new IndexException(e);
                                }
                            }
                        }
                    }
                }
                if (count != null) {
                    mergeResult.getAggregators().add(count);
                }
                for (List list : aggregators.values()) {
                    mergeResult.getAggregators().addAll(list);
                }
            }
            if (!aggPairs.isEmpty()) {
                this.reorderAggregators(aggPairs, isGroupBy, mergeResult);
            }
            return mergeResult;
        }

        private void reorderAggregators(List<NVPair> requestedAggs, boolean isGroupBy, SearchResult<? extends IndexQueryResult> result) {
            HashMap<Set<String>, Integer> aggPositions = new HashMap<Set<String>, Integer>();
            int n = 0;
            int ctCt = 0;
            for (NVPair nVPair : requestedAggs) {
                Integer prev;
                HashSet<String> key = new HashSet<String>(2);
                String name = nVPair.getName();
                if (AggregatorOperations.COUNT.equals(nVPair.getObjectValue())) {
                    name = COUNT_AGG_NAME + ctCt++;
                }
                key.add(name);
                key.add(nVPair.getObjectValue().toString());
                if ((prev = aggPositions.put(key, n++)) != null) {
                    throw new AssertionError((Object)String.format("Previous index mapping found for %s: %d", key, prev));
                }
            }
            if (!isGroupBy) {
                this.alignAggregators(aggPositions, result.getAggregators(), n, ctCt);
            } else {
                for (GroupedQueryResult groupedQueryResult : result.getQueryResults()) {
                    this.alignAggregators(aggPositions, groupedQueryResult.getAggregators(), n, ctCt);
                }
            }
        }

        private void alignAggregators(Map<Set<String>, Integer> aggIndices, List<Aggregator> target, int totalAggCount, int countOfCounts) {
            Aggregator[] dest = new Aggregator[totalAggCount];
            for (Aggregator a : target) {
                AbstractAggregator agg = (AbstractAggregator)a;
                HashSet<String> id = new HashSet<String>();
                if (AggregatorOperations.COUNT.equals((Object)agg.getOperation())) {
                    for (int i = 0; i < countOfCounts; ++i) {
                        id.add(COUNT_AGG_NAME + i);
                        id.add(agg.getOperation().toString());
                        int idx = aggIndices.get(id);
                        id.clear();
                        dest[idx] = agg;
                    }
                    continue;
                }
                id.add(agg.getAttributeName());
                id.add(agg.getOperation().toString());
                int idx = aggIndices.get(id);
                id.clear();
                dest[idx] = agg;
            }
            target.clear();
            target.addAll(Arrays.asList(dest));
        }

        private void fillInAggregators(GroupedQueryResult result, Map<String, List<Aggregator>> aggs) {
            List<Aggregator> dest = result.getAggregators();
            Collection countAggs = aggs.get(COUNT_AGG_NAME);
            if (countAggs != null) {
                if (countAggs.isEmpty()) {
                    throw new AssertionError((Object)"Count aggregator: expected non-empty singleton list");
                }
                Count count = (Count)countAggs.iterator().next();
                Count clone = new Count(count.getAttributeName(), count.getType());
                clone.accept(result);
                dest.add(clone);
            }
            for (NVPair attr : result.getAttributes()) {
                List<Aggregator> attrAggs;
                if (COUNT_AGG_NAME.equals(attr.getName()) || (attrAggs = aggs.get(attr.getName())) == null) continue;
                for (Aggregator agg : attrAggs) {
                    AbstractAggregator srcAgg = (AbstractAggregator)agg;
                    AbstractAggregator destAgg = AbstractAggregator.aggregator(srcAgg.getOperation(), srcAgg.getAttributeName(), srcAgg.getType());
                    destAgg.accept(ValueType.ENUM == attr.getType() ? AbstractNVPair.enumStorageString((AbstractNVPair.EnumNVPair)attr) : attr.getObjectValue());
                    dest.add(destAgg);
                }
            }
        }

        private List<GroupedQueryResult> mergeGroups(List<? extends IndexQueryResult> stripeResults, List<NVPair> sortAttributes, Map<String, List<Aggregator>> aggregators, Set<String> requestedAttributes) {
            HashMap<Set<NVPair>, GroupedQueryResult> uniqueGroups = new HashMap<Set<NVPair>, GroupedQueryResult>();
            for (IndexQueryResult indexQueryResult : stripeResults) {
                GroupedQueryResult group = (GroupedQueryResult)indexQueryResult;
                Set<NVPair> groupBy = group.getGroupedAttributes();
                this.fillInAggregators(group, aggregators);
                GroupedQueryResult dest = (GroupedQueryResult)uniqueGroups.get(groupBy);
                if (dest == null) {
                    uniqueGroups.put(groupBy, group);
                    continue;
                }
                ResultTools.aggregate(dest.getAggregators(), group.getAggregators());
            }
            ArrayList<GroupedQueryResult> groups = new ArrayList<GroupedQueryResult>(uniqueGroups.values());
            ListIterator<GroupedIndexQueryResultImpl> listIterator = groups.listIterator();
            while (listIterator.hasNext()) {
                GroupedQueryResult res = (GroupedQueryResult)listIterator.next();
                ArrayList<NVPair> rowAttrs = new ArrayList<NVPair>(res.getAttributes());
                Iterator itr = rowAttrs.iterator();
                while (itr.hasNext()) {
                    if (requestedAttributes.contains(((NVPair)itr.next()).getName())) continue;
                    itr.remove();
                    listIterator.set(new GroupedIndexQueryResultImpl(rowAttrs, res.getSortAttributes(), res.getGroupedAttributes(), res.getAggregators()));
                }
            }
            if (!sortAttributes.isEmpty()) {
                Collections.sort(groups, new QueryResultComparator(sortAttributes));
            }
            return groups;
        }

        private File getPath() {
            return new File(LuceneIndexManager.this.indexDir, Util.sanitizeCacheName(this.groupName));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createIndices(boolean load) throws IndexException, IOException {
            LuceneIndexManager luceneIndexManager = LuceneIndexManager.this;
            synchronized (luceneIndexManager) {
                if (LuceneIndexManager.this.shutdown) {
                    throw new IndexException("Index manager shutdown");
                }
                if (!this.indices.isEmpty()) {
                    throw new AssertionError((Object)("not empty: " + this.indices));
                }
                File groupPath = this.getPath();
                for (int idxSegment = 0; idxSegment < LuceneIndexManager.this.perCacheIdxCt; ++idxSegment) {
                    LuceneIndex luceneIndex;
                    String idxStr = String.valueOf(idxSegment);
                    File path = new File(groupPath, idxStr);
                    if (!load) {
                        LuceneIndexManager.this.logger.info(String.format("Creating search index [%s/%d]", this.groupName, idxSegment));
                        luceneIndex = new LuceneIndex(LuceneIndexManager.this.createDirectoryFor(path, this.groupName), idxStr, path, LuceneIndexManager.this.useCommitThread, this, LuceneIndexManager.this.cfg, LuceneIndexManager.this.loggerFactory);
                    } else {
                        luceneIndex = new LuceneIndex(LuceneIndexManager.this.directoryFor(this.groupName, idxStr, path), idxStr, path, LuceneIndexManager.this.useCommitThread, this, LuceneIndexManager.this.cfg, LuceneIndexManager.this.loggerFactory);
                        LuceneIndexManager.this.logger.info(String.format("Opening existing search index [%s/%d]", this.groupName, idxSegment));
                    }
                    this.indices.put(idxSegment, luceneIndex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkSchema(List<NVPair> attributes, boolean indexed) throws IndexException {
            for (NVPair nvpair : attributes) {
                ValueType type;
                String attrName = nvpair.getName();
                if (attrName.equals("__TC_KEY_FIELD") || attrName.equals("__TC_VALUE_FIELD") || attrName.equals("__TC_SEGMENT_ID")) {
                    throw new IndexException("Illegal attribute name present: " + attrName);
                }
                AttributeProperties attrProps = (AttributeProperties)this.schema.get(attrName);
                if (attrProps == null) {
                    IndexGroup indexGroup = this;
                    synchronized (indexGroup) {
                        attrProps = (AttributeProperties)this.schema.get(attrName);
                        if (attrProps == null) {
                            HashMap<String, AttributeProperties> clone = new HashMap<String, AttributeProperties>(this.schema);
                            attrProps = new AttributeProperties(nvpair.getType(), indexed);
                            AttributeProperties prev = clone.put(attrName, attrProps);
                            if (prev != null) {
                                throw new AssertionError((Object)("replaced mapping for " + attrName));
                            }
                            LuceneIndexManager.this.logger.info("Updating stored schema");
                            this.storeSchema(clone);
                            prev = this.schema.put(attrName, attrProps);
                            if (prev != null) {
                                throw new AssertionError((Object)("replaced mapping for " + attrName));
                            }
                        }
                    }
                }
                if ((type = attrProps.getType()).equals((Object)nvpair.getType())) continue;
                throw new IndexException("Attribute type (" + nvpair.getType().name() + ") does not match schema type (" + type.name() + ")");
            }
        }

        @Override
        public Map<String, AttributeProperties> getSchema() {
            return Collections.unmodifiableMap(this.schema);
        }

        @Override
        public Timer getSearcherRefreshTimer() {
            return this.searcherRefreshTimer;
        }

        private void storeSchema(Map<String, AttributeProperties> schemaToStore) throws IndexException {
            boolean deleted;
            File tmp;
            File path = this.getPath();
            try {
                tmp = File.createTempFile("tmp", LuceneIndexManager.TERRACOTTA_SCHEMA_FILE, path);
            }
            catch (IOException e) {
                throw new IndexException(e);
            }
            Properties props = new Properties();
            for (Map.Entry<String, AttributeProperties> entry : schemaToStore.entrySet()) {
                props.setProperty(entry.getKey(), entry.getValue().getType().name() + "," + entry.getValue().isIndexed());
            }
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(tmp);
                props.store(fout, null);
            }
            catch (IOException e) {
                throw new IndexException(e);
            }
            finally {
                try {
                    if (fout != null) {
                        fout.close();
                    }
                }
                catch (IOException ioe) {
                    LuceneIndexManager.this.logger.warn(ioe);
                }
            }
            File schemaFile = new File(path, LuceneIndexManager.TERRACOTTA_SCHEMA_FILE);
            if (schemaFile.exists() && !(deleted = schemaFile.delete())) {
                throw new IndexException("Cannot delete old schema file: " + schemaFile.getAbsolutePath());
            }
            boolean moved = tmp.renameTo(schemaFile);
            if (!moved) {
                throw new IndexException("Failed to rename temp file [" + tmp.getAbsolutePath() + "] to [" + schemaFile.getAbsolutePath() + "]");
            }
        }

        private Map<String, AttributeProperties> loadSchema() throws IndexException {
            File schemaFile = new File(this.getPath(), LuceneIndexManager.TERRACOTTA_SCHEMA_FILE);
            Properties data = new Properties();
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(schemaFile);
                data.load(fin);
            }
            catch (IOException ioe) {
                throw new IndexException(ioe);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException ioe) {
                        LuceneIndexManager.this.logger.warn(ioe);
                    }
                }
            }
            HashMap<String, AttributeProperties> res = new HashMap<String, AttributeProperties>();
            Enumeration<?> i = data.propertyNames();
            while (i.hasMoreElements()) {
                ValueType type;
                String key = (String)i.nextElement();
                String value = data.getProperty(key).trim();
                String[] split = value.split(",");
                if (split.length != 2) {
                    throw new IndexException("Unexpected format: " + value);
                }
                String typeName = split[0];
                try {
                    type = Enum.valueOf(ValueType.class, typeName);
                }
                catch (IllegalArgumentException iae) {
                    throw new IndexException("No such type (" + typeName + ") for key " + key);
                }
                String indexed = split[1];
                if (!"false".equals(indexed) && !"true".equals(indexed)) {
                    throw new IndexException("Unexpected format for indexed: " + indexed);
                }
                res.put(key, new AttributeProperties(type, Boolean.valueOf(indexed)));
            }
            return res;
        }

        private void storeName() throws IndexException {
            File file = new File(this.getPath(), LuceneIndexManager.TERRACOTTA_CACHE_NAME_FILE);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                for (char c : this.groupName.toCharArray()) {
                    byte b1 = (byte)(0xFF & c >> 8);
                    byte b2 = (byte)(0xFF & c);
                    out.write(b1);
                    out.write(b2);
                }
                out.flush();
            }
            catch (IOException e) {
                throw new IndexException(e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {
                        LuceneIndexManager.this.logger.error("error closing " + file, ioe);
                    }
                }
            }
        }
    }
}

