/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.pinning.concurrent;

import com.terracottatech.offheapstore.eviction.EvictionListener;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.pinning.EvictionListeningReadWriteLockedPinnableOffHeapClockCache;
import com.terracottatech.offheapstore.pinning.PinnableStorageEngine;
import com.terracottatech.offheapstore.pinning.ReadWriteLockedPinnableOffHeapClockCache;
import com.terracottatech.offheapstore.util.Factory;

public class ReadWriteLockedPinnableOffHeapClockCacheFactory<K, V>
implements Factory<ReadWriteLockedPinnableOffHeapClockCache<K, V>> {
    private static final int DEFAULT_TABLE_SIZE = 128;
    private final Factory<? extends PinnableStorageEngine<? super K, ? super V>> storageEngineFactory;
    private final PageSource tableSource;
    private final int tableSize;
    private final EvictionListener<K, V> evictionListener;

    public ReadWriteLockedPinnableOffHeapClockCacheFactory(PageSource tableSource, Factory<? extends PinnableStorageEngine<? super K, ? super V>> storageEngineFactory) {
        this(tableSource, storageEngineFactory, 128);
    }

    public ReadWriteLockedPinnableOffHeapClockCacheFactory(PageSource tableSource, Factory<? extends PinnableStorageEngine<? super K, ? super V>> storageEngineFactory, EvictionListener<K, V> evictionListener) {
        this(tableSource, storageEngineFactory, evictionListener, 128);
    }

    public ReadWriteLockedPinnableOffHeapClockCacheFactory(PageSource tableSource, Factory<? extends PinnableStorageEngine<? super K, ? super V>> storageEngineFactory, int tableSize) {
        this(tableSource, storageEngineFactory, null, tableSize);
    }

    public ReadWriteLockedPinnableOffHeapClockCacheFactory(PageSource tableSource, Factory<? extends PinnableStorageEngine<? super K, ? super V>> storageEngineFactory, EvictionListener<K, V> evictionListener, int tableSize) {
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = tableSource;
        this.tableSize = tableSize;
        this.evictionListener = evictionListener;
    }

    @Override
    public ReadWriteLockedPinnableOffHeapClockCache<K, V> newInstance() {
        PinnableStorageEngine<K, V> storageEngine = this.storageEngineFactory.newInstance();
        try {
            if (this.evictionListener == null) {
                return new ReadWriteLockedPinnableOffHeapClockCache<K, V>(this.tableSource, storageEngine, this.tableSize);
            }
            return new EvictionListeningReadWriteLockedPinnableOffHeapClockCache<K, V>(this.evictionListener, this.tableSource, storageEngine, this.tableSize);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }
}

