/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.nio.NIOConstants;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;

class NIOSegmentList
extends AbstractList<File> {
    private final List<File> segments;
    private final File directory;
    private File readHead;
    private int position;

    NIOSegmentList(File directory) throws IOException {
        this.directory = directory;
        File[] list = directory.listFiles(NIOConstants.SEGMENT_FILENAME_FILTER);
        if (list == null) {
            list = new File[]{};
        }
        this.segments = new LinkedList<File>(Arrays.asList(list));
        Collections.sort(this.segments, NIOConstants.SEGMENT_FILE_COMPARATOR);
        this.position = -1;
    }

    synchronized long getTotalSize() {
        long total = 0L;
        for (File f : this.segments) {
            total += f.length();
        }
        return total;
    }

    synchronized File appendFile() throws IOException {
        int seg = this.segments.isEmpty() ? 0 : NIOConstants.convertSegmentNumber(this.segments.get(this.segments.size() - 1)) + 1;
        StringBuilder fn = new StringBuilder();
        Formatter pfn = new Formatter(fn);
        pfn.format("seg%09d.frs", seg);
        File writeHead = new File(this.directory, fn.toString());
        this.segments.add(writeHead);
        return writeHead;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.segments.isEmpty();
    }

    synchronized void setReadPosition(long pos) {
        this.position = this.segments.isEmpty() || pos == 0L ? -1 : (pos < 0L || pos > (long)(this.segments.size() - 1) ? this.segments.size() : (int)pos);
    }

    synchronized File nextReadFile(Direction dir) throws IOException {
        this.readHead = null;
        this.position = dir == Direction.REVERSE ? --this.position : ++this.position;
        this.readHead = this.position < 0 || this.position >= this.segments.size() ? null : this.segments.get(this.position);
        return this.readHead;
    }

    synchronized long removeFilesFromTail() throws IOException {
        long size = 0L;
        for (int count = 0; count < this.position; ++count) {
            File f = this.segments.remove(0);
            size += f.length();
            if (f.delete()) continue;
            this.segments.add(0, f);
            return size -= f.length();
        }
        assert (this.segments.get(0).equals(this.readHead));
        return size;
    }

    synchronized long removeFilesFromHead() throws IOException {
        long size = 0L;
        while (this.position + 1 < this.segments.size()) {
            File f = this.segments.remove(this.segments.size() - 1);
            size += f.length();
            if (f.delete()) continue;
            this.segments.add(f);
            return size -= f.length();
        }
        assert (this.readHead == null || this.segments.get(this.position).equals(this.readHead));
        return size;
    }

    synchronized File getCurrentReadFile() {
        return this.readHead;
    }

    synchronized File getEndFile() throws IOException {
        return this.segments.get(this.segments.size() - 1);
    }

    synchronized boolean currentIsHead() throws IOException {
        if (this.readHead == null && this.segments.isEmpty()) {
            return true;
        }
        if (this.readHead != null && this.segments.isEmpty()) {
            throw new AssertionError((Object)"segment list is inconsistent");
        }
        return this.segments.get(this.segments.size() - 1).equals(this.readHead);
    }

    synchronized boolean currentIsTail() throws IOException {
        if (this.readHead == null && this.segments.isEmpty()) {
            return true;
        }
        if (this.readHead != null && this.segments.isEmpty()) {
            throw new AssertionError((Object)"segment list is inconsistent");
        }
        return this.segments.get(0).equals(this.readHead);
    }

    synchronized File getBeginningFile() throws IOException {
        return this.segments.get(0);
    }

    synchronized int getCount() {
        return this.segments.size();
    }

    @Override
    public synchronized File get(int i) {
        return this.segments.get(i);
    }

    @Override
    public synchronized int size() {
        return this.segments.size();
    }

    @Override
    public synchronized File remove(int i) {
        File f = this.segments.remove(i);
        f.delete();
        return f;
    }
}

