/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.config.Configuration;
import com.terracottatech.frs.config.FrsProperty;
import com.terracottatech.frs.io.BufferBuilder;
import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.IOManager;
import com.terracottatech.frs.io.IOStatistics;
import com.terracottatech.frs.io.nio.NIOStatistics;
import com.terracottatech.frs.io.nio.NIOStreamImpl;
import com.terracottatech.frs.util.NullFuture;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Formatter;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOManager
implements IOManager {
    private final File directory;
    private File lockFile;
    private File backupLockFile;
    private FileLock lock;
    private final long segmentSize;
    private long memorySize;
    private static final String LOCKFILE_ACTIVE = "lock file exists";
    private NIOStreamImpl backend;
    private long written = 1L;
    private long read = 1L;
    private long writeTime = 1L;
    private long parts = 1L;
    private long requests = 1L;
    private volatile boolean readOpsAllowed = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(IOManager.class);

    public NIOManager(String home, long segmentSize) throws IOException {
        this(home, segmentSize, segmentSize * 4L);
    }

    public NIOManager(String home, long segmentSize, long memorySize) throws IOException {
        this.directory = new File(home);
        this.segmentSize = segmentSize;
        this.memorySize = memorySize;
        this.open();
    }

    public NIOManager(Configuration config) throws IOException {
        this(config.getDBHome().getAbsolutePath(), config.getLong(FrsProperty.IO_NIO_SEGMENT_SIZE), config.getLong(FrsProperty.IO_NIO_MEMORY_SIZE));
        String bufferBuilder = config.getString(FrsProperty.IO_NIO_BUFFER_BUILDER);
        if (bufferBuilder != null) {
            try {
                this.backend.setBufferBuilder((BufferBuilder)Class.forName(bufferBuilder).newInstance());
            }
            catch (ClassNotFoundException cnf) {
                LOGGER.warn("custom builder", (Throwable)cnf);
            }
            catch (IllegalAccessException iae) {
                LOGGER.warn("custom builder", (Throwable)iae);
            }
            catch (InstantiationException ie) {
                LOGGER.warn("custom builder", (Throwable)ie);
            }
            catch (ClassCastException cce) {
                LOGGER.warn("custom builder", (Throwable)cce);
            }
        }
    }

    void setBufferBuilder(BufferBuilder builder) {
        if (this.backend != null) {
            this.backend.setBufferBuilder(builder);
        }
    }

    BufferBuilder getBufferBuilder() {
        if (this.backend == null) {
            return null;
        }
        return this.backend.getBufferBuilder();
    }

    @Override
    public long write(Chunk region, long marker) throws IOException {
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        long blit = System.nanoTime();
        long w = this.backend.append(region, marker);
        blit = System.nanoTime() - blit;
        this.written += w;
        this.writeTime += blit;
        this.parts += (long)region.getBuffers().length;
        ++this.requests;
        return w;
    }

    @Override
    public void setMinimumMarker(long marker) throws IOException {
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        this.backend.setMinimumMarker(marker);
    }

    @Override
    public long getCurrentMarker() throws IOException {
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        return this.backend.getMarker();
    }

    @Override
    public long getMinimumMarker() throws IOException {
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        return this.backend.getMinimumMarker();
    }

    @Override
    public void sync() throws IOException {
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        long pos = this.backend.sync();
    }

    @Override
    public long seek(long marker) throws IOException {
        assert (this.readOpsAllowed);
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        this.backend.seek(marker);
        return marker;
    }

    @Override
    public Chunk read(Direction dir) throws IOException {
        assert (this.readOpsAllowed);
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        Chunk c = this.backend.read(dir);
        if (c != null) {
            this.read += c.remaining();
        }
        return c;
    }

    @Override
    public void close() throws IOException {
        if (this.backend != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("==PERFORMANCE(iostats)== " + this.getStatistics());
            }
            this.backend.close();
            LOGGER.debug(new Formatter(new StringBuilder()).format("==PERFORMANCE(iowrite)==  written: %.2f MB in %d parts over %d requests.\n==PERFORMANCE(iowrite)==  total time: %.3f msec -- rate: %.3f MB/s - %.4f B/part - %.2f parts/request", (double)this.written / 1048576.0, this.parts, this.requests, (double)this.writeTime * 0.001, (double)this.written * 1.0E9 / ((double)this.writeTime * 1024.0 * 1024.0), (double)this.written * 1.0 / (double)this.parts, (double)this.parts * 1.0 / (double)this.requests).out().toString());
        }
        if (this.lock != null) {
            this.lock.release();
            this.lock.channel().close();
            this.lock = null;
        }
        if (this.lockFile != null) {
            if (!this.lockFile.delete()) {
                throw new IOException("lock file cannot be deleted");
            }
            this.lockFile = null;
        }
        this.backend = null;
    }

    private void open() throws IOException {
        if (!this.directory.exists() || !this.directory.isDirectory()) {
            throw new IOException("DB home " + this.directory.getAbsolutePath() + " does not exist.");
        }
        this.backend = new NIOStreamImpl(this.directory, this.segmentSize, this.memorySize);
        this.lockFile = new File(this.directory, "FRS.lck");
        boolean crashed = !this.lockFile.createNewFile();
        FileOutputStream w = new FileOutputStream(this.lockFile);
        FileChannel lastSync = w.getChannel();
        this.lock = lastSync.tryLock();
        if (this.lock == null) {
            throw new IOException(LOCKFILE_ACTIVE);
        }
        this.backupLockFile = new File(this.directory, "frs.backup.lck");
        this.backupLockFile.createNewFile();
        this.backend.open();
    }

    public String toString() {
        return "NIO - " + this.directory.getAbsolutePath();
    }

    public boolean isClosed() {
        return this.lock == null || !this.lock.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IOStatistics getStatistics() throws IOException {
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        this.readOpsAllowed = false;
        try {
            NIOStatistics nIOStatistics = new NIOStatistics(this.directory, this.backend.getTotalSize(), this.backend.findLogTail(), this.written, this.read);
            return nIOStatistics;
        }
        finally {
            this.readOpsAllowed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Future<Void> clean(long timeout) throws IOException {
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PRE-clean " + this.getStatistics());
        }
        this.readOpsAllowed = false;
        FileOutputStream fos = new FileOutputStream(this.backupLockFile);
        FileChannel channel = fos.getChannel();
        FileLock backupLock = null;
        try {
            backupLock = channel.tryLock(0L, Long.MAX_VALUE, false);
        }
        catch (OverlappingFileLockException e) {
            LOGGER.info("Backup file already locked.");
        }
        try {
            if (backupLock == null || !backupLock.isValid()) {
                LOGGER.info("Unable to lock backup lockfile. Delaying log file cleanup until the backup is complete.");
                NullFuture nullFuture = NullFuture.INSTANCE;
                return nullFuture;
            }
            String string = this.backupLockFile.getCanonicalPath().intern();
            synchronized (string) {
                this.backend.trimLogTail(timeout);
            }
        }
        finally {
            if (backupLock != null) {
                backupLock.release();
            }
            fos.close();
            this.readOpsAllowed = true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("POST-clean " + this.getStatistics());
        }
        return NullFuture.INSTANCE;
    }
}

