/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.compaction;

import com.terracottatech.frs.compaction.CompactionPolicy;
import com.terracottatech.frs.config.Configuration;
import com.terracottatech.frs.config.FrsProperty;
import com.terracottatech.frs.log.LogManager;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.object.ObjectManagerEntry;

public class LSNGapCompactionPolicy
implements CompactionPolicy {
    private final ObjectManager<?, ?, ?> objectManager;
    private final LogManager logManager;
    private final double minLoad;
    private final double maxLoad;
    private long compactedCount;
    private long compactionStopCount;
    private boolean isCompacting = false;

    public LSNGapCompactionPolicy(ObjectManager<?, ?, ?> objectManager, LogManager logManager, Configuration configuration) {
        this.objectManager = objectManager;
        this.logManager = logManager;
        this.minLoad = configuration.getDouble(FrsProperty.COMPACTOR_LSNGAP_MIN_LOAD);
        this.maxLoad = configuration.getDouble(FrsProperty.COMPACTOR_LSNGAP_MAX_LOAD);
    }

    protected float calculateRatio(long liveEntries, long totalEntries) {
        return (float)liveEntries / (float)totalEntries;
    }

    @Override
    public boolean startCompacting() {
        long lowestLsn;
        long currentLsn;
        if (this.isCompacting) {
            throw new AssertionError((Object)"Compaction is already started.");
        }
        long liveSize = this.objectManager.size();
        float ratio = this.calculateRatio(liveSize, (currentLsn = this.logManager.currentLsn()) - (lowestLsn = this.objectManager.getLowestLsn()));
        if ((double)ratio <= this.minLoad) {
            this.compactionStopCount = (long)((double)liveSize / this.maxLoad) - currentLsn;
            this.compactedCount = 0L;
            this.isCompacting = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean compacted(ObjectManagerEntry<?, ?, ?> entry) {
        if (!this.isCompacting) {
            throw new AssertionError((Object)"Compaction is not running.");
        }
        ++this.compactedCount;
        return this.compactionStopCount <= this.compactedCount - entry.getLsn();
    }

    @Override
    public void stoppedCompacting() {
        if (!this.isCompacting) {
            throw new AssertionError((Object)"Compaction is not running.");
        }
        this.isCompacting = false;
    }
}

