/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.action;

import com.terracottatech.frs.action.Action;
import com.terracottatech.frs.action.ActionCodec;
import com.terracottatech.frs.action.ActionFactory;
import com.terracottatech.frs.action.NullAction;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.util.ByteBufferUtils;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ActionCodecImpl<I, K, V>
implements ActionCodec<I, K, V> {
    private final Map<Class<? extends Action>, ActionID> classToId = new ConcurrentHashMap<Class<? extends Action>, ActionID>();
    private final Map<ActionID, ActionFactory<I, K, V>> idToFactory = new ConcurrentHashMap<ActionID, ActionFactory<I, K, V>>();
    private final ObjectManager<I, K, V> objectManager;

    public ActionCodecImpl(ObjectManager<I, K, V> objectManager) {
        this.objectManager = objectManager;
        this.registerAction(-1, -1, NullAction.class, NullAction.factory());
    }

    @Override
    public synchronized void registerAction(int collectionId, int actionId, Class<? extends Action> actionClass, ActionFactory<I, K, V> actionFactory) {
        ActionID id = new ActionID(collectionId, actionId);
        if (this.classToId.containsKey(actionClass)) {
            throw new IllegalArgumentException("Action class " + actionClass + " already registered to id " + this.classToId.get(actionClass));
        }
        if (this.idToFactory.containsKey(id)) {
            throw new IllegalArgumentException("Id " + id + " already registered to action class " + this.idToFactory.get(id));
        }
        this.classToId.put(actionClass, id);
        this.idToFactory.put(id, actionFactory);
    }

    @Override
    public Action decode(ByteBuffer[] buffers) {
        ActionID id = ActionID.withByteBuffers(buffers);
        ActionFactory<I, K, V> factory = this.idToFactory.get(id);
        if (factory == null) {
            throw new IllegalArgumentException("Unknown Action type id= " + id);
        }
        return factory.create(this.objectManager, this, buffers);
    }

    @Override
    public ByteBuffer[] encode(Action action) {
        return ByteBufferUtils.concatenate(this.headerBuffer(action), action.getPayload(this));
    }

    private ByteBuffer headerBuffer(Action action) {
        if (!this.classToId.containsKey(action.getClass())) {
            throw new IllegalArgumentException("Unknown action class " + action.getClass());
        }
        return this.classToId.get(action.getClass()).toByteBuffer();
    }

    private static class ActionID {
        private final int collection;
        private final int action;

        private ActionID(int collection, int action) {
            this.collection = collection;
            this.action = action;
        }

        static ActionID withByteBuffers(ByteBuffer[] buffers) {
            return new ActionID(ByteBufferUtils.getInt(buffers), ByteBufferUtils.getInt(buffers));
        }

        ByteBuffer toByteBuffer() {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putInt(this.collection).putInt(this.action).flip();
            return buffer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActionID actionID = (ActionID)o;
            return this.action == actionID.action && this.collection == actionID.collection;
        }

        public int hashCode() {
            int result = this.collection;
            result = 31 * result + this.action;
            return result;
        }

        public String toString() {
            return "ActionID{collection=" + this.collection + ", action=" + this.action + '}';
        }
    }
}

