/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.codecs.lucene40.values;

import java.io.Closeable;
import java.io.IOException;
import org.terracotta.shaded.lucene.codecs.lucene40.values.Bytes;
import org.terracotta.shaded.lucene.codecs.lucene40.values.DirectSource;
import org.terracotta.shaded.lucene.document.Field;
import org.terracotta.shaded.lucene.document.StraightBytesDocValuesField;
import org.terracotta.shaded.lucene.index.DocValues;
import org.terracotta.shaded.lucene.index.IndexableField;
import org.terracotta.shaded.lucene.store.Directory;
import org.terracotta.shaded.lucene.store.IOContext;
import org.terracotta.shaded.lucene.store.IndexInput;
import org.terracotta.shaded.lucene.store.IndexOutput;
import org.terracotta.shaded.lucene.util.Bits;
import org.terracotta.shaded.lucene.util.ByteBlockPool;
import org.terracotta.shaded.lucene.util.BytesRef;
import org.terracotta.shaded.lucene.util.Counter;
import org.terracotta.shaded.lucene.util.IOUtils;
import org.terracotta.shaded.lucene.util.PagedBytes;

class FixedStraightBytesImpl {
    static final String CODEC_NAME = "FixedStraightBytes";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    FixedStraightBytesImpl() {
    }

    public static final class DirectFixedStraightSource
    extends DirectSource {
        private final int size;

        DirectFixedStraightSource(IndexInput input, int size, DocValues.Type type) {
            super(input, type);
            this.size = size;
        }

        @Override
        protected int position(int docID) throws IOException {
            this.data.seek(this.baseOffset + (long)this.size * (long)docID);
            return this.size;
        }
    }

    private static final class FixedStraightSource
    extends Bytes.BytesSourceBase {
        private final int size;

        public FixedStraightSource(IndexInput datIn, int size, int maxDoc, DocValues.Type type) throws IOException {
            super(datIn, null, new PagedBytes(15), size * maxDoc, type);
            this.size = size;
        }

        @Override
        public BytesRef getBytes(int docID, BytesRef bytesRef) {
            return this.data.fillSlice(bytesRef, (long)this.size * (long)docID, this.size);
        }
    }

    private static final class SingleByteSource
    extends DocValues.Source {
        private final byte[] data;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SingleByteSource(IndexInput datIn, int maxDoc) throws IOException {
            super(DocValues.Type.BYTES_FIXED_STRAIGHT);
            try {
                this.data = new byte[maxDoc];
                datIn.readBytes(this.data, 0, this.data.length, false);
            }
            catch (Throwable throwable) {
                IOUtils.close(datIn);
                throw throwable;
            }
            IOUtils.close(datIn);
        }

        @Override
        public boolean hasArray() {
            return true;
        }

        @Override
        public Object getArray() {
            return this.data;
        }

        @Override
        public BytesRef getBytes(int docID, BytesRef bytesRef) {
            bytesRef.length = 1;
            bytesRef.bytes = this.data;
            bytesRef.offset = docID;
            return bytesRef;
        }
    }

    public static class FixedStraightReader
    extends Bytes.BytesReaderBase {
        protected final int size;
        protected final int maxDoc;

        FixedStraightReader(Directory dir, String id, int maxDoc, IOContext context) throws IOException {
            this(dir, id, FixedStraightBytesImpl.CODEC_NAME, 0, maxDoc, context, DocValues.Type.BYTES_FIXED_STRAIGHT);
        }

        protected FixedStraightReader(Directory dir, String id, String codecNameDat, int version, int maxDoc, IOContext context, DocValues.Type type) throws IOException {
            super(dir, id, null, codecNameDat, version, false, context, type);
            this.size = this.datIn.readInt();
            this.maxDoc = maxDoc;
        }

        @Override
        public DocValues.Source load() throws IOException {
            return this.size == 1 ? new SingleByteSource(this.cloneData(), this.maxDoc) : new FixedStraightSource(this.cloneData(), this.size, this.maxDoc, this.type);
        }

        @Override
        public void close() throws IOException {
            this.datIn.close();
        }

        @Override
        public DocValues.Source getDirectSource() throws IOException {
            return new DirectFixedStraightSource(this.cloneData(), this.size, this.getType());
        }

        @Override
        public int getValueSize() {
            return this.size;
        }
    }

    static class Writer
    extends FixedBytesWriterBase {
        private boolean hasMerged;
        private IndexOutput datOut;

        public Writer(Directory dir, String id, Counter bytesUsed, IOContext context) {
            super(dir, id, FixedStraightBytesImpl.CODEC_NAME, 0, bytesUsed, context);
        }

        public Writer(Directory dir, String id, String codecNameDat, int version, Counter bytesUsed, IOContext context) {
            super(dir, id, codecNameDat, version, bytesUsed, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        protected void merge(DocValues readerIn, int docBase, int docCount, Bits liveDocs) throws IOException {
            block14: {
                block12: {
                    block13: {
                        this.datOut = this.getOrCreateDataOut();
                        success = false;
                        try {
                            if (!this.hasMerged && this.size != -1) {
                                this.datOut.writeInt(this.size);
                            }
                            if (liveDocs != null || !this.tryBulkMerge(readerIn)) ** GOTO lbl41
                            reader = (FixedStraightReader)readerIn;
                            maxDocs = reader.maxDoc;
                            if (maxDocs != 0) break block12;
                            if (success) break block13;
                        }
                        catch (Throwable var10_10) {
                            if (!success) {
                                IOUtils.closeWhileHandlingException(new Closeable[]{this.datOut});
                            }
                            this.hasMerged = true;
                            throw var10_10;
                        }
                        IOUtils.closeWhileHandlingException(new Closeable[]{this.datOut});
                    }
                    this.hasMerged = true;
                    return;
                }
                if (this.size == -1) {
                    this.size = reader.size;
                    this.datOut.writeInt(this.size);
                } else if (this.size != reader.size) {
                    throw new IllegalArgumentException("expected bytes size=" + this.size + " but got " + reader.size);
                }
                if (this.lastDocID + 1 < docBase) {
                    this.fill(this.datOut, docBase);
                    this.lastDocID = docBase - 1;
                }
                cloneData = reader.cloneData();
                try {
                    this.datOut.copyBytes(cloneData, this.size * maxDocs);
                }
                catch (Throwable var9_9) {
                    IOUtils.close(new Closeable[]{cloneData});
                    throw var9_9;
                }
                IOUtils.close(new Closeable[]{cloneData});
                this.lastDocID += maxDocs;
                break block14;
lbl41:
                // 1 sources

                super.merge(readerIn, docBase, docCount, liveDocs);
            }
            success = true;
            ** if (success) goto lbl47
lbl-1000:
            // 1 sources

            {
                IOUtils.closeWhileHandlingException(new Closeable[]{this.datOut});
            }
            {
            }
lbl47:
            // 2 sources

            this.hasMerged = true;
        }

        protected boolean tryBulkMerge(DocValues docValues) {
            return docValues instanceof FixedStraightReader;
        }

        @Override
        protected void mergeDoc(Field scratchField, DocValues.Source source, int docID, int sourceDoc) throws IOException {
            assert (this.lastDocID < docID);
            this.setMergeBytes(source, sourceDoc);
            if (this.size == -1) {
                this.size = this.bytesRef.length;
                this.datOut.writeInt(this.size);
            }
            assert (this.size == this.bytesRef.length) : "size: " + this.size + " ref: " + this.bytesRef.length;
            if (this.lastDocID + 1 < docID) {
                this.fill(this.datOut, docID);
            }
            this.datOut.writeBytes(this.bytesRef.bytes, this.bytesRef.offset, this.bytesRef.length);
            this.lastDocID = docID;
        }

        protected void setMergeBytes(DocValues.Source source, int sourceDoc) {
            source.getBytes(sourceDoc, this.bytesRef);
        }

        private void fill(IndexOutput datOut, int docID) throws IOException {
            assert (this.size >= 0);
            this.writeZeros(docID - (this.lastDocID + 1), datOut);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish(int docCount) throws IOException {
            boolean success = false;
            try {
                if (!this.hasMerged) {
                    assert (this.datOut == null);
                    this.datOut = this.getOrCreateDataOut();
                    if (this.size == -1) {
                        this.datOut.writeInt(0);
                    } else {
                        this.datOut.writeInt(this.size);
                        this.writeData(this.datOut);
                    }
                    if (this.lastDocID + 1 < docCount) {
                        this.fill(this.datOut, docCount);
                    }
                } else {
                    assert (this.datOut != null);
                    if (this.size == -1) {
                        this.datOut.writeInt(0);
                    } else {
                        this.fill(this.datOut, docCount);
                    }
                }
                success = true;
            }
            catch (Throwable throwable) {
                this.resetPool();
                if (success) {
                    IOUtils.close(this.datOut);
                } else {
                    IOUtils.closeWhileHandlingException(this.datOut);
                }
                throw throwable;
            }
            this.resetPool();
            if (success) {
                IOUtils.close(this.datOut);
            } else {
                IOUtils.closeWhileHandlingException(this.datOut);
            }
        }
    }

    static abstract class FixedBytesWriterBase
    extends Bytes.BytesWriterBase {
        protected final StraightBytesDocValuesField bytesSpareField = new StraightBytesDocValuesField("", new BytesRef(), true);
        protected int lastDocID = -1;
        protected int size = -1;
        private final int byteBlockSize = 32768;
        private final ByteBlockPool pool;

        protected FixedBytesWriterBase(Directory dir, String id, String codecNameDat, int version, Counter bytesUsed, IOContext context) {
            this(dir, id, codecNameDat, version, bytesUsed, context, DocValues.Type.BYTES_FIXED_STRAIGHT);
        }

        protected FixedBytesWriterBase(Directory dir, String id, String codecNameDat, int version, Counter bytesUsed, IOContext context, DocValues.Type type) {
            super(dir, id, null, codecNameDat, version, bytesUsed, context, type);
            this.pool = new ByteBlockPool(new ByteBlockPool.DirectTrackingAllocator(bytesUsed));
            this.pool.nextBuffer();
        }

        @Override
        public void add(int docID, IndexableField value) throws IOException {
            BytesRef bytes = value.binaryValue();
            assert (bytes != null);
            assert (this.lastDocID < docID);
            if (this.size == -1) {
                if (bytes.length > 32768) {
                    throw new IllegalArgumentException("bytes arrays > 32768 are not supported");
                }
                this.size = bytes.length;
            } else if (bytes.length != this.size) {
                throw new IllegalArgumentException("byte[] length changed for BYTES_FIXED_STRAIGHT type (before=" + this.size + " now=" + bytes.length);
            }
            if (this.lastDocID + 1 < docID) {
                this.advancePool(docID);
            }
            this.pool.copy(bytes);
            this.lastDocID = docID;
        }

        private final void advancePool(int docID) {
            long numBytes = (docID - (this.lastDocID + 1)) * this.size;
            while (numBytes > 0L) {
                if (numBytes + (long)this.pool.byteUpto < 32768L) {
                    this.pool.byteUpto = (int)((long)this.pool.byteUpto + numBytes);
                    numBytes = 0L;
                    continue;
                }
                numBytes -= (long)(32768 - this.pool.byteUpto);
                this.pool.nextBuffer();
            }
            assert (numBytes == 0L);
        }

        protected void set(BytesRef ref, int docId) {
            assert (32768 % this.size == 0) : "BYTE_BLOCK_SIZE (32768) must be a multiple of the size: " + this.size;
            ref.offset = docId * this.size;
            ref.length = this.size;
            this.pool.deref(ref);
        }

        protected void resetPool() {
            this.pool.dropBuffersAndReset();
        }

        protected void writeData(IndexOutput out) throws IOException {
            this.pool.writePool(out);
        }

        protected void writeZeros(int num, IndexOutput out) throws IOException {
            byte[] zeros = new byte[this.size];
            for (int i = 0; i < num; ++i) {
                out.writeBytes(zeros, zeros.length);
            }
        }

        @Override
        public int getValueSize() {
            return this.size;
        }
    }
}

