/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.codecs.lucene40;

import java.io.IOException;
import org.terracotta.shaded.lucene.codecs.lucene40.values.DocValuesWriterBase;
import org.terracotta.shaded.lucene.index.IndexFileNames;
import org.terracotta.shaded.lucene.index.PerDocWriteState;
import org.terracotta.shaded.lucene.store.CompoundFileDirectory;
import org.terracotta.shaded.lucene.store.Directory;
import org.terracotta.shaded.lucene.util.IOUtils;

public class Lucene40DocValuesConsumer
extends DocValuesWriterBase {
    private final Directory mainDirectory;
    private Directory directory;
    private final String segmentSuffix;
    public static final String DOC_VALUES_SEGMENT_SUFFIX = "dv";

    public Lucene40DocValuesConsumer(PerDocWriteState state, String segmentSuffix) {
        super(state);
        this.segmentSuffix = segmentSuffix;
        this.mainDirectory = state.directory;
    }

    @Override
    protected Directory getDirectory() throws IOException {
        if (this.directory == null) {
            this.directory = new CompoundFileDirectory(this.mainDirectory, IndexFileNames.segmentFileName(this.segmentName, this.segmentSuffix, "cfs"), this.context, true);
        }
        return this.directory;
    }

    @Override
    public void close() throws IOException {
        if (this.directory != null) {
            this.directory.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void abort() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            IOUtils.deleteFilesIgnoringExceptions(this.mainDirectory, IndexFileNames.segmentFileName(this.segmentName, this.segmentSuffix, "cfs"), IndexFileNames.segmentFileName(this.segmentName, this.segmentSuffix, "cfe"));
            catch (Throwable throwable2) {
                IOUtils.deleteFilesIgnoringExceptions(this.mainDirectory, IndexFileNames.segmentFileName(this.segmentName, this.segmentSuffix, "cfs"), IndexFileNames.segmentFileName(this.segmentName, this.segmentSuffix, "cfe"));
                throw throwable2;
            }
        }
        IOUtils.deleteFilesIgnoringExceptions(this.mainDirectory, IndexFileNames.segmentFileName(this.segmentName, this.segmentSuffix, "cfs"), IndexFileNames.segmentFileName(this.segmentName, this.segmentSuffix, "cfe"));
    }
}

