/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.factories;

import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.disk.paging.MappedPageSource;
import com.terracottatech.offheapstore.disk.persistent.PersistentReadWriteLockedOffHeapClockCache;
import com.terracottatech.offheapstore.disk.persistent.PersistentStorageEngine;
import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import com.terracottatech.offheapstore.util.Factory;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.ElementValueComparator;

public class EhcachePersistentSegmentFactory
implements Factory<Segment<Serializable, Element>> {
    private final RegisteredEventListeners evictionListener;
    private final Factory<? extends PersistentStorageEngine<? super Serializable, ? super Element>> storageEngineFactory;
    private final MappedPageSource tableSource;
    private final int tableSize;
    private final boolean bootstrap;
    private final AtomicLong size = new AtomicLong();
    private final long capacity;

    public EhcachePersistentSegmentFactory(RegisteredEventListeners evictionListener, MappedPageSource source, Factory<? extends PersistentStorageEngine<? super Serializable, ? super Element>> storageEngineFactory, int initialTableSize, long capacity, boolean bootstrap) {
        this.evictionListener = evictionListener;
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = source;
        this.tableSize = initialTableSize;
        this.bootstrap = bootstrap;
        this.capacity = capacity;
    }

    @Override
    public EhcachePersistentSegment newInstance() {
        PersistentStorageEngine<? super Serializable, ? super Element> storageEngine = this.storageEngineFactory.newInstance();
        try {
            if (this.capacity > 0L) {
                return new EhcachePersistentSegment(this.evictionListener, this.tableSource, storageEngine, this.tableSize, this.size, this.capacity, this.bootstrap);
            }
            return new EhcachePersistentSegment(this.evictionListener, this.tableSource, storageEngine, this.tableSize, this.bootstrap);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }

    public static class EhcachePersistentSegment
    extends PersistentReadWriteLockedOffHeapClockCache<Serializable, Element> {
        private final RegisteredEventListeners evictionListener;
        private final AtomicLong globalSize;
        private final long globalCapacity;

        EhcachePersistentSegment(RegisteredEventListeners evictionListener, MappedPageSource source, PersistentStorageEngine<? super Serializable, ? super Element> storageEngine, int tableSize, AtomicLong size, long capacity, boolean bootstrap) {
            super(source, storageEngine, tableSize, bootstrap);
            this.evictionListener = evictionListener;
            this.globalSize = size;
            this.globalCapacity = capacity;
        }

        EhcachePersistentSegment(RegisteredEventListeners evictionListener, MappedPageSource source, PersistentStorageEngine<? super Serializable, ? super Element> storageEngine, int tableSize, boolean bootstrap) {
            this(evictionListener, source, storageEngine, tableSize, new AtomicLong(), Long.MAX_VALUE, bootstrap);
        }

        @Override
        protected void added(int position) {
            super.added(position);
            long currentSize = this.globalSize.incrementAndGet();
            long evict = Math.min(currentSize - this.globalCapacity, 2L);
            for (long i = 0L; i < evict; ++i) {
                try {
                    this.storageEngineFailure(position, null);
                    continue;
                }
                catch (OversizeMappingException e) {
                    // empty catch block
                }
            }
        }

        private void storageEngineFailure(int activeIndex, Object failure) {
            int evictionIndex;
            if (this.isEmpty()) {
                StringBuilder sb = new StringBuilder("Storage Engine and Eviction Failed.\n");
                sb.append("Storage Engine : ").append(this.storageEngine);
                throw new OversizeMappingException(sb.toString());
            }
            while ((evictionIndex = this.getEvictionIndex()) == activeIndex) {
                if (this.size() != 1) continue;
                StringBuilder sb = new StringBuilder("Storage Engine and Eviction Failed.\n");
                sb.append("Storage Engine : ").append(this.storageEngine);
                throw new OversizeMappingException(sb.toString());
            }
            if (evictionIndex < 0) {
                StringBuilder sb = new StringBuilder("Storage Engine and Eviction Failed.\n");
                sb.append("Storage Engine : ").append(this.storageEngine);
                throw new OversizeMappingException(sb.toString());
            }
            this.evict(evictionIndex, false);
        }

        @Override
        protected void removed(int position) {
            super.removed(position);
            this.globalSize.decrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean evict(int index, boolean shrink) {
            Lock l = this.writeLock();
            l.lock();
            try {
                this.evict(index, shrink, false);
                boolean bl = true;
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Element evict() {
            Lock l = this.writeLock();
            if (l.tryLock()) {
                try {
                    int index = this.getEvictionIndex();
                    if (index < 0) {
                        Element element = null;
                        return element;
                    }
                    Element element = this.evict(index, false, true);
                    return element;
                }
                finally {
                    l.unlock();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Element evict(int index, boolean shrink, boolean forceResolve) {
            try {
                if (this.evictionListener.hasCacheEventListeners()) {
                    Element e = (Element)this.getAtTableOffset(index);
                    if (e.isExpired()) {
                        this.evictionListener.notifyElementExpiry(e, false);
                    } else {
                        this.evictionListener.notifyElementEvicted(e, false);
                    }
                    Element element = e;
                    return element;
                }
                if (forceResolve) {
                    Element element = (Element)this.getAtTableOffset(index);
                    return element;
                }
                Element element = null;
                return element;
            }
            finally {
                super.evict(index, shrink);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object key, Element value, ElementValueComparator comparator) {
            Lock l = this.writeLock();
            l.lock();
            try {
                if (key == null) {
                    throw new NullPointerException();
                }
                if (value == null) {
                    boolean bl = false;
                    return bl;
                }
                Element existing = (Element)super.get(key);
                if (comparator.equals(value, existing)) {
                    super.remove(key);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean replace(Serializable key, Element oldValue, Element newValue, ElementValueComparator comparator) {
            Lock l = this.writeLock();
            l.lock();
            try {
                Element existing = (Element)super.get(key);
                if (comparator.equals(oldValue, existing)) {
                    super.put(key, newValue);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                l.unlock();
            }
        }
    }
}

