/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.disk;

import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.pool.PoolableStore;
import net.sf.ehcache.pool.impl.AbstractPoolAccessor;
import net.sf.ehcache.store.offheap.disk.OffHeapDiskStore;
import net.sf.ehcache.store.offheap.disk.OffHeapDiskStoreSizeOfEngine;

public final class OffHeapDiskStorePoolAccessor
extends AbstractPoolAccessor<PoolableStore> {
    private final OffHeapDiskStore offHeapDiskStore;

    OffHeapDiskStorePoolAccessor(Pool<PoolableStore> pool, OffHeapDiskStore store) {
        super(pool, store, new OffHeapDiskStoreSizeOfEngine());
        this.offHeapDiskStore = store;
    }

    @Override
    protected long add(long sizeOf, boolean force) {
        this.checkLinked();
        long newSize = this.getPool().getSize() + sizeOf;
        long maxSize = this.getPool().getMaxSize();
        if (newSize <= maxSize) {
            return sizeOf;
        }
        if (!force && sizeOf > maxSize) {
            return -1L;
        }
        long missingSize = newSize - maxSize;
        if (this.getPool().getEvictor().freeSpace(this.getPool().getPoolableStores(), missingSize) || force) {
            return sizeOf;
        }
        return -1L;
    }

    @Override
    protected boolean canAddWithoutEvicting(long sizeOf) {
        return this.getPool().getSize() + sizeOf <= this.getPool().getMaxSize();
    }

    @Override
    public long delete(long sizeOf) {
        this.checkLinked();
        return sizeOf;
    }

    @Override
    public long getSize() {
        return this.offHeapDiskStore.getOccupiedMemory();
    }

    @Override
    protected void doClear() {
    }
}

