/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap;

import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.pinning.PinnableSegment;
import com.terracottatech.offheapstore.pinning.concurrent.AbstractPinnableConcurrentOffHeapCache;
import com.terracottatech.offheapstore.util.Factory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.Element;
import net.sf.ehcache.concurrent.ReadWriteLockSync;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.offheap.factories.EhcacheSegmentFactory;

public class EhcacheConcurrentOffHeapClockCache
extends AbstractPinnableConcurrentOffHeapCache<Serializable, Element> {
    private static final Comparator<Segment<?, ?>> SIZE_COMPARATOR = new Comparator<Segment<?, ?>>(){

        @Override
        public int compare(Segment<?, ?> o1, Segment<?, ?> o2) {
            return (int)(o2.getSize() - o1.getSize());
        }
    };
    private List<ReentrantReadWriteLock> locks;

    protected EhcacheConcurrentOffHeapClockCache(Factory<? extends PinnableSegment<Serializable, Element>> segmentFactory, int ssize) {
        super(segmentFactory, ssize, false);
    }

    public ReentrantReadWriteLock getLock(Object key) {
        return this.segmentFor(key).getLock();
    }

    public List<ReentrantReadWriteLock> getOrderedLocks() {
        List<ReentrantReadWriteLock> l = this.locks;
        return l == null ? (this.locks = this.generateLockList()) : l;
    }

    private List<ReentrantReadWriteLock> generateLockList() {
        ArrayList<ReentrantReadWriteLock> l = new ArrayList<ReentrantReadWriteLock>(this.segments.length);
        for (Segment c : this.segments) {
            l.add(c.getLock());
        }
        return Collections.unmodifiableList(l);
    }

    public boolean remove(Object key, Element element, ElementValueComparator comparator) {
        EhcacheSegmentFactory.EhcacheSegment segment = (EhcacheSegmentFactory.EhcacheSegment)this.segmentFor(key);
        return segment.remove(key, element, comparator);
    }

    public boolean replace(Serializable key, Element oldValue, Element newValue, ElementValueComparator comparator) {
        EhcacheSegmentFactory.EhcacheSegment segment = (EhcacheSegmentFactory.EhcacheSegment)this.segmentFor(key);
        return segment.replace(key, oldValue, newValue, comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shrink() {
        Segment[] sorted = (Segment[])this.segments.clone();
        Arrays.sort(sorted, SIZE_COMPARATOR);
        for (Segment s : sorted) {
            Lock l = ((EhcacheSegmentFactory.EhcacheSegment)s).getMasterLock();
            l.lock();
            try {
                if (!s.shrink()) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                l.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryShrink() {
        Segment[] sorted = (Segment[])this.segments.clone();
        Arrays.sort(sorted, SIZE_COMPARATOR);
        for (Segment s : sorted) {
            Lock l = ((EhcacheSegmentFactory.EhcacheSegment)s).getMasterLock();
            if (l != null) {
                l.lock();
            }
            try {
                if (!((EhcacheSegmentFactory.EhcacheSegment)s).tryShrink()) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                if (l != null) {
                    l.unlock();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shrinkOthers(int excludedHash) {
        boolean evicted = false;
        Segment target = this.segmentFor(excludedHash);
        for (Segment s : this.segments) {
            if (s == target) continue;
            Lock l = ((EhcacheSegmentFactory.EhcacheSegment)s).getMasterLock();
            l.lock();
            try {
                evicted |= s.shrink();
            }
            finally {
                l.unlock();
            }
        }
        return evicted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryShrinkOthers(int excludedHash) {
        boolean evicted = false;
        Segment target = this.segmentFor(excludedHash);
        for (Segment s : this.segments) {
            if (s == target) continue;
            Lock l = ((EhcacheSegmentFactory.EhcacheSegment)s).getMasterLock();
            if (l != null) {
                l.lock();
            }
            try {
                evicted |= ((EhcacheSegmentFactory.EhcacheSegment)s).tryShrink();
            }
            finally {
                if (l != null) {
                    l.unlock();
                }
            }
        }
        return evicted;
    }

    @Override
    protected int getConcurrency() {
        return super.getConcurrency();
    }

    protected int getIndexFor(Object object) {
        return super.getIndexFor(object.hashCode());
    }

    protected void registerMasterLocks(List<ReadWriteLockSync> locks) {
        if (locks.size() != this.segments.length) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.segments.length; ++i) {
            ((EhcacheSegmentFactory.EhcacheSegment)this.segments[i]).registerMasterLock(locks.get(i).getReadWriteLock().writeLock());
        }
    }
}

