/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.heap;

import com.terracottatech.frs.TransactionException;
import com.terracottatech.offheapstore.storage.portability.Portability;
import com.terracottatech.offheapstore.storage.portability.SerializablePortability;
import java.io.Serializable;
import java.nio.ByteBuffer;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.pool.PoolAccessor;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.chm.SelectableConcurrentHashMap;
import net.sf.ehcache.store.heap.RestartableSelectableConcurrentHashMap;
import net.sf.ehcache.store.offheap.portability.EhcacheElementPortability;
import net.sf.ehcache.store.offheap.portability.EhcacheKeyPortability;
import net.sf.ehcache.store.restartability.EhcacheRestartability;
import net.sf.ehcache.writer.CacheWriterManager;

public class RestartableHeapStore
extends MemoryStore {
    private final boolean synchronous;
    private final EhcacheRestartability ehcacheRestartability;

    public static RestartableHeapStore create(EhcacheRestartability restartability, boolean synchronous, Ehcache cache, Pool<?> pool) {
        RestartableHeapStore memoryStore = new RestartableHeapStore(cache, pool, new RestartableBackingMapFactory(restartability, synchronous, cache.getCacheManager().getConfiguration(), cache.getCacheConfiguration()), synchronous, restartability);
        cache.getCacheConfiguration().addConfigurationListener(memoryStore);
        return memoryStore;
    }

    protected RestartableHeapStore(Ehcache cache, Pool<?> pool, MemoryStore.BackingFactory backingFactory, boolean synchronous, EhcacheRestartability ehcacheRestartability) {
        super(cache, pool, true, backingFactory);
        this.synchronous = synchronous;
        this.ehcacheRestartability = ehcacheRestartability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) throws CacheException {
        this.ehcacheRestartability.beginCacheStoreTransaction(this.synchronous);
        try {
            boolean bl = super.putWithWriter(element, writerManager);
            return bl;
        }
        finally {
            try {
                this.ehcacheRestartability.commitCacheStoreTransaction();
            }
            catch (TransactionException e) {
                throw new CacheException(e);
            }
        }
    }

    @Override
    public void flush() {
    }

    static class RestartableBackingMapFactory
    implements MemoryStore.BackingFactory {
        private final ByteBuffer identifier;
        private final EhcacheRestartability restartability;
        private final boolean synchronous;
        private final Configuration config;
        private final CacheConfiguration cacheConfig;
        private final Portability<Serializable> keyPortability;
        private final Portability<Element> elementPortability;

        public RestartableBackingMapFactory(EhcacheRestartability restartability, boolean synchronous, Configuration config, CacheConfiguration cacheConfig) {
            ByteBuffer identifier;
            this.identifier = identifier = EhcacheRestartability.getCacheIdentifier(cacheConfig.getName());
            this.config = config;
            this.cacheConfig = cacheConfig;
            this.restartability = restartability;
            this.synchronous = synchronous;
            SerializablePortability delegatePortability = restartability.getRestartablePortability();
            this.keyPortability = new EhcacheKeyPortability(delegatePortability);
            this.elementPortability = new EhcacheElementPortability(delegatePortability, cacheConfig);
        }

        @Override
        public SelectableConcurrentHashMap newBackingMap(PoolAccessor<?> poolAccessor, boolean elementPinning, int initialCapacity, float loadFactor, int concurrency, int maximumCapacity, RegisteredEventListeners eventListener) {
            RestartableSelectableConcurrentHashMap map = new RestartableSelectableConcurrentHashMap(this.identifier, this.restartability.getCacheStore(), this.synchronous, this.keyPortability, this.elementPortability, poolAccessor, elementPinning, initialCapacity, loadFactor, concurrency, maximumCapacity, eventListener);
            this.restartability.registerCacheStripe(this.identifier, this.config, this.cacheConfig, map.getObjectManagerStripe());
            return map;
        }

        @Override
        public SelectableConcurrentHashMap newBackingMap(PoolAccessor<?> poolAccessor, boolean elementPinning, int concurrency, int maximumCapacity, RegisteredEventListeners eventListener) {
            RestartableSelectableConcurrentHashMap map = new RestartableSelectableConcurrentHashMap(this.identifier, this.restartability.getCacheStore(), this.synchronous, this.keyPortability, this.elementPortability, poolAccessor, elementPinning, concurrency, maximumCapacity, eventListener);
            this.restartability.registerCacheStripe(this.identifier, this.config, this.cacheConfig, map.getObjectManagerStripe());
            return map;
        }
    }
}

