/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.util;

import com.terracottatech.offheapstore.util.AbstractStatistic;
import java.util.concurrent.TimeUnit;

public class UnlockedStatistic
extends AbstractStatistic {
    private volatile long count = 0L;
    private volatile long rateSampleTime = System.nanoTime();
    private volatile float rateSample = 0.0f;
    private volatile long sampleRateMask = 0L;
    private volatile long previousSample = 0L;

    public UnlockedStatistic(long averagePeriod, TimeUnit unit) {
        super(averagePeriod, unit);
    }

    @Override
    public void event() {
        long previous;
        long now;
        long value;
        if (((value = ++this.count) & this.sampleRateMask) == 0L && (now = System.nanoTime()) != (previous = this.rateSampleTime) && value > this.previousSample) {
            this.rateSampleTime = now;
            float nowRate = (float)(value - this.previousSample) / (float)(now - previous);
            this.previousSample = value;
            this.rateSample = this.iterateMovingAverage(nowRate, now, this.rateSample, previous);
            long suggestedSampleRateMask = Long.highestOneBit(Math.max(1L, (long)((float)this.rateAveragePeriod * this.rateSample))) - 1L;
            if (suggestedSampleRateMask != this.sampleRateMask) {
                this.sampleRateMask = suggestedSampleRateMask;
            }
        }
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public float getRate() {
        long then = this.rateSampleTime;
        long lastSample = this.previousSample;
        float thenAverage = this.rateSample;
        long now = System.nanoTime();
        if (now == then) {
            return thenAverage * (float)TimeUnit.SECONDS.toNanos(1L);
        }
        float nowValue = (float)(this.count - lastSample) / (float)(now - then);
        float rate = this.iterateMovingAverage(nowValue, now, thenAverage, then);
        if (Float.isNaN(rate)) {
            if (Float.isNaN(thenAverage)) {
                return 0.0f;
            }
            return thenAverage * (float)TimeUnit.SECONDS.toNanos(1L);
        }
        return rate * (float)TimeUnit.SECONDS.toNanos(1L);
    }
}

