/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.util;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class LongBitSet
implements Set<Long> {
    HashMap<Long, BitSet> master = new HashMap();
    private final int segmentation = Integer.MAX_VALUE;

    private BitSet divide(long value, OP op) {
        long slot = value / Integer.MAX_VALUE;
        if (op == OP.REMOVE) {
            return this.master.remove(slot);
        }
        BitSet set = this.master.get(slot);
        if (set == null && op == OP.CREATE) {
            set = new BitSet();
            this.master.put(slot, set);
        }
        return set;
    }

    private int offset(long value) {
        return (int)(value % Integer.MAX_VALUE);
    }

    @Override
    public boolean add(Long e) {
        this.divide(e, OP.CREATE).set(this.offset(e));
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Long> clctn) {
        for (Long l : clctn) {
            this.add(l);
        }
        return true;
    }

    @Override
    public void clear() {
        this.master.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Long) {
            Long e = (Long)o;
            BitSet set = this.divide(e, OP.FIND);
            if (set == null) {
                return false;
            }
            return set.get(this.offset(e));
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> clctn) {
        for (Object e : clctn) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.master.isEmpty();
    }

    @Override
    public Iterator<Long> iterator() {
        return null;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Long) {
            Long e = (Long)o;
            BitSet set = this.divide(e, OP.FIND);
            if (set == null) {
                return false;
            }
            if (set.get(this.offset(e))) {
                set.clear(this.offset(e));
                if (set.isEmpty()) {
                    this.divide(e, OP.REMOVE);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> clctn) {
        for (Object e : clctn) {
            if (this.remove(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> clctn) {
        return false;
    }

    @Override
    public int size() {
        int count = 0;
        for (BitSet b : this.master.values()) {
            count += b.cardinality();
        }
        return count;
    }

    @Override
    public Object[] toArray() {
        return null;
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return null;
    }

    static enum OP {
        FIND,
        CREATE,
        REMOVE;

    }
}

