/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.object;

import com.terracottatech.frs.object.AbstractObjectManager;
import com.terracottatech.frs.object.ObjectManagerStripe;
import com.terracottatech.frs.object.RestartableObject;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RegisterableObjectManager<I, K, V>
extends AbstractObjectManager<I, K, V> {
    private final ConcurrentMap<I, ObjectManagerStripe<I, K, V>> stripes = new ConcurrentHashMap<I, ObjectManagerStripe<I, K, V>>();

    @Override
    protected ObjectManagerStripe<I, K, V> getStripeFor(I id) {
        return (ObjectManagerStripe)this.stripes.get(id);
    }

    @Override
    protected Collection<ObjectManagerStripe<I, K, V>> getStripes() {
        return this.stripes.values();
    }

    public void registerObject(RestartableObject<I, K, V> object) {
        this.registerStripe(object.getId(), object.getObjectManagerStripe());
    }

    public void registerStripe(I id, ObjectManagerStripe<I, K, V> stripe) {
        ObjectManagerStripe<I, K, V> previous = this.stripes.putIfAbsent(id, stripe);
        if (previous != null) {
            throw new AssertionError((Object)(id + " already mapped"));
        }
    }
}

