/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.store;

import java.io.File;
import java.io.IOException;
import org.terracotta.shaded.lucene.store.FSLockFactory;
import org.terracotta.shaded.lucene.store.Lock;
import org.terracotta.shaded.lucene.store.NativeFSLock;

public class NativeFSLockFactory
extends FSLockFactory {
    public NativeFSLockFactory() throws IOException {
        this((File)null);
    }

    public NativeFSLockFactory(String lockDirName) throws IOException {
        this(new File(lockDirName));
    }

    public NativeFSLockFactory(File lockDir) throws IOException {
        this.setLockDir(lockDir);
    }

    public synchronized Lock makeLock(String lockName) {
        if (this.lockPrefix != null) {
            lockName = this.lockPrefix + "-" + lockName;
        }
        return new NativeFSLock(this.lockDir, lockName);
    }

    public void clearLock(String lockName) throws IOException {
        if (this.lockDir.exists()) {
            File lockFile;
            if (this.lockPrefix != null) {
                lockName = this.lockPrefix + "-" + lockName;
            }
            if ((lockFile = new File(this.lockDir, lockName)).exists() && !lockFile.delete()) {
                throw new IOException("Cannot delete " + lockFile);
            }
        }
    }
}

