/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.store;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.terracotta.shaded.lucene.store.Directory;
import org.terracotta.shaded.lucene.store.IndexInput;
import org.terracotta.shaded.lucene.store.IndexOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSwitchDirectory
extends Directory {
    private final Directory secondaryDir;
    private final Directory primaryDir;
    private final Set<String> primaryExtensions;
    private boolean doClose;

    public FileSwitchDirectory(Set<String> primaryExtensions, Directory primaryDir, Directory secondaryDir, boolean doClose) {
        this.primaryExtensions = primaryExtensions;
        this.primaryDir = primaryDir;
        this.secondaryDir = secondaryDir;
        this.doClose = doClose;
        this.lockFactory = primaryDir.getLockFactory();
    }

    public Directory getPrimaryDir() {
        return this.primaryDir;
    }

    public Directory getSecondaryDir() {
        return this.secondaryDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.doClose) {
            try {
                this.secondaryDir.close();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.primaryDir.close();
                throw throwable;
            }
            this.primaryDir.close();
            this.doClose = false;
        }
    }

    @Override
    public String[] listAll() throws IOException {
        HashSet<String> files = new HashSet<String>();
        for (String f : this.primaryDir.listAll()) {
            files.add(f);
        }
        for (String f : this.secondaryDir.listAll()) {
            files.add(f);
        }
        return files.toArray(new String[files.size()]);
    }

    public static String getExtension(String name) {
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return name.substring(i + 1, name.length());
    }

    private Directory getDirectory(String name) {
        String ext = FileSwitchDirectory.getExtension(name);
        if (this.primaryExtensions.contains(ext)) {
            return this.primaryDir;
        }
        return this.secondaryDir;
    }

    @Override
    public boolean fileExists(String name) throws IOException {
        return this.getDirectory(name).fileExists(name);
    }

    @Override
    public long fileModified(String name) throws IOException {
        return this.getDirectory(name).fileModified(name);
    }

    @Override
    public void touchFile(String name) throws IOException {
        this.getDirectory(name).touchFile(name);
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.getDirectory(name).deleteFile(name);
    }

    @Override
    public long fileLength(String name) throws IOException {
        return this.getDirectory(name).fileLength(name);
    }

    @Override
    public IndexOutput createOutput(String name) throws IOException {
        return this.getDirectory(name).createOutput(name);
    }

    @Override
    public void sync(String name) throws IOException {
        this.getDirectory(name).sync(name);
    }

    @Override
    public IndexInput openInput(String name) throws IOException {
        return this.getDirectory(name).openInput(name);
    }
}

