/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.search;

import java.io.IOException;
import org.terracotta.shaded.lucene.index.IndexReader;
import org.terracotta.shaded.lucene.search.Collector;
import org.terracotta.shaded.lucene.search.Scorer;
import org.terracotta.shaded.lucene.util.ThreadInterruptedException;

public class TimeLimitingCollector
extends Collector {
    public static final int DEFAULT_RESOLUTION = 20;
    public boolean DEFAULT_GREEDY;
    private static long resolution = 20L;
    private boolean greedy;
    private static final TimerThread TIMER_THREAD = new TimerThread();
    private final long t0;
    private final long timeout;
    private final Collector collector;
    private int docBase;

    public TimeLimitingCollector(Collector collector, long timeAllowed) {
        this.greedy = this.DEFAULT_GREEDY = false;
        this.collector = collector;
        this.t0 = TIMER_THREAD.getMilliseconds();
        this.timeout = this.t0 + timeAllowed;
    }

    public static long getResolution() {
        return resolution;
    }

    public static void setResolution(long newResolution) {
        resolution = Math.max(newResolution, 5L);
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    public void setGreedy(boolean greedy) {
        this.greedy = greedy;
    }

    public void collect(int doc) throws IOException {
        long time = TIMER_THREAD.getMilliseconds();
        if (this.timeout < time) {
            if (this.greedy) {
                this.collector.collect(doc);
            }
            throw new TimeExceededException(this.timeout - this.t0, time - this.t0, this.docBase + doc);
        }
        this.collector.collect(doc);
    }

    public void setNextReader(IndexReader reader, int base) throws IOException {
        this.collector.setNextReader(reader, base);
        this.docBase = base;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.collector.setScorer(scorer);
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.collector.acceptsDocsOutOfOrder();
    }

    static {
        TIMER_THREAD.start();
    }

    public static class TimeExceededException
    extends RuntimeException {
        private long timeAllowed;
        private long timeElapsed;
        private int lastDocCollected;

        private TimeExceededException(long timeAllowed, long timeElapsed, int lastDocCollected) {
            super("Elapsed time: " + timeElapsed + "Exceeded allowed search time: " + timeAllowed + " ms.");
            this.timeAllowed = timeAllowed;
            this.timeElapsed = timeElapsed;
            this.lastDocCollected = lastDocCollected;
        }

        public long getTimeAllowed() {
            return this.timeAllowed;
        }

        public long getTimeElapsed() {
            return this.timeElapsed;
        }

        public int getLastDocCollected() {
            return this.lastDocCollected;
        }
    }

    private static final class TimerThread
    extends Thread {
        private volatile long time = 0L;

        private TimerThread() {
            super("TimeLimitedCollector timer thread");
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                this.time += resolution;
                try {
                    Thread.sleep(resolution);
                }
                catch (InterruptedException ie) {
                    throw new ThreadInterruptedException(ie);
                }
            }
        }

        public long getMilliseconds() {
            return this.time;
        }
    }
}

