/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.search;

import java.io.IOException;
import org.terracotta.shaded.lucene.index.TermDocs;
import org.terracotta.shaded.lucene.search.Collector;
import org.terracotta.shaded.lucene.search.Scorer;
import org.terracotta.shaded.lucene.search.Similarity;
import org.terracotta.shaded.lucene.search.Weight;

final class TermScorer
extends Scorer {
    private static final float[] SIM_NORM_DECODER = Similarity.getNormDecoder();
    private Weight weight;
    private TermDocs termDocs;
    private byte[] norms;
    private float weightValue;
    private int doc = -1;
    private final int[] docs = new int[32];
    private final int[] freqs = new int[32];
    private int pointer;
    private int pointerMax;
    private static final int SCORE_CACHE_SIZE = 32;
    private float[] scoreCache = new float[32];

    TermScorer(Weight weight, TermDocs td, Similarity similarity, byte[] norms) {
        super(similarity);
        this.weight = weight;
        this.termDocs = td;
        this.norms = norms;
        this.weightValue = weight.getValue();
        for (int i = 0; i < 32; ++i) {
            this.scoreCache[i] = this.getSimilarity().tf(i) * this.weightValue;
        }
    }

    public void score(Collector c) throws IOException {
        this.score(c, Integer.MAX_VALUE, this.nextDoc());
    }

    protected boolean score(Collector c, int end, int firstDocID) throws IOException {
        c.setScorer(this);
        while (this.doc < end) {
            c.collect(this.doc);
            if (++this.pointer >= this.pointerMax) {
                this.pointerMax = this.termDocs.read(this.docs, this.freqs);
                if (this.pointerMax != 0) {
                    this.pointer = 0;
                } else {
                    this.termDocs.close();
                    this.doc = Integer.MAX_VALUE;
                    return false;
                }
            }
            this.doc = this.docs[this.pointer];
        }
        return true;
    }

    public int docID() {
        return this.doc;
    }

    public int nextDoc() throws IOException {
        ++this.pointer;
        if (this.pointer >= this.pointerMax) {
            this.pointerMax = this.termDocs.read(this.docs, this.freqs);
            if (this.pointerMax != 0) {
                this.pointer = 0;
            } else {
                this.termDocs.close();
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
        }
        this.doc = this.docs[this.pointer];
        return this.doc;
    }

    public float score() {
        assert (this.doc != -1);
        int f = this.freqs[this.pointer];
        float raw = f < 32 ? this.scoreCache[f] : this.getSimilarity().tf(f) * this.weightValue;
        return this.norms == null ? raw : raw * SIM_NORM_DECODER[this.norms[this.doc] & 0xFF];
    }

    public int advance(int target) throws IOException {
        ++this.pointer;
        while (this.pointer < this.pointerMax) {
            if (this.docs[this.pointer] >= target) {
                this.doc = this.docs[this.pointer];
                return this.doc;
            }
            ++this.pointer;
        }
        boolean result = this.termDocs.skipTo(target);
        if (result) {
            this.pointerMax = 1;
            this.pointer = 0;
            this.docs[this.pointer] = this.doc = this.termDocs.doc();
            this.freqs[this.pointer] = this.termDocs.freq();
        } else {
            this.doc = Integer.MAX_VALUE;
        }
        return this.doc;
    }

    public String toString() {
        return "scorer(" + this.weight + ")";
    }
}

