/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.search;

import java.io.IOException;
import org.terracotta.shaded.lucene.document.Document;
import org.terracotta.shaded.lucene.document.FieldSelector;
import org.terracotta.shaded.lucene.index.CorruptIndexException;
import org.terracotta.shaded.lucene.index.Term;
import org.terracotta.shaded.lucene.search.Collector;
import org.terracotta.shaded.lucene.search.Explanation;
import org.terracotta.shaded.lucene.search.Filter;
import org.terracotta.shaded.lucene.search.Query;
import org.terracotta.shaded.lucene.search.Searchable;
import org.terracotta.shaded.lucene.search.Similarity;
import org.terracotta.shaded.lucene.search.Sort;
import org.terracotta.shaded.lucene.search.TopDocs;
import org.terracotta.shaded.lucene.search.TopFieldDocs;
import org.terracotta.shaded.lucene.search.Weight;

public abstract class Searcher
implements Searchable {
    private Similarity similarity = Similarity.getDefault();

    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
        return this.search(this.createWeight(query), filter, n, sort);
    }

    public void search(Query query, Collector results) throws IOException {
        this.search(this.createWeight(query), null, results);
    }

    public void search(Query query, Filter filter, Collector results) throws IOException {
        this.search(this.createWeight(query), filter, results);
    }

    public TopDocs search(Query query, Filter filter, int n) throws IOException {
        return this.search(this.createWeight(query), filter, n);
    }

    public TopDocs search(Query query, int n) throws IOException {
        return this.search(query, null, n);
    }

    public Explanation explain(Query query, int doc) throws IOException {
        return this.explain(this.createWeight(query), doc);
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    protected Weight createWeight(Query query) throws IOException {
        return query.weight(this);
    }

    public int[] docFreqs(Term[] terms) throws IOException {
        int[] result = new int[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            result[i] = this.docFreq(terms[i]);
        }
        return result;
    }

    public abstract void search(Weight var1, Filter var2, Collector var3) throws IOException;

    public abstract void close() throws IOException;

    public abstract int docFreq(Term var1) throws IOException;

    public abstract int maxDoc() throws IOException;

    public abstract TopDocs search(Weight var1, Filter var2, int var3) throws IOException;

    public abstract Document doc(int var1) throws CorruptIndexException, IOException;

    public abstract Document doc(int var1, FieldSelector var2) throws CorruptIndexException, IOException;

    public abstract Query rewrite(Query var1) throws IOException;

    public abstract Explanation explain(Weight var1, int var2) throws IOException;

    public abstract TopFieldDocs search(Weight var1, Filter var2, int var3, Sort var4) throws IOException;
}

