/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.search;

import java.io.IOException;
import org.terracotta.shaded.lucene.index.IndexReader;
import org.terracotta.shaded.lucene.index.Term;
import org.terracotta.shaded.lucene.search.FilteredTermEnum;

public class PrefixTermEnum
extends FilteredTermEnum {
    private final Term prefix;
    private boolean endEnum = false;

    public PrefixTermEnum(IndexReader reader, Term prefix) throws IOException {
        this.prefix = prefix;
        this.setEnum(reader.terms(new Term(prefix.field(), prefix.text())));
    }

    public float difference() {
        return 1.0f;
    }

    protected boolean endEnum() {
        return this.endEnum;
    }

    protected Term getPrefixTerm() {
        return this.prefix;
    }

    protected boolean termCompare(Term term) {
        if (term.field() == this.prefix.field() && term.text().startsWith(this.prefix.text())) {
            return true;
        }
        this.endEnum = true;
        return false;
    }
}

