/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.terracotta.shaded.lucene.index.IndexReader;
import org.terracotta.shaded.lucene.index.Term;
import org.terracotta.shaded.lucene.search.DocIdSet;
import org.terracotta.shaded.lucene.search.DocIdSetIterator;
import org.terracotta.shaded.lucene.search.Explanation;
import org.terracotta.shaded.lucene.search.Filter;
import org.terracotta.shaded.lucene.search.Query;
import org.terracotta.shaded.lucene.search.Scorer;
import org.terracotta.shaded.lucene.search.Searcher;
import org.terracotta.shaded.lucene.search.Similarity;
import org.terracotta.shaded.lucene.search.Weight;
import org.terracotta.shaded.lucene.util.ToStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredQuery
extends Query {
    Query query;
    Filter filter;

    public FilteredQuery(Query query, Filter filter) {
        this.query = query;
        this.filter = filter;
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        final Weight weight = this.query.createWeight(searcher);
        final Similarity similarity = this.query.getSimilarity(searcher);
        return new Weight(){
            private float value;

            public float getValue() {
                return this.value;
            }

            public float sumOfSquaredWeights() throws IOException {
                return weight.sumOfSquaredWeights() * FilteredQuery.this.getBoost() * FilteredQuery.this.getBoost();
            }

            public void normalize(float v) {
                weight.normalize(v);
                this.value = weight.getValue() * FilteredQuery.this.getBoost();
            }

            public Explanation explain(IndexReader ir, int i) throws IOException {
                Filter f;
                DocIdSet docIdSet;
                DocIdSetIterator docIdSetIterator;
                Explanation inner = weight.explain(ir, i);
                if (FilteredQuery.this.getBoost() != 1.0f) {
                    Explanation preBoost = inner;
                    inner = new Explanation(inner.getValue() * FilteredQuery.this.getBoost(), "product of:");
                    inner.addDetail(new Explanation(FilteredQuery.this.getBoost(), "boost"));
                    inner.addDetail(preBoost);
                }
                DocIdSetIterator docIdSetIterator2 = docIdSetIterator = (docIdSet = (f = FilteredQuery.this.filter).getDocIdSet(ir)) == null ? DocIdSet.EMPTY_DOCIDSET.iterator() : docIdSet.iterator();
                if (docIdSetIterator == null) {
                    docIdSetIterator = DocIdSet.EMPTY_DOCIDSET.iterator();
                }
                if (docIdSetIterator.advance(i) == i) {
                    return inner;
                }
                Explanation result = new Explanation(0.0f, "failure to match filter: " + f.toString());
                result.addDetail(inner);
                return result;
            }

            public Query getQuery() {
                return FilteredQuery.this;
            }

            public Scorer scorer(IndexReader indexReader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
                final Scorer scorer = weight.scorer(indexReader, true, false);
                if (scorer == null) {
                    return null;
                }
                DocIdSet docIdSet = FilteredQuery.this.filter.getDocIdSet(indexReader);
                if (docIdSet == null) {
                    return null;
                }
                final DocIdSetIterator docIdSetIterator = docIdSet.iterator();
                if (docIdSetIterator == null) {
                    return null;
                }
                return new Scorer(similarity){
                    private int doc;
                    {
                        super(x0);
                        this.doc = -1;
                    }

                    private int advanceToCommon(int scorerDoc, int disiDoc) throws IOException {
                        while (scorerDoc != disiDoc) {
                            if (scorerDoc < disiDoc) {
                                scorerDoc = scorer.advance(disiDoc);
                                continue;
                            }
                            disiDoc = docIdSetIterator.advance(scorerDoc);
                        }
                        return scorerDoc;
                    }

                    public int nextDoc() throws IOException {
                        int scorerDoc;
                        int disiDoc = docIdSetIterator.nextDoc();
                        this.doc = disiDoc != Integer.MAX_VALUE && (scorerDoc = scorer.nextDoc()) != Integer.MAX_VALUE && this.advanceToCommon(scorerDoc, disiDoc) != Integer.MAX_VALUE ? scorer.docID() : Integer.MAX_VALUE;
                        return this.doc;
                    }

                    public int docID() {
                        return this.doc;
                    }

                    public int advance(int target) throws IOException {
                        int scorerDoc;
                        int disiDoc = docIdSetIterator.advance(target);
                        this.doc = disiDoc != Integer.MAX_VALUE && (scorerDoc = scorer.advance(disiDoc)) != Integer.MAX_VALUE && this.advanceToCommon(scorerDoc, disiDoc) != Integer.MAX_VALUE ? scorer.docID() : Integer.MAX_VALUE;
                        return this.doc;
                    }

                    public float score() throws IOException {
                        return FilteredQuery.this.getBoost() * scorer.score();
                    }
                };
            }
        };
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.query.rewrite(reader);
        if (rewritten != this.query) {
            FilteredQuery clone = (FilteredQuery)this.clone();
            clone.query = rewritten;
            return clone;
        }
        return this;
    }

    public Query getQuery() {
        return this.query;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.getQuery().extractTerms(terms);
    }

    @Override
    public String toString(String s) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("filtered(");
        buffer.append(this.query.toString(s));
        buffer.append(")->");
        buffer.append(this.filter);
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof FilteredQuery) {
            FilteredQuery fq = (FilteredQuery)o;
            return this.query.equals(fq.query) && this.filter.equals(fq.filter) && this.getBoost() == fq.getBoost();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.query.hashCode() ^ this.filter.hashCode() + Float.floatToRawIntBits(this.getBoost());
    }
}

