/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.terracotta.shaded.lucene.search.Collector;
import org.terracotta.shaded.lucene.search.ConjunctionScorer;
import org.terracotta.shaded.lucene.search.DisjunctionSumScorer;
import org.terracotta.shaded.lucene.search.ReqExclScorer;
import org.terracotta.shaded.lucene.search.ReqOptSumScorer;
import org.terracotta.shaded.lucene.search.Scorer;
import org.terracotta.shaded.lucene.search.Similarity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BooleanScorer2
extends Scorer {
    private final List<Scorer> requiredScorers;
    private final List<Scorer> optionalScorers;
    private final List<Scorer> prohibitedScorers;
    private final Coordinator coordinator;
    private final Scorer countingSumScorer;
    private final int minNrShouldMatch;
    private int doc = -1;
    private static final Similarity defaultSimilarity = Similarity.getDefault();

    public BooleanScorer2(Similarity similarity, int minNrShouldMatch, List<Scorer> required, List<Scorer> prohibited, List<Scorer> optional) throws IOException {
        super(similarity);
        if (minNrShouldMatch < 0) {
            throw new IllegalArgumentException("Minimum number of optional scorers should not be negative");
        }
        this.coordinator = new Coordinator();
        this.minNrShouldMatch = minNrShouldMatch;
        this.optionalScorers = optional;
        this.coordinator.maxCoord += optional.size();
        this.requiredScorers = required;
        this.coordinator.maxCoord += required.size();
        this.prohibitedScorers = prohibited;
        this.coordinator.init();
        this.countingSumScorer = this.makeCountingSumScorer();
    }

    private Scorer countingDisjunctionSumScorer(List<Scorer> scorers, int minNrShouldMatch) throws IOException {
        return new DisjunctionSumScorer(scorers, minNrShouldMatch){
            private int lastScoredDoc;
            private float lastDocScore;
            {
                this.lastScoredDoc = -1;
                this.lastDocScore = Float.NaN;
            }

            public float score() throws IOException {
                int doc = this.docID();
                if (doc >= this.lastScoredDoc) {
                    if (doc > this.lastScoredDoc) {
                        this.lastDocScore = super.score();
                        this.lastScoredDoc = doc;
                    }
                    ((BooleanScorer2)BooleanScorer2.this).coordinator.nrMatchers += this.nrMatchers;
                }
                return this.lastDocScore;
            }
        };
    }

    private Scorer countingConjunctionSumScorer(List<Scorer> requiredScorers) throws IOException {
        final int requiredNrMatchers = requiredScorers.size();
        return new ConjunctionScorer(defaultSimilarity, requiredScorers){
            private int lastScoredDoc;
            private float lastDocScore;
            {
                super(x0, x1);
                this.lastScoredDoc = -1;
                this.lastDocScore = Float.NaN;
            }

            public float score() throws IOException {
                int doc = this.docID();
                if (doc >= this.lastScoredDoc) {
                    if (doc > this.lastScoredDoc) {
                        this.lastDocScore = super.score();
                        this.lastScoredDoc = doc;
                    }
                    ((BooleanScorer2)BooleanScorer2.this).coordinator.nrMatchers += requiredNrMatchers;
                }
                return this.lastDocScore;
            }
        };
    }

    private Scorer dualConjunctionSumScorer(Scorer req1, Scorer req2) throws IOException {
        return new ConjunctionScorer(defaultSimilarity, req1, req2);
    }

    private Scorer makeCountingSumScorer() throws IOException {
        return this.requiredScorers.size() == 0 ? this.makeCountingSumScorerNoReq() : this.makeCountingSumScorerSomeReq();
    }

    private Scorer makeCountingSumScorerNoReq() throws IOException {
        int nrOptRequired;
        int n = nrOptRequired = this.minNrShouldMatch < 1 ? 1 : this.minNrShouldMatch;
        Scorer requiredCountingSumScorer = this.optionalScorers.size() > nrOptRequired ? this.countingDisjunctionSumScorer(this.optionalScorers, nrOptRequired) : (this.optionalScorers.size() == 1 ? new SingleMatchScorer(this.optionalScorers.get(0)) : this.countingConjunctionSumScorer(this.optionalScorers));
        return this.addProhibitedScorers(requiredCountingSumScorer);
    }

    private Scorer makeCountingSumScorerSomeReq() throws IOException {
        Scorer requiredCountingSumScorer;
        if (this.optionalScorers.size() == this.minNrShouldMatch) {
            ArrayList<Scorer> allReq = new ArrayList<Scorer>(this.requiredScorers);
            allReq.addAll(this.optionalScorers);
            return this.addProhibitedScorers(this.countingConjunctionSumScorer(allReq));
        }
        Scorer scorer = requiredCountingSumScorer = this.requiredScorers.size() == 1 ? new SingleMatchScorer(this.requiredScorers.get(0)) : this.countingConjunctionSumScorer(this.requiredScorers);
        if (this.minNrShouldMatch > 0) {
            return this.addProhibitedScorers(this.dualConjunctionSumScorer(requiredCountingSumScorer, this.countingDisjunctionSumScorer(this.optionalScorers, this.minNrShouldMatch)));
        }
        return new ReqOptSumScorer(this.addProhibitedScorers(requiredCountingSumScorer), this.optionalScorers.size() == 1 ? new SingleMatchScorer(this.optionalScorers.get(0)) : this.countingDisjunctionSumScorer(this.optionalScorers, 1));
    }

    private Scorer addProhibitedScorers(Scorer requiredCountingSumScorer) throws IOException {
        return this.prohibitedScorers.size() == 0 ? requiredCountingSumScorer : new ReqExclScorer(requiredCountingSumScorer, this.prohibitedScorers.size() == 1 ? this.prohibitedScorers.get(0) : new DisjunctionSumScorer(this.prohibitedScorers));
    }

    @Override
    public void score(Collector collector) throws IOException {
        collector.setScorer(this);
        while ((this.doc = this.countingSumScorer.nextDoc()) != Integer.MAX_VALUE) {
            collector.collect(this.doc);
        }
    }

    @Override
    protected boolean score(Collector collector, int max, int firstDocID) throws IOException {
        this.doc = firstDocID;
        collector.setScorer(this);
        while (this.doc < max) {
            collector.collect(this.doc);
            this.doc = this.countingSumScorer.nextDoc();
        }
        return this.doc != Integer.MAX_VALUE;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int nextDoc() throws IOException {
        this.doc = this.countingSumScorer.nextDoc();
        return this.doc;
    }

    @Override
    public float score() throws IOException {
        this.coordinator.nrMatchers = 0;
        float sum = this.countingSumScorer.score();
        return sum * this.coordinator.coordFactors[this.coordinator.nrMatchers];
    }

    @Override
    public int advance(int target) throws IOException {
        this.doc = this.countingSumScorer.advance(target);
        return this.doc;
    }

    private class SingleMatchScorer
    extends Scorer {
        private Scorer scorer;
        private int lastScoredDoc;
        private float lastDocScore;

        SingleMatchScorer(Scorer scorer) {
            super(scorer.getSimilarity());
            this.lastScoredDoc = -1;
            this.lastDocScore = Float.NaN;
            this.scorer = scorer;
        }

        public float score() throws IOException {
            int doc = this.docID();
            if (doc >= this.lastScoredDoc) {
                if (doc > this.lastScoredDoc) {
                    this.lastDocScore = this.scorer.score();
                    this.lastScoredDoc = doc;
                }
                ++((BooleanScorer2)BooleanScorer2.this).coordinator.nrMatchers;
            }
            return this.lastDocScore;
        }

        public int docID() {
            return this.scorer.docID();
        }

        public int nextDoc() throws IOException {
            return this.scorer.nextDoc();
        }

        public int advance(int target) throws IOException {
            return this.scorer.advance(target);
        }
    }

    private class Coordinator {
        float[] coordFactors = null;
        int maxCoord = 0;
        int nrMatchers;

        private Coordinator() {
        }

        void init() {
            this.coordFactors = new float[this.maxCoord + 1];
            Similarity sim = BooleanScorer2.this.getSimilarity();
            for (int i = 0; i <= this.maxCoord; ++i) {
                this.coordFactors[i] = sim.coord(i, this.maxCoord);
            }
        }
    }
}

